/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.mobeffect;

import com.eruannie_9.brewchew.util.mobeffect.BuffRenderer;
import com.eruannie_9.brewchew.util.mobeffect.EffectUtil;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import org.jetbrains.annotations.NotNull;

public class BuffedAbsorption
extends MobEffect {
    private static final float BASE_MAX_HEARTS = 8.0f;
    private static final float START_HEARTS = 2.0f;
    private static final String ABS_AMOUNT_KEY = "brewchew.AbsorptionAmount";

    public BuffedAbsorption() {
        super(MobEffectCategory.BENEFICIAL, 0x2552A5);
    }

    public void m_6385_(@NotNull LivingEntity entity, @NotNull AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        EffectUtil.removeVanillaIfPresent(entity, this, MobEffects.f_19617_);
        if (!entity.m_9236_().f_46443_) {
            float canAdd;
            float ours;
            float maxOurHearts = 8.0f * (float)(amplifier + 1);
            float totalAbs = entity.m_6103_();
            float others = totalAbs - (ours = BuffedAbsorption.getOurAbsorption(entity));
            if (others < 0.0f) {
                float usedFromOurs = Math.abs(others);
                others = 0.0f;
                if ((ours -= usedFromOurs) < 0.0f) {
                    ours = 0.0f;
                }
            }
            if ((canAdd = maxOurHearts - ours) > 0.0f) {
                float heartsToAdd = Math.min(canAdd, 2.0f);
                ours += heartsToAdd;
            }
            float newTotal = others + ours;
            entity.m_7911_(newTotal);
            BuffedAbsorption.setOurAbsorption(entity, ours);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 40 == 0;
    }

    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        float canAdd;
        float ours;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        float maxOurHearts = 8.0f * (float)(amplifier + 1);
        float totalAbs = entity.m_6103_();
        float others = totalAbs - (ours = BuffedAbsorption.getOurAbsorption(entity));
        if (others < 0.0f) {
            float usedFromOurs = Math.abs(others);
            others = 0.0f;
            if ((ours -= usedFromOurs) < 0.0f) {
                ours = 0.0f;
            }
        }
        if (ours < maxOurHearts && entity.m_217043_().m_188501_() < 0.5f && (canAdd = maxOurHearts - ours) > 0.0f) {
            float add = 1.0f;
            if (add > canAdd) {
                add = canAdd;
            }
            ours += add;
        }
        float newTotal = others + ours;
        entity.m_7911_(newTotal);
        BuffedAbsorption.setOurAbsorption(entity, ours);
    }

    public void m_6386_(@NotNull LivingEntity entity, @NotNull AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        if (!entity.m_9236_().f_46443_) {
            float ours;
            float total = entity.m_6103_();
            float newVal = total - (ours = BuffedAbsorption.getOurAbsorption(entity));
            if (newVal < 0.0f) {
                newVal = 0.0f;
            }
            entity.m_7911_(newVal);
            BuffedAbsorption.clearOurAbsorption(entity);
        }
    }

    private static float getOurAbsorption(LivingEntity e) {
        return e.getPersistentData().m_128457_(ABS_AMOUNT_KEY);
    }

    private static void setOurAbsorption(LivingEntity e, float val) {
        e.getPersistentData().m_128350_(ABS_AMOUNT_KEY, val);
    }

    private static void clearOurAbsorption(LivingEntity e) {
        e.getPersistentData().m_128473_(ABS_AMOUNT_KEY);
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new BuffRenderer(this, new ResourceLocation("minecraft", "textures/mob_effect/absorption.png"), new ResourceLocation("brewchew", "textures/mob_effect/buff.png"), true));
    }
}

