/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.mobeffect;

import com.eruannie_9.brewchew.mobeffect.ModEffects;
import com.eruannie_9.brewchew.util.mobeffect.BuffRenderer;
import com.eruannie_9.brewchew.util.mobeffect.EffectUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import org.jetbrains.annotations.NotNull;

public class BuffedPoison
extends MobEffect {
    private static final int BASE_POISON_INTERVAL = 25;
    private static final int AOE_INTERVAL = 40;

    public BuffedPoison() {
        super(MobEffectCategory.HARMFUL, 5149489);
    }

    public boolean m_6584_(int duration, int amplifier) {
        int damageInterval = 25 >> amplifier;
        if (damageInterval < 1) {
            damageInterval = 1;
        }
        boolean doDamageTick = duration % damageInterval == 0;
        boolean doAoETick = duration % 40 == 0;
        return doDamageTick || doAoETick;
    }

    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        MobEffectInstance active = entity.m_21124_((MobEffect)this);
        if (active == null) {
            return;
        }
        int duration = active.m_19557_();
        int damageInterval = 25 >> amplifier;
        if (damageInterval < 1) {
            damageInterval = 1;
        }
        if (duration % damageInterval == 0 && entity.m_21223_() > 1.0f) {
            entity.m_6469_(entity.m_269291_().m_269425_(), 1.0f);
        }
        if (duration % 40 == 0) {
            Level level = entity.m_9236_();
            List nearby = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82377_(1.0, 1.0, 1.0), e -> e.m_6084_() && e != entity);
            for (LivingEntity target : nearby) {
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BUFFED_POISON.get(), duration, amplifier, false, true));
            }
        }
    }

    public void m_6385_(@NotNull LivingEntity entity, @NotNull AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        EffectUtil.removeVanillaIfPresent(entity, this, MobEffects.f_19614_);
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new BuffRenderer(this, new ResourceLocation("minecraft", "textures/mob_effect/poison.png"), new ResourceLocation("brewchew", "textures/mob_effect/buff.png"), true));
    }
}

