/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.mobeffect;

import com.eruannie_9.brewchew.util.mobeffect.BuffRenderer;
import com.eruannie_9.brewchew.util.mobeffect.EffectUtil;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import org.jetbrains.annotations.NotNull;

public class BuffedSpeed
extends MobEffect {
    private static final UUID ON_SNOW_SPEED_UUID = UUID.fromString("b422b98a-0e02-4d0f-a5c4-5b61638913e4");
    private static final AttributeModifier ON_SNOW_SPEED_BONUS = new AttributeModifier(ON_SNOW_SPEED_UUID, "OnSnowBonus", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public BuffedSpeed() {
        super(MobEffectCategory.BENEFICIAL, 8171462);
        this.m_19472_(Attributes.f_22279_, "91AEAA56-376B-4498-935B-2F7F68070635", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        AttributeInstance speedAttr = entity.m_21051_(Attributes.f_22279_);
        if (speedAttr == null) {
            return;
        }
        boolean onSnow = BuffedSpeed.isOnSnow(entity);
        if (onSnow) {
            if (!speedAttr.m_22109_(ON_SNOW_SPEED_BONUS)) {
                speedAttr.m_22118_(ON_SNOW_SPEED_BONUS);
            }
        } else if (speedAttr.m_22109_(ON_SNOW_SPEED_BONUS)) {
            speedAttr.m_22130_(ON_SNOW_SPEED_BONUS);
        }
    }

    private static boolean isOnSnow(LivingEntity entity) {
        BlockState feetState = entity.m_146900_();
        if (BuffedSpeed.isAnySnowBlock(feetState)) {
            return true;
        }
        return BuffedSpeed.isStandingOnSnowShape(entity);
    }

    private static boolean isAnySnowBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_) || state.m_60713_(Blocks.f_152499_) || state.m_60734_() instanceof SnowLayerBlock;
    }

    private static boolean isStandingOnSnowShape(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return false;
        }
        AABB bb = entity.m_20191_();
        double entityFeetY = bb.f_82289_ - 0.05;
        double maxDistanceAboveSnow = 0.1;
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int maxX = Mth.m_14107_((double)bb.f_82291_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxZ = Mth.m_14107_((double)bb.f_82293_);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                BlockPos posBelow = new BlockPos(x, Mth.m_14107_((double)entityFeetY), z);
                BlockState stateBelow = level.m_8055_(posBelow);
                if (!BuffedSpeed.isAnySnowBlock(stateBelow)) continue;
                VoxelShape shape = stateBelow.m_60812_((BlockGetter)level, posBelow);
                if (shape.m_83281_()) {
                    double fallbackHeight = 0.125;
                    double topY = (double)posBelow.m_123342_() + fallbackHeight;
                    if (!(entityFeetY <= topY + 0.1)) continue;
                    return true;
                }
                for (AABB subBox : shape.m_83299_()) {
                    double shapeTopY = (double)posBelow.m_123342_() + subBox.f_82292_;
                    if (!(entityFeetY <= shapeTopY + 0.1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void m_6385_(@NotNull LivingEntity entity, @NotNull AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        EffectUtil.removeVanillaIfPresent(entity, this, MobEffects.f_19596_);
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new BuffRenderer(this, new ResourceLocation("minecraft", "textures/mob_effect/speed.png"), new ResourceLocation("brewchew", "textures/mob_effect/buff.png"), true));
    }
}

