/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.packethandler.pack;

import com.eruannie_9.brewchew.capability.ModCapabilities;
import com.eruannie_9.brewchew.gui.BrewingCauldronGuideScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record SyncGuideMaskPacket(int revealedMask) {
    public static void encode(SyncGuideMaskPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.revealedMask());
    }

    public static SyncGuideMaskPacket decode(FriendlyByteBuf buf) {
        return new SyncGuideMaskPacket(buf.readInt());
    }

    public static void handle(SyncGuideMaskPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.getCapability(ModCapabilities.GUIDE_OBFUSCATION).ifPresent(cap -> {
                        for (int i = 0; i < 32; ++i) {
                            boolean shouldObfuscate = (pkt.revealedMask() & 1 << i) == 0;
                            cap.setPageObfuscated(i, shouldObfuscate);
                        }
                    });
                    BrewingCauldronGuideScreen.setClientMask(pkt.revealedMask());
                }
            });
        }
        context.setPacketHandled(true);
    }
}

