/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.recipe;

import com.eruannie_9.brewchew.recipe.ModRecipes;
import com.eruannie_9.brewchew.util.PotionCombiner;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BrewingCauldronRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;

    public BrewingCauldronRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(@NotNull SimpleContainer c, @NotNull Level level) {
        boolean centerValid;
        ItemStack center = c.m_8020_(4);
        boolean bl = centerValid = (center.m_41614_() || center.m_150930_(Items.f_42502_)) && !center.m_41619_();
        if (!centerValid) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack s = c.m_8020_(i);
            if (s.m_41720_() instanceof PotionItem && s.m_41613_() >= 1) continue;
            return false;
        }
        CompoundTag combined = PotionCombiner.combine(c);
        if (!combined.m_128425_("Potions", 9)) {
            return false;
        }
        ListTag potions = combined.m_128437_("Potions", 10);
        if (potions.isEmpty()) {
            return false;
        }
        CompoundTag single = potions.m_128728_(0);
        if (!single.m_128425_("Effects", 9)) {
            return false;
        }
        ListTag effects = single.m_128437_("Effects", 10);
        return !effects.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer c, @NotNull RegistryAccess registryAccess) {
        ItemStack result = c.m_8020_(4).m_41777_();
        result.m_41764_(1);
        CompoundTag combined = PotionCombiner.combine(c);
        result.m_41784_().m_128365_("BrewChewPotionData", (Tag)combined);
        String name = result.m_41786_().getString();
        String goldJson = BrewingCauldronRecipe.nameJson(name, ChatFormatting.GOLD);
        CompoundTag display = result.m_41784_().m_128469_("display");
        display.m_128359_("Name", goldJson);
        result.m_41784_().m_128365_("display", (Tag)display);
        return result;
    }

    private static String nameJson(String s, ChatFormatting color) {
        String esc = s.replace("\"", "\\\"");
        return String.format("{\"text\":\"%s\",\"color\":\"%s\",\"italic\":false}", esc, color.m_126666_().toLowerCase());
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BREWING_CAULDRON_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return ModRecipes.BREWING_CAULDRON_RECIPE_TYPE;
    }
}

