/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.renderer;

import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.util.render.block.BounceState;
import com.eruannie_9.brewchew.util.render.block.MotionState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BrewingCauldronFoodRenderer
implements BlockEntityRenderer<BrewingCauldronBlockEntity> {
    private static final float SWIRL_RADIUS = 0.03f;
    private static final float SWIRL_SPEED = 0.025f;
    private static final float DRIFT_SCALE = 0.4f;
    private static final float BOB_FREQ1 = 0.18f;
    private static final float BOB_FREQ2 = 0.06f;
    private static final float TILT_FREQ = 0.1f;
    private static final float TILT_RANGE = 5.0f;
    private static final float SPIN_SPEED = 0.005f;
    private static final float ITEM_RENDER_SCALE = 0.4f;
    private static final int MAX_COPIES = 5;
    private static final int[] COPY_THRESHOLDS = new int[]{1, 15, 31, 47, 64};

    public void render(@NotNull BrewingCauldronBlockEntity entity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        ItemStack foodStack = entity.getContainer().m_8020_(4);
        if (foodStack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.75f, 0.5f);
        long gameTime = entity.m_58898_() ? Objects.requireNonNull(entity.m_58904_()).m_46467_() : 0L;
        float time = (float)gameTime + partialTicks;
        float swirlAngle = time * 0.025f;
        float swirlX = 0.03f * Mth.m_14089_((float)swirlAngle);
        float swirlZ = 0.03f * Mth.m_14031_((float)swirlAngle);
        poseStack.m_252880_(swirlX, 0.0f, swirlZ);
        MotionState ms = entity.motionState;
        float driftX = ms.xPrev + (ms.x - ms.xPrev) * partialTicks;
        float driftZ = ms.zPrev + (ms.z - ms.zPrev) * partialTicks;
        poseStack.m_252880_(driftX * 0.4f, 0.0f, driftZ * 0.4f);
        float bob1 = Mth.m_14031_((float)(time * 0.18f)) * 0.015f;
        float bob2 = Mth.m_14031_((float)(time * 0.06f + 1.4f)) * 0.007f;
        poseStack.m_252880_(0.0f, bob1 + bob2, 0.0f);
        float tiltX = Mth.m_14031_((float)(time * 0.1f + 1.2f)) * 5.0f;
        float tiltZ = Mth.m_14031_((float)(time * 0.1f * 0.8f + 2.1f)) * 5.0f * 0.7f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(tiltX));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(tiltZ));
        float spinAngle = time * 0.005f * 360.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(spinAngle));
        int stackCount = foodStack.m_41613_();
        int copyCount = this.getCopyCount(stackCount);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        for (int i = 0; i < copyCount; ++i) {
            poseStack.m_85836_();
            float zOff = ((float)i - (float)(copyCount - 1) / 2.0f) * 0.12f;
            float yOff = (float)i * 0.03f + entity.bounceStates[i].yOffset;
            poseStack.m_252880_(0.0f, yOff, zOff);
            float localTime = time + (float)i * 5.19f;
            float rippleY = BrewingCauldronFoodRenderer.ripple(localTime);
            poseStack.m_252880_(0.0f, rippleY, 0.0f);
            float bounceY = BrewingCauldronFoodRenderer.bounce(entity.bounceStates[i], localTime, rippleY);
            poseStack.m_252880_(0.0f, bounceY, 0.0f);
            float bobY = BrewingCauldronFoodRenderer.smoothBob(localTime, i);
            poseStack.m_252880_(0.0f, bobY, 0.0f);
            float tiltSide = Mth.m_14031_((float)(localTime * 0.15f)) * 2.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(tiltSide));
            float tiltFB = Mth.m_14031_((float)(localTime * 0.13f)) * 2.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(tiltFB));
            Minecraft.m_91087_().m_91291_().m_269128_(foodStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, entity.m_58904_(), 0);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private int getCopyCount(int stackCount) {
        int copyCount = 1;
        for (int i = 0; i < COPY_THRESHOLDS.length; ++i) {
            if (stackCount > COPY_THRESHOLDS[i]) continue;
            copyCount = i + 1;
            break;
        }
        copyCount = Math.min(copyCount, 5);
        return copyCount;
    }

    private static float ripple(float t) {
        float a = Mth.m_14031_((float)(t * 0.22f)) * 0.003f;
        float b = Mth.m_14031_((float)(t * 0.07f + 1.3f)) * 0.002f;
        return a + b;
    }

    private static float smoothBob(float t, int index) {
        float BOB_SPEED = 0.1f;
        float BOB_HEIGHT = 0.04f;
        return Mth.m_14031_((float)((t + (float)index * 2.0f) * 0.1f)) * 0.04f;
    }

    private static float bounce(BounceState s, float t, float baseY) {
        float elapsed = t - s.bounceStartTime;
        if (elapsed > s.bounceDuration) {
            if (t >= s.bounceStartTime + s.bubblePeriod) {
                s.bounceStartTime = t;
                s.bounceAnchor = baseY;
                s.bounceCount = 2 + (int)(Math.random() * 3.0);
                s.decayFactor = 1.0f + (float)Math.random() * 0.5f;
                s.bounceDuration = 14.0f + (float)Math.random() * 2.0f;
                s.bubblePeriod = 160.0f + (float)Math.random() * 140.0f;
            }
            return 0.0f;
        }
        float fraction = elapsed / s.bounceDuration;
        float bubbleMax = 0.035f + (float)Math.random() * 0.015f;
        float damping = (float)Math.exp(-s.decayFactor * fraction * fraction);
        float wave = Mth.m_14031_((float)((float)s.bounceCount * (float)Math.PI * fraction));
        return bubbleMax * damping * wave;
    }

    public boolean shouldRenderOffScreen(@NotNull BrewingCauldronBlockEntity entity) {
        return false;
    }
}

