/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.renderer;

import com.eruannie_9.brewchew.block.BrewingCauldronBlock;
import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BrewingCauldronWaterPlaneRenderer
implements BlockEntityRenderer<BrewingCauldronBlockEntity> {
    private static final float WATER_PLANE_OFFSET = 0.16666874f;
    private static final float WATER_PLANE_SIZE = 0.66666245f;
    private static final float FULL_OPACITY = 1.0f;

    public void render(@NotNull BrewingCauldronBlockEntity entity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = entity.m_58900_();
        if (state.m_61138_(BrewingCauldronBlock.HALF) && state.m_61143_(BrewingCauldronBlock.HALF) == DoubleBlockHalf.LOWER) {
            this.renderAnimatedWaterPlane(entity, state, poseStack, buffer, packedOverlay);
        }
    }

    private void renderAnimatedWaterPlane(BrewingCauldronBlockEntity entity, BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedOverlay) {
        if (entity.m_58904_() == null) {
            return;
        }
        int combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Direction facing = (Direction)state.m_61143_((Property)BrewingCauldronBlock.FACING);
        float yRot = -facing.m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        poseStack.m_252880_(0.16666874f, 0.777775f, 0.16666874f);
        FluidState fluidState = Fluids.f_76193_.m_76145_();
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fluidState.m_76152_());
        ResourceLocation stillRL = ext.getStillTexture(fluidState, null, null);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillRL);
        boolean isFabulous = Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FABULOUS;
        RenderType renderType = isFabulous ? RenderType.m_110469_() : RenderType.m_110451_();
        VertexConsumer consumer = buffer.m_6299_(renderType);
        int colorInt = entity.colorTransition.getCurrentColor();
        float r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorInt & 0xFF) / 255.0f;
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.66666245f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_86008_(packedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.66666245f, 0.0f, 0.66666245f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_86008_(packedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.66666245f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_86008_(packedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(@NotNull BrewingCauldronBlockEntity entity) {
        return false;
    }
}

