/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.sound;

import com.eruannie_9.brewchew.block.BrewingCauldronBlockEntity;
import com.eruannie_9.brewchew.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoilingSoundInstance
extends AbstractTickableSoundInstance {
    private final BlockPos pos;
    private boolean isFadingOut;
    private int fadeOutTickCount;
    private float fadeVolume = 1.0f;

    public BoilingSoundInstance(BlockPos pos) {
        super((SoundEvent)ModSounds.BOILING_WATER.get(), SoundSource.BLOCKS, RandomSource.m_216327_());
        this.pos = pos;
        this.f_119575_ = (double)pos.m_123341_() + 0.5;
        this.f_119576_ = (double)pos.m_123342_() + 0.5;
        this.f_119577_ = (double)pos.m_123343_() + 0.5;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 1.0f;
        this.f_119574_ = 1.0f;
        this.f_119582_ = false;
        this.f_119580_ = SoundInstance.Attenuation.LINEAR;
    }

    public void m_7788_() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            this.m_119609_();
            return;
        }
        BlockEntity be = level.m_7702_(this.pos);
        if (!(be instanceof BrewingCauldronBlockEntity)) {
            this.m_119609_();
            return;
        }
        BrewingCauldronBlockEntity cauldron = (BrewingCauldronBlockEntity)be;
        if (!this.isFadingOut && !cauldron.hasAnyPotion()) {
            this.startFadeOut();
        }
        if (this.isFadingOut) {
            ++this.fadeOutTickCount;
            int fadeOutDuration = 20;
            this.fadeVolume = Math.max(0.0f, 1.0f - (float)this.fadeOutTickCount / (float)fadeOutDuration);
            if (this.fadeVolume <= 0.0f) {
                this.m_119609_();
                return;
            }
        }
        this.f_119575_ = (double)this.pos.m_123341_() + 0.5;
        this.f_119576_ = (double)this.pos.m_123342_() + 0.5;
        this.f_119577_ = (double)this.pos.m_123343_() + 0.5;
        this.f_119573_ = this.fadeVolume;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_5842_()) {
            this.f_119574_ = 0.7f;
            this.f_119573_ *= 0.6f;
        } else {
            this.f_119574_ = 1.0f;
        }
    }

    public void manualStop() {
        this.startFadeOut();
    }

    private void startFadeOut() {
        if (!this.isFadingOut) {
            this.isFadingOut = true;
            this.fadeOutTickCount = 0;
            this.fadeVolume = 1.0f;
        }
    }
}

