/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoreUtil {
    private static final String DISPLAY = "display";
    private static final String LORE = "Lore";

    private LoreUtil() {
    }

    public static void updateEffectsLore(@NotNull ItemStack stack, int labelColor, int valueColor) {
        StringTag lastString;
        Tag lastTag;
        String t;
        int leftover;
        int min;
        int sec;
        CompoundTag mainTag = stack.m_41784_();
        CompoundTag brewData = mainTag.m_128469_("BrewChewPotionData");
        if (!brewData.m_128425_("Potions", 9)) {
            return;
        }
        ListTag potions = brewData.m_128437_("Potions", 10);
        if (potions.isEmpty()) {
            return;
        }
        CompoundTag firstPotion = potions.m_128728_(0);
        if (!firstPotion.m_128425_("Effects", 9)) {
            return;
        }
        ListTag effects = firstPotion.m_128437_("Effects", 10);
        if (effects.isEmpty()) {
            return;
        }
        CompoundTag display = stack.m_41698_(DISPLAY);
        ListTag loreList = display.m_128437_(LORE, 8);
        loreList.add((Object)LoreUtil.createBlankLine());
        LinkedHashMap<MobEffect, Integer> effectDurations = new LinkedHashMap<MobEffect, Integer>();
        for (int i = 0; i < effects.size(); ++i) {
            MobEffect loc;
            CompoundTag e = effects.m_128728_(i);
            if (!e.m_128441_("Effect") || (loc = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(e.m_128461_("Effect")))) == null) continue;
            int amp = e.m_128451_("Amplifier");
            int dur = e.m_128451_("Duration");
            int lvl = amp + 1;
            loreList.add((Object)LoreUtil.createTwoColorLine("Effect: ", loc.m_19482_().getString(), labelColor, valueColor));
            loreList.add((Object)LoreUtil.createTwoColorLine("Amplifier: ", String.valueOf(lvl), labelColor, valueColor));
            if (loc.m_8093_()) {
                loreList.add((Object)LoreUtil.createTwoColorLine("Duration: ", "Instant", labelColor, valueColor));
            } else if (dur > 0) {
                sec = dur / 20;
                min = sec / 60;
                leftover = sec % 60;
                t = String.format("%d:%02d", min, leftover);
                loreList.add((Object)LoreUtil.createTwoColorLine("Duration: ", t, labelColor, valueColor));
            }
            loreList.add((Object)LoreUtil.createBlankLine());
            effectDurations.put(loc, dur);
        }
        if (!loreList.isEmpty() && (lastTag = loreList.get(loreList.size() - 1)) instanceof StringTag && (lastString = (StringTag)lastTag).m_7916_().contains("\"text\":\" \"")) {
            loreList.remove(loreList.size() - 1);
        }
        if (stack.m_150930_(Items.f_42502_) && !effectDurations.isEmpty()) {
            loreList.add((Object)LoreUtil.createBlankLine());
            loreList.add((Object)LoreUtil.createSingleColorLine("Bite Duration:", labelColor));
            int slices = 7;
            for (Map.Entry e : effectDurations.entrySet()) {
                MobEffect mob = (MobEffect)e.getKey();
                int total = (Integer)e.getValue();
                if (mob.m_8093_()) {
                    loreList.add((Object)LoreUtil.createCakeLine(mob.m_19482_().getString(), "Instant", labelColor, valueColor));
                    continue;
                }
                if (total <= 0) continue;
                int sliceDur = total / slices;
                sec = sliceDur / 20;
                min = sec / 60;
                leftover = sec % 60;
                t = String.format("%d:%02d", min, leftover);
                loreList.add((Object)LoreUtil.createCakeLine(mob.m_19482_().getString(), t, labelColor, valueColor));
            }
        }
        display.m_128365_(LORE, (Tag)loreList);
        stack.m_41784_().m_128365_(DISPLAY, (Tag)display);
    }

    public static void addInfusedFlowerLore(@NotNull ItemStack stack, @Nullable Item flower, int labelColor, int valueColor) {
        StringTag sTag;
        Tag lastTag;
        if (flower == null || flower == Items.f_41852_) {
            return;
        }
        String flowerName = flower.m_41466_().getString();
        CompoundTag displayTag = stack.m_41698_(DISPLAY);
        ListTag loreList = displayTag.m_128437_(LORE, 8);
        if (!loreList.isEmpty() && (lastTag = loreList.get(loreList.size() - 1)) instanceof StringTag && !(sTag = (StringTag)lastTag).m_7916_().contains("\"text\":\" \"")) {
            loreList.add((Object)LoreUtil.createBlankLine());
        }
        StringTag infusedLine = LoreUtil.createTwoColorLine("Infused Flower: ", flowerName, labelColor, valueColor);
        for (Tag t : loreList) {
            StringTag sTag2;
            if (!(t instanceof StringTag) || !(sTag2 = (StringTag)t).m_7916_().equals(infusedLine.m_7916_())) continue;
            displayTag.m_128365_(LORE, (Tag)loreList);
            stack.m_41700_(DISPLAY, (Tag)displayTag);
            return;
        }
        loreList.add((Object)infusedLine);
        displayTag.m_128365_(LORE, (Tag)loreList);
        stack.m_41700_(DISPLAY, (Tag)displayTag);
    }

    private static StringTag createTwoColorLine(String label, String value, int labelRGB, int valueRGB) {
        TextColor l = TextColor.m_131266_((int)(labelRGB & 0xFFFFFF));
        TextColor v = TextColor.m_131266_((int)(valueRGB & 0xFFFFFF));
        MutableComponent comp = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)label).m_6270_(Style.f_131099_.m_131148_(l).m_131155_(Boolean.valueOf(false)))).m_7220_((Component)Component.m_237113_((String)value).m_6270_(Style.f_131099_.m_131148_(v).m_131155_(Boolean.valueOf(false))));
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)comp));
    }

    private static StringTag createSingleColorLine(String text, int rgb) {
        TextColor c = TextColor.m_131266_((int)(rgb & 0xFFFFFF));
        MutableComponent comp = Component.m_237113_((String)text).m_6270_(Style.f_131099_.m_131148_(c).m_131155_(Boolean.valueOf(false)));
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)comp));
    }

    private static StringTag createCakeLine(String effectName, String time, int labelRGB, int valueRGB) {
        TextColor label = TextColor.m_131266_((int)(labelRGB & 0xFFFFFF));
        TextColor val = TextColor.m_131266_((int)(valueRGB & 0xFFFFFF));
        MutableComponent c = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"- ").m_6270_(Style.f_131099_.m_131148_(val).m_131155_(Boolean.valueOf(false)))).m_7220_((Component)Component.m_237113_((String)effectName).m_6270_(Style.f_131099_.m_131148_(label).m_131155_(Boolean.valueOf(false)))).m_7220_((Component)Component.m_237113_((String)": ").m_6270_(Style.f_131099_.m_131148_(label).m_131155_(Boolean.valueOf(false)))).m_7220_((Component)Component.m_237113_((String)time).m_6270_(Style.f_131099_.m_131148_(val).m_131155_(Boolean.valueOf(false))));
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)c));
    }

    private static StringTag createBlankLine() {
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)" ")));
    }
}

