/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class PotionCombiner {
    private PotionCombiner() {
    }

    public static CompoundTag combine(@NotNull SimpleContainer c) {
        HashMap<ResourceLocation, List> grouped = new HashMap<ResourceLocation, List>();
        for (int s = 0; s < 4; ++s) {
            ItemStack stack = c.m_8020_(s);
            List list = PotionUtils.m_43547_((ItemStack)stack);
            for (MobEffectInstance e2 : list) {
                ResourceLocation id = ForgeRegistries.MOB_EFFECTS.getKey((Object)e2.m_19544_());
                if (id == null) continue;
                grouped.computeIfAbsent(id, k -> new ArrayList()).add(new EffectData(e2.m_19564_(), e2.m_19557_()));
            }
        }
        HashMap<ResourceLocation, EffectResult> combined = new HashMap<ResourceLocation, EffectResult>();
        for (Map.Entry entry : grouped.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            List list = (List)entry.getValue();
            int maxAmp = list.stream().mapToInt(e -> e.amplifier).max().orElse(0);
            int total = 0;
            for (EffectData d : list) {
                int factor = d.amplifier == maxAmp ? 2 : 8 + 4 * Math.max(maxAmp - d.amplifier - 1, 0);
                int adjusted = d.duration / factor;
                if (adjusted <= 0) continue;
                total += adjusted;
            }
            EffectResult res = new EffectResult();
            res.amplifier = maxAmp;
            res.duration = total;
            combined.put(id, res);
        }
        CompoundTag root = new CompoundTag();
        ListTag listTag = new ListTag();
        CompoundTag single = new CompoundTag();
        ListTag effList = new ListTag();
        for (Map.Entry e3 : combined.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.m_128359_("Effect", ((ResourceLocation)e3.getKey()).toString());
            t.m_128405_("Amplifier", ((EffectResult)e3.getValue()).amplifier);
            t.m_128405_("Duration", ((EffectResult)e3.getValue()).duration);
            effList.add((Object)t);
        }
        single.m_128365_("Effects", (Tag)effList);
        listTag.add((Object)single);
        root.m_128365_("Potions", (Tag)listTag);
        return root;
    }

    private static class EffectData {
        final int amplifier;
        final int duration;

        private EffectData(int amp, int dur) {
            this.amplifier = amp;
            this.duration = dur;
        }
    }

    private static class EffectResult {
        int amplifier;
        int duration;

        private EffectResult() {
        }
    }
}

