/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.cake;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class CakeSaveData
extends SavedData {
    private static final String FILE_NAME = "brew_chew_cake_data";
    private final Map<GlobalPos, CompoundTag> cakeDataMap = new HashMap<GlobalPos, CompoundTag>();

    public static CakeSaveData load(CompoundTag nbt) {
        CakeSaveData data = new CakeSaveData();
        ListTag list = nbt.m_128437_("CakeData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            String dim = entry.m_128461_("Dimension");
            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim));
            int x = entry.m_128451_("X");
            int y = entry.m_128451_("Y");
            int z = entry.m_128451_("Z");
            BlockPos pos = new BlockPos(x, y, z);
            CompoundTag dataTag = entry.m_128469_("Data");
            GlobalPos gPos = GlobalPos.m_122643_((ResourceKey)levelKey, (BlockPos)pos);
            data.cakeDataMap.put(gPos, dataTag);
        }
        return data;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Map.Entry<GlobalPos, CompoundTag> entry : this.cakeDataMap.entrySet()) {
            GlobalPos gPos = entry.getKey();
            CompoundTag dataTag = entry.getValue();
            CompoundTag wrapper = new CompoundTag();
            wrapper.m_128359_("Dimension", gPos.m_122640_().m_135782_().toString());
            wrapper.m_128405_("X", gPos.m_122646_().m_123341_());
            wrapper.m_128405_("Y", gPos.m_122646_().m_123342_());
            wrapper.m_128405_("Z", gPos.m_122646_().m_123343_());
            wrapper.m_128365_("Data", (Tag)dataTag);
            list.add((Object)wrapper);
        }
        nbt.m_128365_("CakeData", (Tag)list);
        return nbt;
    }

    public CompoundTag getData(GlobalPos posKey) {
        return this.cakeDataMap.get(posKey);
    }

    public void putData(GlobalPos posKey, CompoundTag data) {
        this.cakeDataMap.put(posKey, data.m_6426_());
        this.m_77762_();
    }

    public void removeData(GlobalPos posKey) {
        this.cakeDataMap.remove(posKey);
        this.m_77762_();
    }

    public static CakeSaveData get(Level level) {
        if (level.m_5776_()) {
            throw new IllegalStateException("BrewChewCakeSavedData accessed on client side!");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (CakeSaveData)storage.m_164861_(CakeSaveData::load, CakeSaveData::new, FILE_NAME);
    }
}

