/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.flower;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class FlowerAnimationRenderer {
    private final ItemStack flowerStack;
    private float startPosX;
    private float startPosY;
    private float velocityX;
    private float velocityY;
    private float gravity;
    private float duration;
    private float rotationAngle;
    private float rotationSpeed;
    private float rotationAxisX;
    private float rotationAxisY;
    private float rotationAxisZ;
    private float baseSize;
    private float fadeInThreshold;
    private float fadeOutThreshold;
    private float progress = 0.0f;

    public FlowerAnimationRenderer(ItemStack flowerStack) {
        this.flowerStack = flowerStack;
        this.baseSize = 16.0f;
    }

    public void update(float speedFactor) {
        if (this.progress < 1.0f) {
            this.progress += speedFactor * (1.0f / this.duration);
            if (this.progress > 1.0f) {
                this.progress = 1.0f;
            }
        }
        this.rotationAngle = (this.rotationAngle + this.rotationSpeed * speedFactor) % 360.0f;
    }

    public void draw(GuiGraphics guiGraphics, MultiBufferSource buffers) {
        if (this.progress >= 1.0f) {
            return;
        }
        float t = this.progress;
        float xPos = this.startPosX + this.velocityX * t;
        float yPos = this.startPosY + this.velocityY * t + 0.5f * this.gravity * (t * t);
        float alpha = 1.0f;
        if (t < this.fadeInThreshold) {
            alpha = t / this.fadeInThreshold;
        } else {
            float fadeOutStart = 1.0f - this.fadeOutThreshold;
            if (t > fadeOutStart) {
                float fadeT = (t - fadeOutStart) / this.fadeOutThreshold;
                alpha = 1.0f - fadeT;
            }
        }
        alpha = Mth.m_14036_((float)alpha, (float)0.05f, (float)1.0f);
        float scale = 0.8f + 0.3f * (float)Math.sin(Math.PI * (double)t);
        float finalScale = scale * this.baseSize;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(xPos, yPos, 300.0f);
        poseStack.m_252781_(Axis.m_253057_((Vector3f)new Vector3f(this.rotationAxisX, this.rotationAxisY, this.rotationAxisZ)).m_252977_(this.rotationAngle));
        poseStack.m_85841_(finalScale, finalScale, finalScale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        BakedModel model = itemRenderer.m_174264_(this.flowerStack, null, null, 0);
        VertexConsumer baseConsumer = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_));
        AlphaOverrideConsumer alphaConsumer = new AlphaOverrideConsumer(baseConsumer, alpha * 255.0f);
        itemRenderer.m_115143_(this.flowerStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)new SingleConsumerBuffer(alphaConsumer), 0xF000F0, OverlayTexture.f_118083_, model);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public void initAvoidCollisions(RandomSource random, int boxLeft, int boxRight, int boxTop, int boxBottom, int[][] spawnBounds, int[] disappearBounds, List<FlowerAnimationRenderer> existing) {
        int maxTries = 10;
        for (int attempt = 0; attempt < maxTries; ++attempt) {
            this.generateRandomPath(random, boxLeft, boxRight, boxTop, boxBottom, spawnBounds, disappearBounds);
            boolean overlap = false;
            for (FlowerAnimationRenderer other : existing) {
                float dy;
                float dx;
                if (other == this || !((dx = this.startPosX - other.startPosX) * dx + (dy = this.startPosY - other.startPosY) * dy < 324.0f)) continue;
                overlap = true;
                break;
            }
            if (!overlap) break;
        }
    }

    private void generateRandomPath(RandomSource random, int boxLeft, int boxRight, int boxTop, int boxBottom, int[][] spawnBounds, int[] disappearBounds) {
        float az;
        float ay;
        int[] region = spawnBounds[random.m_188503_(spawnBounds.length)];
        int sw = region[2] - region[0] + 1;
        int sh = region[3] - region[1] + 1;
        this.startPosX = boxLeft + region[0] + random.m_188503_(Math.max(sw, 1));
        this.startPosY = boxTop + region[1] + random.m_188503_(Math.max(sh, 1));
        int dw = disappearBounds[2] - disappearBounds[0] + 1;
        int dh = disappearBounds[3] - disappearBounds[1] + 1;
        float endX = boxLeft + disappearBounds[0] + random.m_188503_(Math.max(dw, 1));
        float endY = boxTop + disappearBounds[1] + random.m_188503_(Math.max(dh, 1)) + 8;
        this.velocityX = endX - this.startPosX;
        this.velocityY = Mth.m_14179_((float)random.m_188501_(), (float)8.0f, (float)20.0f);
        this.gravity = 2.5f * (endY - this.startPosY - this.velocityY);
        this.duration = Mth.m_14179_((float)random.m_188501_(), (float)100.0f, (float)160.0f);
        this.fadeInThreshold = Mth.m_14179_((float)random.m_188501_(), (float)0.15f, (float)0.25f);
        this.fadeOutThreshold = Mth.m_14179_((float)random.m_188501_(), (float)0.25f, (float)0.35f);
        float ax = random.m_188501_() - 0.5f;
        float len = Mth.m_14116_((float)(ax * ax + (ay = random.m_188501_() - 0.5f) * ay + (az = random.m_188501_() - 0.5f) * az));
        if (len < 1.0E-5f) {
            ax = 0.0f;
            ay = 1.0f;
            az = 0.0f;
            len = 1.0f;
        }
        this.rotationAxisX = ax / len;
        this.rotationAxisY = ay / len;
        this.rotationAxisZ = az / len;
        this.rotationSpeed = Mth.m_14179_((float)random.m_188501_(), (float)0.3f, (float)0.8f);
        this.rotationAngle = random.m_188501_() * 360.0f;
        this.baseSize = Mth.m_14179_((float)random.m_188501_(), (float)14.0f, (float)17.0f);
        this.progress = 0.0f;
        this.startPosX = Mth.m_14036_((float)this.startPosX, (float)boxLeft, (float)boxRight);
        this.startPosY = Mth.m_14036_((float)this.startPosY, (float)boxTop, (float)boxBottom);
    }

    public float getProgress() {
        return this.progress;
    }

    private record AlphaOverrideConsumer(VertexConsumer parent, float alphaValue) implements VertexConsumer
    {
        @NotNull
        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.parent.m_5483_(x, y, z);
        }

        @NotNull
        public VertexConsumer m_6122_(int r, int g, int b, int a) {
            int finalAlpha = (int)this.alphaValue;
            int minAlpha = 4;
            if (finalAlpha < minAlpha) {
                finalAlpha = minAlpha;
            }
            if (finalAlpha > 255) {
                finalAlpha = 255;
            }
            return this.parent.m_6122_(r, g, b, finalAlpha);
        }

        @NotNull
        public VertexConsumer m_7421_(float u, float v) {
            return this.parent.m_7421_(u, v);
        }

        @NotNull
        public VertexConsumer m_7122_(int u, int v) {
            return this.parent.m_7122_(u, v);
        }

        @NotNull
        public VertexConsumer m_7120_(int u, int v) {
            return this.parent.m_7120_(u, v);
        }

        @NotNull
        public VertexConsumer m_5601_(float nx, float ny, float nz) {
            return this.parent.m_5601_(nx, ny, nz);
        }

        public void m_5752_() {
            this.parent.m_5752_();
        }

        public void m_7404_(int r, int g, int b, int a) {
            this.parent.m_7404_(r, g, b, a);
        }

        public void m_141991_() {
            this.parent.m_141991_();
        }
    }

    private static final class SingleConsumerBuffer
    implements MultiBufferSource {
        private final VertexConsumer single;

        SingleConsumerBuffer(VertexConsumer vertexConsumer) {
            this.single = vertexConsumer;
        }

        @NotNull
        public VertexConsumer m_6299_(@NotNull RenderType type) {
            return this.single;
        }
    }
}

