/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.flower;

import com.eruannie_9.brewchew.mobeffect.ModEffects;
import com.eruannie_9.brewchew.util.flower.FlowerTooltipStyler;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.registries.ForgeRegistries;

public final class FlowerEffectUtil {
    private static final Map<FlowerTooltipStyler.FlowerMode, FlowerData> FLOWER_DATA = Map.ofEntries(FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.POPPY, new FlowerData(MobEffects.f_19600_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_STRENGTH.get())), 100, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.PINK_TULIP, new FlowerData(MobEffects.f_19605_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_REGENERATION.get())), 0, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.WHITE_TULIP, new FlowerData(MobEffects.f_19591_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_SLOW_FALLING.get())), 0, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.RED_TULIP, new FlowerData(MobEffects.f_19602_, () -> null, 0, 1, FlowerEffectUtil::injectLuck)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.OXEYE, new FlowerData(MobEffects.f_19596_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_SPEED.get())), 0, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.LILY_OF_THE_VALLEY, new FlowerData(MobEffects.f_19614_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_POISON.get())), 0, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.CORNFLOWER, new FlowerData(MobEffects.f_19608_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_WATER_BREATHING.get())), 400, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.BLUE_ORCHID, new FlowerData(MobEffects.f_19597_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_SLOWNESS.get())), 0, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.DANDELION, new FlowerData(MobEffects.f_19603_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_JUMP.get())), 100, 1, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.ORANGE_TULIP, new FlowerData(MobEffects.f_19607_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_FIRE_RESISTANCE.get())), 1200, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.AZURE_BLUET, new FlowerData(MobEffects.f_19598_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_HASTE.get())), 200, 0, null)), FlowerEffectUtil.entry(FlowerTooltipStyler.FlowerMode.ALLIUM, new FlowerData(MobEffects.f_19617_, () -> ForgeRegistries.MOB_EFFECTS.getKey((Object)((MobEffect)ModEffects.BUFFED_ABSORPTION.get())), 300, 0, null)));

    private FlowerEffectUtil() {
    }

    public static void applyBonusIfPresent(FlowerTooltipStyler.FlowerMode mode, MobEffect effect, CompoundTag effectTag, int oldDuration, int oldAmplifier, ListTag effectsList) {
        ResourceLocation newKey;
        FlowerData data = FLOWER_DATA.get((Object)mode);
        if (data == null || data.triggerEffect() != effect) {
            return;
        }
        ResourceLocation resourceLocation = newKey = data.buffedKey() == null ? null : data.buffedKey().get();
        if (newKey != null) {
            effectTag.m_128359_("Effect", newKey.toString());
        }
        effectTag.m_128405_("Duration", oldDuration + data.extraDuration());
        effectTag.m_128405_("Amplifier", oldAmplifier + data.extraAmplifier());
        effectTag.m_128405_("BrewChewBackgroundColor", mode.getBackgroundColor());
        if (data.additionalLogic() != null) {
            data.additionalLogic().accept(effectsList);
        }
    }

    public static boolean flowerMatchesEffect(Item flowerItem, ItemStack resultStack) {
        FlowerTooltipStyler.FlowerMode mode = FlowerTooltipStyler.getFlowerMode(flowerItem);
        FlowerData data = FLOWER_DATA.get((Object)mode);
        if (data == null) {
            return false;
        }
        Set<ResourceLocation> effects = FlowerEffectUtil.collectEffectKeys(resultStack);
        if (mode == FlowerTooltipStyler.FlowerMode.RED_TULIP) {
            return effects.contains(ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19621_));
        }
        ResourceLocation buffedKey = data.buffedKey() == null ? null : data.buffedKey().get();
        return buffedKey != null && effects.contains(buffedKey);
    }

    private static Set<ResourceLocation> collectEffectKeys(ItemStack stack) {
        CompoundTag brew;
        HashSet<ResourceLocation> out = new HashSet<ResourceLocation>();
        PotionUtils.m_43547_((ItemStack)stack).forEach(inst -> {
            ResourceLocation key = ForgeRegistries.MOB_EFFECTS.getKey((Object)inst.m_19544_());
            if (key != null) {
                out.add(key);
            }
        });
        if (stack.m_41782_() && (brew = Objects.requireNonNull(stack.m_41783_()).m_128469_("BrewChewPotionData")).m_128425_("Potions", 9)) {
            ListTag potions = brew.m_128437_("Potions", 10);
            for (int i = 0; i < potions.size(); ++i) {
                ListTag effList = potions.m_128728_(i).m_128437_("Effects", 10);
                for (int j = 0; j < effList.size(); ++j) {
                    CompoundTag eff = effList.m_128728_(j);
                    if (!eff.m_128425_("Effect", 8)) continue;
                    out.add(new ResourceLocation(eff.m_128461_("Effect")));
                }
            }
        }
        return out;
    }

    private static void injectLuck(ListTag effectsList) {
        CompoundTag luck = new CompoundTag();
        ResourceLocation key = ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19621_);
        if (key != null) {
            luck.m_128359_("Effect", key.toString());
        }
        luck.m_128405_("Duration", 1200);
        luck.m_128405_("Amplifier", 0);
        effectsList.add((Object)luck);
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return Map.entry(k, v);
    }

    private record FlowerData(MobEffect triggerEffect, Supplier<ResourceLocation> buffedKey, int extraDuration, int extraAmplifier, Consumer<ListTag> additionalLogic) {
    }
}

