/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.flower;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class FlowerTooltipStyler {
    private static final Map<Item, FlowerMode> MODE_MAP = new HashMap<Item, FlowerMode>();

    @Nullable
    public static FlowerMode getFlowerMode(@Nullable Item flower) {
        return MODE_MAP.getOrDefault(flower, FlowerMode.NONE);
    }

    static {
        MODE_MAP.put(Items.f_41939_, FlowerMode.DANDELION);
        MODE_MAP.put(Items.f_41940_, FlowerMode.POPPY);
        MODE_MAP.put(Items.f_41945_, FlowerMode.ORANGE_TULIP);
        MODE_MAP.put(Items.f_41944_, FlowerMode.RED_TULIP);
        MODE_MAP.put(Items.f_41946_, FlowerMode.WHITE_TULIP);
        MODE_MAP.put(Items.f_41947_, FlowerMode.PINK_TULIP);
        MODE_MAP.put(Items.f_41948_, FlowerMode.OXEYE);
        MODE_MAP.put(Items.f_41941_, FlowerMode.BLUE_ORCHID);
        MODE_MAP.put(Items.f_41942_, FlowerMode.ALLIUM);
        MODE_MAP.put(Items.f_41943_, FlowerMode.AZURE_BLUET);
        MODE_MAP.put(Items.f_41950_, FlowerMode.LILY_OF_THE_VALLEY);
        MODE_MAP.put(Items.f_41949_, FlowerMode.CORNFLOWER);
    }

    public static enum FlowerMode {
        NONE(0xFFAA00, -1, 0x55FFFF, -267386864, 0x505000FF, 1344798847),
        DANDELION(-16121, -10929, -3722, -1711276320, -637553920, -637553920),
        POPPY(-7667712, -328966, -2354116, -650969088, -643288526, -652341746),
        ORANGE_TULIP(-1086464, -328966, -26624, -645376983, -641637094, -646686140),
        RED_TULIP(-4776932, -328966, -1739917, -646826956, -644207315, -647411126),
        WHITE_TULIP(-8268550, -328966, -4987396, -646940516, -646664503, -648122762),
        PINK_TULIP(-39261, -328966, -26181, -643802480, -640917108, -646490011),
        OXEYE(-328966, -328966, -328966, -1711286961, -637535776, -637535776),
        CORNFLOWER(-10720320, -6313766, -1512714, -651676269, -643776288, -652203392),
        BLUE_ORCHID(-13382401, -328966, -8664594, -652909120, -652642606, -652642606),
        ALLIUM(-5011201, -328966, -2705957, -648991320, -645438304, -649118336),
        AZURE_BLUET(-3104, -8062, -5908825, -1712259088, -643443033, -643443033),
        LILY_OF_THE_VALLEY(-10044566, -328966, -8667779, -651264718, -650604996, -650604996);

        private final int titleColor;
        private final int labelColor;
        private final int valueColor;
        private final int backgroundColor;
        private final int borderStartColor;
        private final int borderEndColor;

        private FlowerMode(int titleColor, int labelColor, int valueColor, int backgroundColor, int borderStartColor, int borderEndColor) {
            this.titleColor = titleColor;
            this.labelColor = labelColor;
            this.valueColor = valueColor;
            this.backgroundColor = backgroundColor;
            this.borderStartColor = borderStartColor;
            this.borderEndColor = borderEndColor;
        }

        public int getTitleColor() {
            return this.titleColor;
        }

        public int getLabelColor() {
            return this.labelColor;
        }

        public int getValueColor() {
            return this.valueColor;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }

        public int getBorderStartColor() {
            return this.borderStartColor;
        }

        public int getBorderEndColor() {
            return this.borderEndColor;
        }
    }
}

