/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.mobeffect;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

public class BuffRenderer
implements IClientMobEffectExtensions {
    private final MobEffect effect;
    private final ResourceLocation baseIcon;
    private final ResourceLocation overlayIcon;
    private final boolean animation;
    private static final float CYCLE_MS = 3000.0f;
    private static final float MAX_LIGHTEN = 1.0f;
    private static final int[][] RING_OFFSETS = new int[][]{{0, 0}, {0, -1}, {1, 0}, {0, 1}, {-1, 0}};
    private static final float[] WAVE_OFFSETS = new float[]{0.0f, 0.05f, 0.1f, 0.05f, 0.1f};

    public BuffRenderer(MobEffect effect, ResourceLocation baseIcon, ResourceLocation overlayIcon, boolean animation) {
        this.effect = effect;
        this.baseIcon = baseIcon;
        this.overlayIcon = overlayIcon;
        this.animation = animation;
    }

    public boolean renderInventoryIcon(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics gfx, int x, int y, int z) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.baseIcon);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gfx.m_280398_(this.baseIcon, x, y + 7, z, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.overlayIcon);
        gfx.m_280398_(this.overlayIcon, x, y + 7, z, 0.0f, 0.0f, 18, 18, 18, 18);
        if (this.animation) {
            int col = this.getCombinedColor(instance);
            float r = (float)(col >> 16 & 0xFF) / 255.0f;
            float g = (float)(col >> 8 & 0xFF) / 255.0f;
            float b = (float)(col & 0xFF) / 255.0f;
            this.drawCenterOutPulse(gfx, x + 15, y + 22, z, r, g, b, 1.0f);
        }
        return true;
    }

    public boolean renderGuiIcon(MobEffectInstance instance, Gui gui, GuiGraphics gfx, int x, int y, float z, float baseAlpha) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        int zInt = (int)z;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.baseIcon);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)baseAlpha);
        gfx.m_280398_(this.baseIcon, x + 3, y + 3, zInt, 0.0f, 0.0f, 18, 18, 18, 18);
        float overlayAlpha = this.getEffectFadeAlpha(instance, baseAlpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.overlayIcon);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)overlayAlpha);
        gfx.m_280398_(this.overlayIcon, x + 3, y + 3, zInt, 0.0f, 0.0f, 18, 18, 18, 18);
        if (this.animation && overlayAlpha > 0.0f) {
            int col = this.getCombinedColor(instance);
            float r = (float)(col >> 16 & 0xFF) / 255.0f;
            float g = (float)(col >> 8 & 0xFF) / 255.0f;
            float b = (float)(col & 0xFF) / 255.0f;
            this.drawCenterOutPulse(gfx, x + 18, y + 18, zInt, r, g, b, overlayAlpha);
        }
        return true;
    }

    private void drawCenterOutPulse(GuiGraphics gfx, int cx, int cy, int z, float r, float g, float b, float alpha) {
        long now = System.currentTimeMillis();
        float phase0 = (float)(now % 3000L) / 3000.0f;
        for (int i = 0; i < RING_OFFSETS.length; ++i) {
            int dx = RING_OFFSETS[i][0];
            int dy = RING_OFFSETS[i][1];
            float phase = (phase0 + WAVE_OFFSETS[i]) % 1.0f;
            float wave = 0.5f + 0.5f * (float)Math.sin((double)phase * Math.PI * 2.0);
            float light = wave * 1.0f;
            this.drawPixel(gfx, cx + dx, cy + dy, z, r, g, b, light, alpha);
        }
    }

    private void drawPixel(GuiGraphics gfx, int px, int py, int z, float rBase, float gBase, float bBase, float lighten, float alpha) {
        float r = BuffRenderer.lightenChannel(rBase, lighten);
        float g = BuffRenderer.lightenChannel(gBase, lighten);
        float b = BuffRenderer.lightenChannel(bBase, lighten);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.overlayIcon);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
        gfx.m_280398_(this.overlayIcon, px, py, z, 15.0f, 15.0f, 1, 1, 18, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static float lightenChannel(float c, float f) {
        return c * (1.0f - f) + f;
    }

    private int getCombinedColor(MobEffectInstance inst) {
        return BuffRenderer.multiplyColors(this.getItemNameColor(inst), this.effect.m_19484_());
    }

    private int getItemNameColor(MobEffectInstance inst) {
        CompoundTag tag = inst.m_19555_(new CompoundTag());
        return tag.m_128425_("NameColor", 3) ? tag.m_128451_("NameColor") : 0xFFFFFF;
    }

    public static int multiplyColors(int a, int b) {
        int r = (a >> 16 & 0xFF) * (b >> 16 & 0xFF) / 255;
        int g = (a >> 8 & 0xFF) * (b >> 8 & 0xFF) / 255;
        int bl = (a & 0xFF) * (b & 0xFF) / 255;
        return 0xFF000000 | r << 16 | g << 8 | bl;
    }

    private float getEffectFadeAlpha(MobEffectInstance inst, float baseAlpha) {
        float alpha = baseAlpha;
        Optional data = inst.m_216895_();
        if (data.isPresent()) {
            float pt = Minecraft.m_91087_().m_91296_();
            float factor = ((MobEffectInstance.FactorData)data.get()).m_238413_((LivingEntity)Objects.requireNonNull(Minecraft.m_91087_().f_91074_), pt);
            alpha *= factor;
        }
        return alpha;
    }
}

