/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.render.block;

import net.minecraft.world.level.Level;

public class ColorTransition {
    private static final int TRANSITION_DURATION = 40;
    public int oldColor = 0;
    public int currentColor = 0;
    private long transitionStartTick = 0L;
    public int targetColor = 0;

    public void beginTransition(Level level, int newColor) {
        this.oldColor = this.currentColor;
        this.targetColor = newColor;
        this.transitionStartTick = level.m_46467_();
    }

    public void tick(Level level) {
        long now = level.m_46467_();
        long elapsed = now - this.transitionStartTick;
        if (elapsed >= 40L) {
            this.currentColor = this.targetColor;
            return;
        }
        float progress = (float)elapsed / 40.0f;
        this.currentColor = ColorTransition.lerpColor(this.oldColor, this.targetColor, progress);
    }

    public int getCurrentColor() {
        return this.currentColor;
    }

    public int getTargetColor() {
        return this.targetColor;
    }

    private static int lerpColor(int c1, int c2, float t) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

