/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.render.gui.slot;

import com.eruannie_9.brewchew.util.render.gui.slot.IconFrame;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedSlot {
    private static final int DEFAULT_CYCLE_TIME = 150;
    private final int x;
    private final int y;
    private final int containerSlotIndex;
    private final IconFrame[] baseFrames;
    private final RandomSource random;
    private int frameTimer = 0;
    private int currentIndex;

    public AnimatedSlot(int x, int y, int containerSlotIndex, IconFrame[] baseFrames, RandomSource random) {
        this.x = x;
        this.y = y;
        this.containerSlotIndex = containerSlotIndex;
        this.baseFrames = baseFrames;
        this.random = random;
        this.currentIndex = random.m_188503_(baseFrames.length);
    }

    public void tick() {
        this.tick(150);
    }

    public void tick(int cycleTime) {
        ++this.frameTimer;
        if (this.frameTimer >= cycleTime) {
            this.frameTimer = 0;
            this.currentIndex = this.random.m_188503_(this.baseFrames.length);
        }
    }

    public IconFrame getCurrentBaseFrame() {
        return this.baseFrames[this.currentIndex];
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int containerSlotIndex() {
        return this.containerSlotIndex;
    }
}

