/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.render.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class PreviewTooltipRenderer {
    public static void drawVanillaTooltipWithVerticalGradient(GuiGraphics guiGraphics, List<FormattedCharSequence> lines, int mouseX, int mouseY, int screenWidth, int screenHeight, Font font, int backgroundStartColor, int backgroundEndColor, int borderStartColor, int borderEndColor) {
        if (lines.isEmpty()) {
            return;
        }
        int tooltipWidth = 0;
        for (FormattedCharSequence line : lines) {
            int lineWidth = font.m_92724_(line);
            tooltipWidth = Math.max(tooltipWidth, lineWidth);
        }
        int n = lines.size();
        Objects.requireNonNull(font);
        int tooltipHeight = n * 9;
        if (lines.size() > 1) {
            tooltipHeight += 2;
        }
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + tooltipWidth + 6 > screenWidth) {
            x = mouseX - 28 - tooltipWidth;
        }
        if (y + tooltipHeight + 6 > screenHeight) {
            y = screenHeight - tooltipHeight - 6;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        PreviewTooltipRenderer.drawVanillaShapeWithVerticalGradient(guiGraphics, x, y, tooltipWidth, tooltipHeight, backgroundStartColor, backgroundEndColor, borderStartColor, borderEndColor);
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        int textY = y;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            guiGraphics.m_280649_(font, line, x, textY, -1, true);
            Objects.requireNonNull(font);
            textY += 9;
            if (i != 0 || lines.size() <= 1) continue;
            textY += 2;
        }
        poseStack.m_85849_();
    }

    private static void drawVanillaShapeWithVerticalGradient(GuiGraphics guiGraphics, int x, int y, int tooltipWidth, int tooltipHeight, int backgroundStartColor, int backgroundEndColor, int borderStartColor, int borderEndColor) {
        PoseStack poseStack = guiGraphics.m_280168_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float z = 400.0f;
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 3, y - 4, x + tooltipWidth + 3, y - 3, z, backgroundStartColor, backgroundStartColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 3, y + tooltipHeight + 3, x + tooltipWidth + 3, y + tooltipHeight + 4, z, backgroundEndColor, backgroundEndColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 3, y - 3, x + tooltipWidth + 3, y + tooltipHeight + 3, z, backgroundStartColor, backgroundEndColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 4, y - 3, x - 3, y + tooltipHeight + 3, z, backgroundStartColor, backgroundEndColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x + tooltipWidth + 3, y - 3, x + tooltipWidth + 4, y + tooltipHeight + 3, z, backgroundStartColor, backgroundEndColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 3, y - 2, x - 2, y + tooltipHeight + 2, z, borderStartColor, borderEndColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x + tooltipWidth + 2, y - 2, x + tooltipWidth + 3, y + tooltipHeight + 2, z, borderStartColor, borderEndColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 3, y - 3, x + tooltipWidth + 3, y - 2, z, borderStartColor, borderStartColor);
        PreviewTooltipRenderer.fillGradient(matrix, buf, x - 3, y + tooltipHeight + 2, x + tooltipWidth + 3, y + tooltipHeight + 3, z, borderEndColor, borderEndColor);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder buffer, int x1, int y1, int x2, int y2, float z, int topColor, int bottomColor) {
        float a1 = (float)(topColor >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(topColor >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(topColor >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(topColor & 0xFF) / 255.0f;
        float a2 = (float)(bottomColor >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(bottomColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(bottomColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(bottomColor & 0xFF) / 255.0f;
        float fx1 = x1;
        float fy1 = y1;
        float fx2 = x2;
        float fy2 = y2;
        buffer.m_252986_(matrix, fx2, fy1, z).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(matrix, fx1, fy1, z).m_85950_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(matrix, fx1, fy2, z).m_85950_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(matrix, fx2, fy2, z).m_85950_(r2, g2, b2, a2).m_5752_();
    }
}

