/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.brewchew.util.render.gui.water;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CauldronAnimationRenderer {
    private static final int FRAMES = 22;
    private static final int WIDTH = 57;
    private static final int HEIGHT = 56;
    private static final int OFFSET_X = 20;
    private static final int OFFSET_Y = 32;
    private static final double WATER_DURATION = 130.0;
    private static final double BUBBLE_DURATION = 200.0;
    private static final ResourceLocation WATER_TEXTURE = new ResourceLocation("brewchew", "textures/gui/water_animation.png");
    private static final ResourceLocation BUBBLE_TEXTURE = new ResourceLocation("brewchew", "textures/gui/bubbles_animation.png");
    private long lastRenderTime = System.currentTimeMillis();
    private double waterTime;
    private int waterIndex;
    private double bubbleTime;
    private int bubbleIndex;

    public void render(GuiGraphics guiGraphics, int screenLeft, int screenTop) {
        this.updateAnimations();
        this.drawWater(guiGraphics, screenLeft, screenTop);
        this.drawBubbles(guiGraphics, screenLeft, screenTop);
    }

    private void updateAnimations() {
        long now = System.currentTimeMillis();
        long delta = now - this.lastRenderTime;
        this.lastRenderTime = now;
        this.waterTime += (double)delta;
        while (this.waterTime >= 130.0) {
            this.waterTime -= 130.0;
            this.waterIndex = (this.waterIndex + 1) % 22;
        }
        this.bubbleTime += (double)delta;
        while (this.bubbleTime >= 200.0) {
            this.bubbleTime -= 200.0;
            this.bubbleIndex = (this.bubbleIndex + 1) % 22;
        }
    }

    private void drawWater(GuiGraphics guiGraphics, int screenLeft, int screenTop) {
        int vOffset = this.waterIndex * 56;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_TEXTURE);
        guiGraphics.m_280163_(WATER_TEXTURE, screenLeft + 20, screenTop + 32, 0.0f, (float)vOffset, 57, 56, 57, 1232);
    }

    private void drawBubbles(GuiGraphics guiGraphics, int screenLeft, int screenTop) {
        int current = this.bubbleIndex;
        int next = (current + 1) % 22;
        float partial = (float)(this.bubbleTime / 200.0);
        partial = Mth.m_14036_((float)partial, (float)0.0f, (float)1.0f);
        this.drawBubbleFrame(guiGraphics, screenLeft, screenTop, current, 1.0f - partial);
        this.drawBubbleFrame(guiGraphics, screenLeft, screenTop, next, partial);
    }

    private void drawBubbleFrame(GuiGraphics guiGraphics, int screenLeft, int screenTop, int frame, float alpha) {
        if (alpha <= 0.001f) {
            return;
        }
        int vOffset = frame * 56;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BUBBLE_TEXTURE);
        guiGraphics.m_280163_(BUBBLE_TEXTURE, screenLeft + 20, screenTop + 32, 0.0f, (float)vOffset, 57, 56, 57, 1232);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

