/*
 * Decompiled with CFR 0.152.
 */
package net.thetct.fpsboostremake;

import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FPSreductor {
    private static final int INACTIVE_FPS_LIMIT = 25;
    private static long INACTIVITY_THRESHOLD_MS = 15000L;
    private static long lastActivityTime = System.currentTimeMillis();
    private static boolean isFPSReduced = false;
    private static boolean screensave = true;
    private static int defaultFPSLimit = 60;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new FPSreductor();
    }

    @Mod.EventBusSubscriber
    private static class FPSreductorForgeBusEvents {
        private FPSreductorForgeBusEvents() {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && screensave) {
                FPSreductorForgeBusEvents.checkAndReduceFPS();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onMouseInput(InputEvent.MouseButton event) {
            if (screensave) {
                lastActivityTime = System.currentTimeMillis();
                if (isFPSReduced) {
                    FPSreductorForgeBusEvents.resetMaxFPS();
                    isFPSReduced = false;
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (screensave) {
                lastActivityTime = System.currentTimeMillis();
                if (isFPSReduced) {
                    FPSreductorForgeBusEvents.resetMaxFPS();
                    isFPSReduced = false;
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void checkAndReduceFPS() {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastActivityTime > INACTIVITY_THRESHOLD_MS && !isFPSReduced) {
                defaultFPSLimit = (Integer)Minecraft.m_91087_().f_91066_.m_232035_().m_231551_();
                FPSreductorForgeBusEvents.setMaxFPS(25);
                isFPSReduced = true;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void setMaxFPS(int fps) {
            Minecraft.m_91087_().f_91066_.m_232035_().m_231514_((Object)fps);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void resetMaxFPS() {
            FPSreductorForgeBusEvents.setMaxFPS(defaultFPSLimit);
        }
    }
}

