/*
 * Decompiled with CFR 0.152.
 */
package net.thetct.fpsboostremake.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.thetct.fpsboostremake.FpsboostremakeMod;
import net.thetct.fpsboostremake.procedures.BetterChunksFilpProcedure;
import net.thetct.fpsboostremake.procedures.ClearlagFlipProcedure;
import net.thetct.fpsboostremake.procedures.ClearlagNotifyFlipProcedure;
import net.thetct.fpsboostremake.procedures.DisableFogFilpProcedure;
import net.thetct.fpsboostremake.procedures.DisableWeatherFlipProcedure;
import net.thetct.fpsboostremake.procedures.OpentctcoreProcedure;
import net.thetct.fpsboostremake.procedures.PerformanceModeFlipProcedure;
import net.thetct.fpsboostremake.procedures.ShowFPSflipProcedure;
import net.thetct.fpsboostremake.procedures.SlowTickFlipProcedure;
import net.thetct.fpsboostremake.world.inventory.FPSBoostSettingsMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FPSBoostSettingsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public FPSBoostSettingsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public FPSBoostSettingsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(FPSBoostSettingsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(FPSBoostSettingsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            FPSBoostSettingsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = FPSBoostSettingsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpentctcoreProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            DisableWeatherFlipProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SlowTickFlipProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ClearlagNotifyFlipProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BetterChunksFilpProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ClearlagFlipProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ShowFPSflipProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            DisableFogFilpProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            PerformanceModeFlipProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        FpsboostremakeMod.addNetworkMessage(FPSBoostSettingsButtonMessage.class, FPSBoostSettingsButtonMessage::buffer, FPSBoostSettingsButtonMessage::new, FPSBoostSettingsButtonMessage::handler);
    }
}

