/*
 * Decompiled with CFR 0.152.
 */
package net.thetct.fpsboostremake.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.thetct.fpsboostremake.FpsboostremakeMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FpsboostremakeModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        FpsboostremakeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Clearlag = message.data.Clearlag;
                    variables.ClearlagNotify = message.data.ClearlagNotify;
                    variables.Weather = message.data.Weather;
                    variables.SpawnEntity = message.data.SpawnEntity;
                    variables.showFPS = message.data.showFPS;
                    variables.SlowTick = message.data.SlowTick;
                    variables.BetterChunks = message.data.BetterChunks;
                    variables.ModeBase = message.data.ModeBase;
                    variables.Zoom = message.data.Zoom;
                    variables.DisableFOG = message.data.DisableFOG;
                    variables.PerformanceMode = message.data.PerformanceMode;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean Clearlag = true;
        public boolean ClearlagNotify = false;
        public boolean Weather = false;
        public double SpawnEntity = 0.0;
        public boolean showFPS = false;
        public boolean SlowTick = false;
        public boolean BetterChunks = true;
        public boolean ModeBase = true;
        public boolean Zoom = false;
        public boolean DisableFOG = true;
        public boolean PerformanceMode = true;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                FpsboostremakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Clearlag", this.Clearlag);
            nbt.m_128379_("ClearlagNotify", this.ClearlagNotify);
            nbt.m_128379_("Weather", this.Weather);
            nbt.m_128347_("SpawnEntity", this.SpawnEntity);
            nbt.m_128379_("showFPS", this.showFPS);
            nbt.m_128379_("SlowTick", this.SlowTick);
            nbt.m_128379_("BetterChunks", this.BetterChunks);
            nbt.m_128379_("ModeBase", this.ModeBase);
            nbt.m_128379_("Zoom", this.Zoom);
            nbt.m_128379_("DisableFOG", this.DisableFOG);
            nbt.m_128379_("PerformanceMode", this.PerformanceMode);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Clearlag = nbt.m_128471_("Clearlag");
            this.ClearlagNotify = nbt.m_128471_("ClearlagNotify");
            this.Weather = nbt.m_128471_("Weather");
            this.SpawnEntity = nbt.m_128459_("SpawnEntity");
            this.showFPS = nbt.m_128471_("showFPS");
            this.SlowTick = nbt.m_128471_("SlowTick");
            this.BetterChunks = nbt.m_128471_("BetterChunks");
            this.ModeBase = nbt.m_128471_("ModeBase");
            this.Zoom = nbt.m_128471_("Zoom");
            this.DisableFOG = nbt.m_128471_("DisableFOG");
            this.PerformanceMode = nbt.m_128471_("PerformanceMode");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("fpsboostremake", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Clearlag = original.Clearlag;
            clone.ClearlagNotify = original.ClearlagNotify;
            clone.Weather = original.Weather;
            clone.SpawnEntity = original.SpawnEntity;
            clone.showFPS = original.showFPS;
            clone.SlowTick = original.SlowTick;
            clone.BetterChunks = original.BetterChunks;
            clone.ModeBase = original.ModeBase;
            clone.DisableFOG = original.DisableFOG;
            clone.PerformanceMode = original.PerformanceMode;
            if (!event.isWasDeath()) {
                clone.Zoom = original.Zoom;
            }
        }
    }
}

