/*
 * Decompiled with CFR 0.152.
 */
package com.divot.efct.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Klient {
    public static final ForgeConfigSpec SPEC;
    public static final ClientConfig CLIENT;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT = (ClientConfig)pair.getLeft();
    }

    public static class ClientConfig {
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> epicItems;
        private final ForgeConfigSpec.ConfigValue<Boolean> epicHold;
        private final ForgeConfigSpec.ConfigValue<Boolean> battleShift;
        private final ForgeConfigSpec.ConfigValue<Boolean> epicAim;
        private final ForgeConfigSpec.ConfigValue<Boolean> keepBar;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Config");
            this.epicItems = builder.comment("Items that switch to mining mode whilst using").translation("Epic Use Items").defineList("epic_use_items", () -> {
                ArrayList items = new ArrayList();
                return items;
            }, item -> item != null && ResourceLocation.m_135830_((String)item.toString()));
            this.battleShift = builder.define("Mining mode while holding shift", () -> true);
            this.epicHold = builder.define("Auto switch back to battle mode when unequipping an item listed in Epic Fight's mining autoswitch config", () -> true);
            this.epicAim = builder.define("Switch to mining mode whilst aiming with MrCrayfish Guns", () -> false);
            this.keepBar = builder.define("Keep stamina bar up", () -> false);
            builder.pop();
        }

        public List<? extends String> epicItems() {
            return (List)this.epicItems.get();
        }

        public boolean getEpicHold() {
            return (Boolean)this.epicHold.get();
        }

        public boolean getBattleShift() {
            return (Boolean)this.battleShift.get();
        }

        public boolean getEpicAiming() {
            return (Boolean)this.epicAim.get();
        }

        public boolean getKeepBar() {
            return (Boolean)this.keepBar.get();
        }
    }
}

