/*
 * Decompiled with CFR 0.152.
 */
package com.divot.efct.network;

import com.divot.efct.client.IIntegratedPlayerPatch;
import com.divot.efct.network.NetworkHandler;
import com.divot.efct.network.SPCancelEpic;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPCancelEpic {
    private final boolean cancelEpic;

    public CPCancelEpic() {
        this.cancelEpic = false;
    }

    public CPCancelEpic(boolean cancelEpic) {
        this.cancelEpic = cancelEpic;
    }

    public static CPCancelEpic fromBytes(FriendlyByteBuf buf) {
        return new CPCancelEpic(buf.readBoolean());
    }

    public static void toBytes(CPCancelEpic msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.cancelEpic);
    }

    public static void handle(CPCancelEpic msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IIntegratedPlayerPatch entitypatch;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (entitypatch = (IIntegratedPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class)) != null) {
                entitypatch.setEpicCancelled(msg.cancelEpic);
                NetworkHandler.sendToAllPlayerTrackingThisEntity(new SPCancelEpic(msg.cancelEpic, player.m_19879_()), (Entity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

