/*
 * Decompiled with CFR 0.152.
 */
package com.divot.efct.network;

import com.divot.efct.network.CPCancelEpic;
import com.divot.efct.network.SPCancelEpic;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="efct", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("efct", "network_manager"), () -> "1", "1"::equals, "1"::equals);

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToClient(MSG message, PacketDistributor.PacketTarget packetTarget) {
        INSTANCE.send(packetTarget, message);
    }

    public static <MSG> void sendToAll(MSG message) {
        NetworkHandler.sendToClient(message, PacketDistributor.ALL.noArg());
    }

    public static <MSG> void sendToAllPlayerTrackingThisEntity(MSG message, Entity entity) {
        NetworkHandler.sendToClient(message, PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        NetworkHandler.sendToClient(message, PacketDistributor.PLAYER.with(() -> player));
    }

    public static <MSG> void sendToAllPlayerTrackingThisEntityWithSelf(MSG message, ServerPlayer entity) {
        NetworkHandler.sendToClient(message, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
    }

    public static <MSG> void sendToAllPlayerTrackingThisChunkWithSelf(MSG message, LevelChunk chunk) {
        NetworkHandler.sendToClient(message, PacketDistributor.TRACKING_CHUNK.with(() -> chunk));
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        INSTANCE.registerMessage(20, SPCancelEpic.class, SPCancelEpic::toBytes, SPCancelEpic::fromBytes, SPCancelEpic::handle);
        INSTANCE.registerMessage(21, CPCancelEpic.class, CPCancelEpic::toBytes, CPCancelEpic::fromBytes, CPCancelEpic::handle);
    }
}

