/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.color;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BlendedColorProvider;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public class DefaultColorProviders {
    public static ColorProvider<BlockState> adapt(BlockColor provider) {
        return new VanillaAdapter(provider);
    }

    public static ColorProvider<FluidState> getFluidProvider() {
        return new ForgeFluidAdapter();
    }

    private static class VanillaAdapter
    implements ColorProvider<BlockState> {
        private final BlockColor provider;

        private VanillaAdapter(BlockColor provider) {
            this.provider = provider;
        }

        @Override
        public void getColors(WorldSlice view, BlockPos pos, BlockState state, ModelQuadView quad, int[] output) {
            Arrays.fill(output, ColorARGB.toABGR(this.provider.m_92566_(state, (BlockAndTintGetter)view, pos, quad.getColorIndex())));
        }
    }

    private static class ForgeFluidAdapter
    implements ColorProvider<FluidState> {
        private ForgeFluidAdapter() {
        }

        @Override
        public void getColors(WorldSlice view, BlockPos pos, FluidState state, ModelQuadView quad, int[] output) {
            if (view == null || state == null) {
                Arrays.fill(output, -1);
                return;
            }
            Arrays.fill(output, ColorARGB.toABGR(IClientFluidTypeExtensions.of((FluidState)state).getTintColor(state, (BlockAndTintGetter)view, pos)));
        }
    }

    public static class VertexBlendedBiomeColorAdapter<T>
    extends BlendedColorProvider<T> {
        private final VanillaBiomeColor vanillaGetter;

        public VertexBlendedBiomeColorAdapter(VanillaBiomeColor vanillaGetter) {
            this.vanillaGetter = vanillaGetter;
        }

        @Override
        protected int getColor(WorldSlice world, BlockPos pos) {
            return this.vanillaGetter.getAverageColor(world, pos);
        }

        @FunctionalInterface
        public static interface VanillaBiomeColor {
            public int getAverageColor(BlockAndTintGetter var1, BlockPos var2);
        }
    }

    @Deprecated(forRemoval=true)
    public static class WaterColorProvider<T>
    extends BlendedColorProvider<T> {
        public static final ColorProvider<BlockState> BLOCKS = new WaterColorProvider<BlockState>();
        public static final ColorProvider<FluidState> FLUIDS = new WaterColorProvider<FluidState>();

        private WaterColorProvider() {
        }

        @Override
        protected int getColor(WorldSlice world, int x, int y, int z) {
            return world.getColor(BiomeColorSource.WATER, x, y, z);
        }
    }

    @Deprecated(forRemoval=true)
    public static class FoliageColorProvider<T>
    extends BlendedColorProvider<T> {
        public static final ColorProvider<BlockState> BLOCKS = new FoliageColorProvider<BlockState>();

        private FoliageColorProvider() {
        }

        @Override
        protected int getColor(WorldSlice world, int x, int y, int z) {
            return world.getColor(BiomeColorSource.FOLIAGE, x, y, z);
        }
    }

    @Deprecated(forRemoval=true)
    public static class GrassColorProvider<T>
    extends BlendedColorProvider<T> {
        public static final ColorProvider<BlockState> BLOCKS = new GrassColorProvider<BlockState>();

        private GrassColorProvider() {
        }

        @Override
        protected int getColor(WorldSlice world, int x, int y, int z) {
            return world.getColor(BiomeColorSource.GRASS, x, y, z);
        }
    }
}

