/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.entity.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemColourable;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class CosmosLayerArmourColourable<E extends LivingEntity, M extends HumanoidModel<E>, A extends HumanoidModel<E>>
extends RenderLayer<E, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;

    public CosmosLayerArmourColourable(RenderLayerParent<E, M> entityRenderer, A innerModelIn, A outerModelIn) {
        super(entityRenderer);
        this.innerModel = innerModelIn;
        this.outerModel = outerModelIn;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, E entityLivingBaseIn, float limbSwingIn, float limbSwingAmountIn, float partialTicks, float ageInTicks, float netHeadYawIn, float headPitchIn) {
        this.renderArmorPiece(matrixStackIn, bufferIn, entityLivingBaseIn, EquipmentSlot.CHEST, packedLightIn, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(matrixStackIn, bufferIn, entityLivingBaseIn, EquipmentSlot.LEGS, packedLightIn, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(matrixStackIn, bufferIn, entityLivingBaseIn, EquipmentSlot.FEET, packedLightIn, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(matrixStackIn, bufferIn, entityLivingBaseIn, EquipmentSlot.HEAD, packedLightIn, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack matrixStackIn, MultiBufferSource bufferIn, E livingEntityIn, EquipmentSlot slotTypeIn, int packedLightIn, A modelIn) {
        CosmosArmourItemColourable armoritem;
        ItemStack stackIn = livingEntityIn.m_6844_(slotTypeIn);
        if (stackIn.m_41720_() instanceof CosmosArmourItemColourable && (armoritem = (CosmosArmourItemColourable)stackIn.m_41720_()).m_40402_() == slotTypeIn) {
            ((HumanoidModel)this.m_117386_()).m_102872_(modelIn);
            Model model = this.getArmorModelHook(livingEntityIn, stackIn, slotTypeIn, modelIn);
            this.setPartVisibility(modelIn, slotTypeIn);
            boolean flag = this.usesInnerModel(slotTypeIn);
            boolean flag1 = stackIn.m_41790_();
            float[] rgb = ComponentColour.rgbFloatArray(ComponentColour.POCKET_PURPLE_LIGHT);
            if (stackIn.m_41782_()) {
                CompoundTag stackTag = stackIn.m_41783_();
                if (stackTag.m_128441_("nbt_data")) {
                    CompoundTag nbtData = stackTag.m_128469_("nbt_data");
                    if (nbtData.m_128441_("colour")) {
                        int colour = nbtData.m_128451_("colour");
                        float[] colArray = ComponentColour.rgbFloatArray(colour);
                        this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, colArray[0], colArray[1], colArray[2], 1.0f, false, this.getArmorResource((Entity)livingEntityIn, stackIn, slotTypeIn, TYPE.BASE, null));
                    }
                } else {
                    this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, rgb[0], rgb[1], rgb[2], 1.0f, false, this.getArmorResource((Entity)livingEntityIn, stackIn, slotTypeIn, TYPE.BASE, null));
                }
            } else {
                this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, rgb[0], rgb[1], rgb[2], 1.0f, false, this.getArmorResource((Entity)livingEntityIn, stackIn, slotTypeIn, TYPE.BASE, null));
            }
            this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, 1.0f, 1.0f, 1.0f, 1.0f, false, this.getArmorResource((Entity)livingEntityIn, stackIn, slotTypeIn, TYPE.OVERLAY, null));
            this.renderModel(matrixStackIn, bufferIn, packedLightIn, flag1, model, 1.0f, 1.0f, 1.0f, 1.0f, false, this.getArmorResource((Entity)livingEntityIn, stackIn, slotTypeIn, TYPE.ALPHA, null));
        }
    }

    protected void setPartVisibility(A modelIn, EquipmentSlot slotIn) {
        modelIn.m_8009_(false);
        switch (slotIn) {
            case HEAD: {
                ((HumanoidModel)modelIn).f_102808_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)modelIn).f_102810_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102811_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)modelIn).f_102810_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102813_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)modelIn).f_102813_.f_104207_ = true;
                ((HumanoidModel)modelIn).f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean foilIn, Model modelIn, float r, float g, float b, float a, boolean alphaLayer, ResourceLocation armorResource) {
        if (alphaLayer) {
            RenderType type = RenderType.m_110473_((ResourceLocation)armorResource);
            VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)type, (boolean)false, (boolean)foilIn);
            modelIn.m_7695_(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, r, g, b, a);
        } else {
            RenderType type = RenderType.m_110431_((ResourceLocation)armorResource);
            VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)type, (boolean)false, (boolean)false);
            modelIn.m_7695_(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, r, g, b, a);
        }
    }

    private A getArmorModel(EquipmentSlot slotIn) {
        return this.usesInnerModel(slotIn) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot slotIn) {
        return slotIn == EquipmentSlot.LEGS;
    }

    protected Model getArmorModelHook(E entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlot)slot, model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, TYPE typeIn, @Nullable String type) {
        Item item = stack.m_41720_();
        if (item instanceof CosmosArmourItemColourable) {
            CosmosArmourItemColourable armour = (CosmosArmourItemColourable)stack.m_41720_();
            if (typeIn.equals((Object)TYPE.ALPHA)) {
                Object texture = "";
                String domain = "minecraft";
                texture = armour.m_40401_().m_6082_() + "_alpha";
                int idx = ((String)texture).indexOf(58);
                if (idx != -1) {
                    domain = ((String)texture).substring(0, idx);
                    texture = ((String)texture).substring(idx + 1);
                }
                String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
                ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
                if (resourcelocation == null) {
                    resourcelocation = new ResourceLocation(s1);
                    ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
                }
                return resourcelocation;
            }
            if (typeIn.equals((Object)TYPE.OVERLAY)) {
                Object texture = "";
                String domain = "minecraft";
                texture = armour.m_40401_().m_6082_() + "_overlay";
                int idx = ((String)texture).indexOf(58);
                if (idx != -1) {
                    domain = ((String)texture).substring(0, idx);
                    texture = ((String)texture).substring(idx + 1);
                }
                String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
                ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
                if (resourcelocation == null) {
                    resourcelocation = new ResourceLocation(s1);
                    ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
                }
                return resourcelocation;
            }
            if (typeIn.equals((Object)TYPE.BASE)) {
                String texture = "";
                String domain = "minecraft";
                texture = armour.m_40401_().m_6082_();
                int idx = texture.indexOf(58);
                if (idx != -1) {
                    domain = texture.substring(0, idx);
                    texture = texture.substring(idx + 1);
                }
                String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
                ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
                if (resourcelocation == null) {
                    resourcelocation = new ResourceLocation(s1);
                    ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
                }
                return resourcelocation;
            }
            return new ResourceLocation("", "");
        }
        return new ResourceLocation("", "");
    }

    private static enum TYPE {
        BASE,
        OVERLAY,
        ALPHA;

    }
}

