/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemElytra;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CosmosLayerElytraStand<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static ResourceLocation TEXTURE_ELYTRA;
    private final ElytraModel<T> elytraModel;

    public CosmosLayerElytraStand(RenderLayerParent<T, M> rendererIn, EntityModelSet modelSet, ResourceLocation location) {
        super(rendererIn);
        this.elytraModel = new ElytraModel(modelSet.m_171103_(ModelLayers.f_171141_));
        TEXTURE_ELYTRA = location;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stackIn = entityLivingBaseIn.m_6844_(EquipmentSlot.CHEST);
        if (this.shouldRender(stackIn, entityLivingBaseIn)) {
            CompoundTag nbtData;
            CompoundTag stackTag;
            AbstractClientPlayer abstractclientplayerentity;
            ResourceLocation resourcelocation = entityLivingBaseIn instanceof AbstractClientPlayer ? ((abstractclientplayerentity = (AbstractClientPlayer)entityLivingBaseIn).m_108562_() && abstractclientplayerentity.m_108563_() != null ? abstractclientplayerentity.m_108563_() : (abstractclientplayerentity.m_108555_() && abstractclientplayerentity.m_108561_() != null && abstractclientplayerentity.m_36170_(PlayerModelPart.CAPE) ? abstractclientplayerentity.m_108561_() : this.getElytraTexture(stackIn, entityLivingBaseIn))) : this.getElytraTexture(stackIn, entityLivingBaseIn);
            float[] rgb = ComponentColour.rgbFloatArray(ComponentColour.LIGHT_GRAY);
            if (stackIn.m_41782_() && (stackTag = stackIn.m_41783_()).m_128441_("nbt_data") && (nbtData = stackTag.m_128469_("nbt_data")).m_128441_("wing_colour")) {
                int wingColour = nbtData.m_128451_("wing_colour");
                rgb = ComponentColour.rgbFloatArray(wingColour);
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, 0.0, 0.125);
            this.m_117386_().m_102624_(this.elytraModel);
            this.elytraModel.m_6973_(entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation), (boolean)false, (boolean)stackIn.m_41790_());
            this.elytraModel.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, rgb[0], rgb[1], rgb[2], 1.0f);
            matrixStackIn.m_85849_();
        }
    }

    public boolean shouldRender(ItemStack stack, T entity) {
        return stack.m_41720_() instanceof CosmosArmourItemElytra;
    }

    public ResourceLocation getElytraTexture(ItemStack stack, T entity) {
        return TEXTURE_ELYTRA;
    }
}

