/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.renderer.lib;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.MatrixUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CosmosRendererHelper {
    public static final ResourceLocation LASER_TEXTURE = new ResourceLocation("cosmoslibrary", "textures/entity/laser_beam.png");
    public static final int MAX_LIGHT_X = 0xF000F0;
    public static final int MAX_LIGHT_Y = 0xF000F0;

    public static void renderLaser(MultiBufferSource bufferIn, PoseStack matrixStack, double firstX, double firstY, double firstZ, double secondX, double secondY, double secondZ, double rotationTime, float alpha, double beamWidth, ComponentColour enum_colour) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)LASER_TEXTURE));
        float[] colour = enum_colour.getFloatRGB();
        float r = colour[0];
        float g = colour[1];
        float b = colour[2];
        Vec3 vector_one = new Vec3(firstX, firstY, firstZ);
        Vec3 vector_two = new Vec3(secondX, secondY, secondZ);
        Vec3 vector_combined = vector_two.m_82546_(vector_one);
        double rotation = rotationTime > 0.0 ? 360.0 * ((double)world.m_46467_() % rotationTime / rotationTime) : 0.0;
        double pitch = Math.atan2(vector_combined.f_82480_, Math.sqrt(vector_combined.f_82479_ * vector_combined.f_82479_ + vector_combined.f_82481_ * vector_combined.f_82481_));
        double yaw = Math.atan2(-vector_combined.f_82481_, vector_combined.f_82479_);
        double length = vector_combined.m_82553_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(180.0 * yaw / Math.PI)));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)(180.0 * pitch / Math.PI)));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_((float)rotation));
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        for (double i = 0.0; i < 4.0; i += 1.0) {
            double width = beamWidth * (i / 4.0);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)width, (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)width, (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)(-width), (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)(-width), (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)(-width), (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)(-width), (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)width, (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)width, (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)width, (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)width, (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)width, (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)width, (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)(-width), (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)(-width), (float)width, 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, 0.0f, (float)(-width), (float)(-width), 0.0f, 0.0f);
            CosmosRendererHelper.addVertex(matrix4f, matrix3f, vertexBuilder, r, g, b, alpha, (float)length, (float)(-width), (float)(-width), 0.0f, 0.0f);
        }
        matrixStack.m_85849_();
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, float x, float y, float z, float texU, float texV) {
        bufferIn.m_252986_(matrixPos, x, y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
    }

    public static void addF(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, float r, float g, float b, float a) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_7120_(0, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void addF(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int u2, int v2, float r, float g, float b, float a) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_7120_(u2, v2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void addD(VertexConsumer renderer, PoseStack stack, double x, double y, double z, double u, double v, double r, double g, double b, double a) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), (float)x, (float)y, (float)z).m_85950_((float)r, (float)g, (float)b, (float)a).m_7421_((float)u, (float)v).m_7120_(0, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void addD(VertexConsumer renderer, PoseStack stack, double x, double y, double z, double u, double v, int u2, int v2, double r, double g, double b, double a) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), (float)x, (float)y, (float)z).m_85950_((float)r, (float)g, (float)b, (float)a).m_7421_((float)u, (float)v).m_7120_(u2, v2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void renderLabelInWorld(Font fontRendererIn, PoseStack matrixStackIn, MutableComponent textIn, MultiBufferSource bufferIn, int combinedLightIn, boolean boxOn, boolean shadowOn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(-0.025f, -0.025f, -0.025f);
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
        float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int alpha = (int)(opacity * 255.0f) << 24;
        float width = -fontRendererIn.m_92852_((FormattedText)textIn) / 2;
        if (boxOn) {
            fontRendererIn.m_272077_((Component)textIn, width, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, -alpha, combinedLightIn);
        }
        fontRendererIn.m_272077_((Component)textIn, width, 0.0f, -1, shadowOn, matrix4f, bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        matrixStackIn.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void render(ItemRenderer renderer, ItemStack stackIn, ItemDisplayContext transformIn, boolean p_229111_3_, PoseStack poseStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, boolean renderFoil) {
        if (!stackIn.m_41619_()) {
            poseStackIn.m_85836_();
            boolean flag = transformIn == ItemDisplayContext.GUI || transformIn == ItemDisplayContext.GROUND || transformIn == ItemDisplayContext.FIXED;
            modelIn = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStackIn, (BakedModel)modelIn, (ItemDisplayContext)transformIn, (boolean)p_229111_3_);
            poseStackIn.m_85837_(-0.5, -0.5, -0.5);
            if (stackIn.m_41720_() != Items.f_42713_ || flag) {
                Block block;
                boolean flag1 = transformIn != ItemDisplayContext.GUI && !transformIn.m_269069_() && stackIn.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)stackIn.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : modelIn.getRenderPasses(stackIn, flag1)) {
                    for (RenderType rendertype : model.getRenderTypes(stackIn, flag1)) {
                        poseStackIn.m_85836_();
                        PoseStack.Pose posestack$pose = poseStackIn.m_85850_();
                        if (transformIn == ItemDisplayContext.GUI) {
                            MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.5f);
                        } else if (transformIn.m_269069_()) {
                            MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.75f);
                        }
                        poseStackIn.m_85849_();
                        VertexConsumer ivertexbuilder = flag1 ? (renderFoil ? ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)stackIn.m_41790_()) : ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)false)) : (renderFoil ? ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)stackIn.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)false));
                        renderer.m_115189_(modelIn, stackIn, combinedLightIn, combinedOverlayIn, poseStackIn, ivertexbuilder);
                    }
                }
            }
            poseStackIn.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getMappedTextureHeight(TextureAtlasSprite spriteIn, float inputHeightIn, float inputMinIn, float inputMaxIn) {
        return 0.0625f / (512.0f / (float)spriteIn.m_245424_().m_245330_()) * Mth.m_184637_((float)inputHeightIn, (float)inputMinIn, (float)inputMaxIn, (float)0.0f, (float)8.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getMappedTextureHeight(TextureAtlasSprite spriteIn, float inputHeightIn) {
        return CosmosRendererHelper.getMappedTextureHeight(spriteIn, inputHeightIn, 16.0f, 0.0f);
    }
}

