/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.lib;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tcn.cosmoslibrary.CosmosReference;
import com.tcn.cosmoslibrary.client.renderer.lib.CosmosRendererHelper;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonWithType;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.IEnergyEntity;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBlockEntityUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.IFluidTank;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class CosmosUISystem {
    public static final int DEFAULT_COLOUR_BACKGROUND = 0x404040;
    public static final int DEFAULT_COLOUR_FONT_LIST = 0xFFFFFF;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int LIGHT_BLUE = 5800698;
    public static final int BLUE = 255;
    public static final int LIGHT_GREY = 0xA4A4A4;
    public static final int GREY = 0x424242;
    public static final int GREEN = 65280;
    public static final int DARK_GREEN = 745739;
    public static final int RED = 0xFF0000;
    public static final int YELLOW = 0xFFFF00;
    public static final int ORANGE = 0xFF8000;
    public static final int CYAN = 109019;
    public static final int MAGENTA = 14614999;
    public static final int PURPLE = 8979633;
    public static final int PINK = 16658120;
    public static final int BROWN = 6365451;
    public static final float[] NORMAL_COLOUR = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public static int[] getScreenCoords(Screen screen, int imageWidth, int imageHeight) {
        return new int[]{(screen.f_96543_ - imageWidth) / 2, (screen.f_96544_ - imageHeight) / 2};
    }

    public static int[] getScreenCoords(AbstractContainerScreen<?> screen, int imageWidth, int imageHeight) {
        return new int[]{(screen.f_96543_ - imageWidth) / 2, (screen.f_96544_ - imageHeight) / 2};
    }

    public static void setTextureWithColour(PoseStack poseStack, ResourceLocation textureIn, ComponentColour colourIn) {
        CosmosUISystem.setTexture(poseStack, textureIn);
        CosmosUISystem.setTextureColour(colourIn);
    }

    public static void setTextureWithColour(PoseStack poseStack, ResourceLocation textureIn, float redIn, float greenIn, float blueIn) {
        CosmosUISystem.setTexture(poseStack, textureIn);
        CosmosUISystem.setTextureColour(redIn, greenIn, blueIn);
    }

    public static void setTextureWithColour(PoseStack poseStack, ResourceLocation textureIn, float[] colourIn) {
        CosmosUISystem.setTexture(poseStack, textureIn);
        CosmosUISystem.setTextureColour(colourIn);
    }

    public static void setTextureWithColourAlpha(PoseStack poseStack, ResourceLocation textureIn, float redIn, float greenIn, float blueIn, float alphaIn) {
        CosmosUISystem.setTexture(poseStack, textureIn);
        CosmosUISystem.setTextureColour(redIn, greenIn, blueIn, alphaIn);
        CosmosUISystem.enableAlpha();
    }

    public static void setTextureWithColourAlpha(PoseStack poseStack, ResourceLocation textureIn, float[] colourIn) {
        CosmosUISystem.setTexture(poseStack, textureIn);
        CosmosUISystem.setTextureColour(colourIn);
        CosmosUISystem.enableAlpha();
    }

    public static void setTexture(PoseStack poseStack, ResourceLocation textureIn) {
        CosmosUISystem.setTextureColour(NORMAL_COLOUR);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureIn);
    }

    public static void nullTexture(PoseStack poseStack, ResourceLocation textureIn) {
        RenderSystem.deleteTexture((int)0);
    }

    public static void enableAlpha() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
    }

    public static void setTextureColour(ComponentColour colourIn) {
        float[] rgb = ComponentColour.rgbFloatArray(colourIn);
        CosmosUISystem.setTextureColour(rgb[0], rgb[1], rgb[2], 1.0f);
    }

    public static void setTextureColour(float redIn, float greenIn, float blueIn, float alphaIn) {
        CosmosUISystem.setTextureColour(new float[]{redIn, greenIn, blueIn, alphaIn});
    }

    public static void setTextureColour(float redIn, float greenIn, float blueIn) {
        CosmosUISystem.setTextureColour(new float[]{redIn, greenIn, blueIn, 1.0f});
    }

    public static void setTextureColour(float[] colourIn) {
        RenderSystem.setShaderColor((float)colourIn[0], (float)colourIn[1], (float)colourIn[2], (float)colourIn[3]);
    }

    public static List<Component> getItemTooltip(Screen screen, ItemStack stackIn) {
        Minecraft minecraft = screen.getMinecraft();
        return stackIn.m_41651_((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    public static void renderItemStack(Screen screen, Font font, GuiGraphics graphics, ItemStack itemStackIn, int[] screenCoords, int x, int y, int mouseX, int mouseY, boolean withTooltip) {
        int renderX = screenCoords[0] + x;
        int renderY = screenCoords[1] + y;
        graphics.m_280480_(itemStackIn, screenCoords[0] + x, screenCoords[1] + y);
        if (withTooltip && mouseX > renderX && mouseX < renderX + 16 && mouseY > renderY && mouseY < renderY + 16) {
            graphics.m_280666_(font, CosmosUISystem.getItemTooltip(screen, itemStackIn), mouseX, mouseY);
        }
    }

    public static void renderItemStack(Screen screen, Font font, GuiGraphics graphics, ItemStack itemStackIn, int count, int[] screenCoords, int x, int y, int mouseX, int mouseY, boolean withTooltip) {
        int renderX = screenCoords[0] + x;
        int renderY = screenCoords[1] + y;
        graphics.m_280480_(itemStackIn, screenCoords[0] + x, screenCoords[1] + y);
        if (withTooltip && mouseX > renderX && mouseX < renderX + 16 && mouseY > renderY && mouseY < renderY + 16) {
            graphics.m_280666_(font, CosmosUISystem.getItemTooltip(screen, itemStackIn), mouseX, mouseY);
        }
    }

    public static void renderEnergyDisplay(Screen screen, GuiGraphics graphics, ComponentColour colourIn, IEnergyHolder energyHolderIn, int[] screenCoords, int drawX, int drawY, int widthIn, int heightIn, boolean horizontal) {
        if (horizontal) {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0, 0, widthIn, heightIn);
            if (energyHolderIn.hasEnergyStored()) {
                int scaled = energyHolderIn.getEnergyStoredScaled(widthIn);
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0 + scaled, 0, scaled, heightIn);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY, 0, 255 - heightIn, widthIn, heightIn);
            if (energyHolderIn.hasEnergyStored()) {
                int scaled = energyHolderIn.getEnergyStoredScaled(heightIn);
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY + heightIn - scaled, 0, 255 - scaled, widthIn, scaled);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        }
    }

    public static void renderEnergyDisplay(Screen screen, GuiGraphics graphics, ComponentColour colourIn, IEnergyEntity energyHolderIn, int[] screenCoords, int drawX, int drawY, int widthIn, int heightIn, boolean horizontal) {
        if (horizontal) {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0, 0, widthIn, heightIn);
            if (energyHolderIn.hasEnergy()) {
                int scaled = energyHolderIn.getEnergyScaled(widthIn);
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0 + scaled, 0, scaled, heightIn);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY, 0, 255 - heightIn, widthIn, heightIn);
            if (energyHolderIn.hasEnergy()) {
                int scaled = energyHolderIn.getEnergyScaled(heightIn);
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY + heightIn - scaled, 0, 255 - scaled, widthIn, scaled);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        }
    }

    public static void renderEnergyDisplay(Screen screen, GuiGraphics graphics, ComponentColour colourIn, int energyIn, int maxEnergyIn, int scaleIn, int[] screenCoords, int drawX, int drawY, int widthIn, int heightIn, boolean horizontal) {
        if (horizontal) {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0, 0, widthIn, heightIn);
            if (energyIn > 0) {
                int scaled = energyIn * scaleIn / maxEnergyIn;
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0 + scaled, 0, scaled, heightIn);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY, 0, 255 - heightIn, widthIn, heightIn);
            if (energyIn > 0) {
                int scaled = energyIn * scaleIn / maxEnergyIn;
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY + heightIn - scaled, 0, 255 - scaled, widthIn, scaled);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        }
    }

    public static void renderEnergyDisplay(Gui screen, GuiGraphics graphics, ComponentColour colourIn, IEnergyHolder energyHolderIn, int[] screenCoords, int drawX, int drawY, int widthIn, int heightIn, boolean horizontal) {
        if (horizontal) {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0, 0, widthIn, heightIn);
            if (energyHolderIn.hasEnergyStored()) {
                int scaled = energyHolderIn.getEnergyStoredScaled(widthIn);
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0 + scaled, 0, scaled, heightIn);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY, 0, 255 - heightIn, widthIn, heightIn);
            if (energyHolderIn.hasEnergyStored()) {
                int scaled = energyHolderIn.getEnergyStoredScaled(heightIn);
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY + heightIn - scaled, 0, 255 - scaled, widthIn, scaled);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        }
    }

    public static void renderEnergyDisplay(Gui screen, GuiGraphics graphics, ComponentColour colourIn, int energyIn, int maxEnergyIn, int scaleIn, int[] screenCoords, int drawX, int drawY, int widthIn, int heightIn, boolean horizontal) {
        if (horizontal) {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0, 0, widthIn, heightIn);
            if (energyIn > 0) {
                int scaled = energyIn * scaleIn / maxEnergyIn;
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_HORIZONTAL, screenCoords, drawX, drawY, 0 + scaled, 0, scaled, heightIn);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL);
            CosmosUISystem.setTextureColour(0.6f, 0.6f, 0.6f);
            CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY, 0, 255 - heightIn, widthIn, heightIn);
            if (energyIn > 0) {
                int scaled = energyIn * scaleIn / maxEnergyIn;
                CosmosUISystem.setTextureColour(colourIn);
                CosmosUISystem.renderStaticElement(screen, graphics, CosmosReference.RESOURCE.BASE.UI_ENERGY_VERTICAL, screenCoords, drawX, drawY + heightIn - scaled, 0, 255 - scaled, widthIn, scaled);
                CosmosUISystem.setTextureColour(NORMAL_COLOUR);
            }
        }
    }

    public static void renderSlot(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int[] slot_location) {
        CosmosUISystem.setTexture(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.GUI_SLOT_LOC);
        graphics.m_280218_(CosmosReference.RESOURCE.BASE.GUI_SLOT_LOC, screenCoords[0] + drawX, screenCoords[1] + drawY, slot_location[0], slot_location[1], slot_location[2], slot_location[3]);
    }

    public static void renderBackground(Screen screen, GuiGraphics graphics, int[] screenCoords, ResourceLocation textureIn) {
        CosmosUISystem.setTexture(graphics.m_280168_(), textureIn);
        graphics.m_280218_(textureIn, screenCoords[0], screenCoords[1], 0, 0, screen.f_96543_, screen.f_96544_);
    }

    public static void renderBackground(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, ResourceLocation textureIn) {
        CosmosUISystem.setTexture(graphics.m_280168_(), textureIn);
        graphics.m_280218_(textureIn, screenCoords[0], screenCoords[1], drawX, drawY, screen.f_96543_, screen.f_96544_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidTank(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, IFluidTank tank, int scaledIn, int scaleMax) {
        PoseStack poseStack = graphics.m_280168_();
        if (tank.getFluidAmount() > 0) {
            Fluid renderFluid = tank.getFluid().getFluid();
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)renderFluid.m_76145_());
            TextureAtlas texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
            ResourceLocation textureLoc = props.getStillTexture();
            TextureAtlasSprite fluidTexture = texture.m_118316_(textureLoc);
            int color = props.getTintColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color >> 0 & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            CosmosUISystem.setTextureColour(r, g, b, a);
            if (fluidTexture != null) {
                int limited;
                int scaled;
                poseStack.m_85836_();
                if (scaledIn > 0) {
                    int limited2 = Mth.m_14045_((int)scaledIn, (int)0, (int)16);
                    graphics.m_280159_(screenCoords[0] + drawX, screenCoords[1] + drawY + scaleMax - limited2, 0, 16, limited2, fluidTexture);
                }
                if (scaledIn > 16) {
                    scaled = scaledIn - 16;
                    limited = Mth.m_14045_((int)scaled, (int)0, (int)16);
                    graphics.m_280159_(screenCoords[0] + drawX, screenCoords[1] + drawY + (scaleMax - 16) - limited, 0, 16, limited, fluidTexture);
                }
                if (scaledIn > 32) {
                    scaled = scaledIn - 32;
                    limited = Mth.m_14045_((int)scaled, (int)0, (int)16);
                    graphics.m_280159_(screenCoords[0] + drawX, screenCoords[1] + drawY + (scaleMax - 32) - limited, 0, 16, limited, fluidTexture);
                }
                if (scaledIn > 48) {
                    scaled = scaledIn - 48;
                    limited = Mth.m_14045_((int)scaled, (int)0, (int)16);
                    graphics.m_280159_(screenCoords[0] + drawX, screenCoords[1] + drawY + (scaleMax - 48) - limited, 0, 16, limited, fluidTexture);
                }
                if (scaledIn > 64) {
                    scaled = scaledIn - 64;
                    limited = Mth.m_14045_((int)scaled, (int)0, (int)16);
                    graphics.m_280159_(screenCoords[0] + drawX, screenCoords[1] + drawY + (scaleMax - 64) - limited, 0, 16, limited, fluidTexture);
                }
                poseStack.m_85849_();
            }
        }
    }

    public static void renderEntityInInventory(PoseStack poseStackIn, int[] screenCoordsIn, int xPosIn, int yPosIn, int scaleIn, float mouseXPos, float mouseYPos, int mouseYOffset, LivingEntity entityIn) {
        float angleX = (float)Math.atan(((float)(screenCoordsIn[0] + xPosIn) - mouseXPos) / 40.0f);
        float angleY = (float)Math.atan(((float)(screenCoordsIn[1] + yPosIn - mouseYOffset) - mouseYPos) / 40.0f);
        CosmosUISystem.renderEntityInInventoryRaw(poseStackIn, screenCoordsIn, xPosIn, yPosIn, scaleIn, angleX, angleY, entityIn);
    }

    public static void renderEntityInInventoryRaw(PoseStack poseStackInA, int[] screenCoordsIn, int xPosIn, int yPosIn, int scaleIn, float angleXComponent, float angleYComponent, LivingEntity entityIn) {
        float f = angleXComponent;
        float f1 = angleYComponent;
        PoseStack poseStackIn = RenderSystem.getModelViewStack();
        poseStackIn.m_85836_();
        poseStackIn.m_85837_((double)(screenCoordsIn[0] + xPosIn), (double)(screenCoordsIn[1] + yPosIn), 1050.0);
        poseStackIn.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_((float)scaleIn, (float)scaleIn, (float)scaleIn);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        posestack1.m_252781_(quaternionf);
        float entityYBodyRot = entityIn.f_20883_;
        float entityYRot = entityIn.m_146908_();
        float entityXRot = entityIn.m_146909_();
        float entityHeadYRot0 = entityIn.f_20886_;
        float entityHeadYRot = entityIn.f_20885_;
        entityIn.f_20883_ = 180.0f + f * 20.0f;
        entityIn.m_146922_(180.0f + f * 40.0f);
        entityIn.m_146926_(-f1 * 20.0f);
        entityIn.f_20885_ = entityIn.m_146908_();
        entityIn.f_20886_ = entityIn.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternionf1.conjugate();
        entityrenderdispatcher.m_252923_(quaternionf1);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        ItemStack heldStack = entityIn.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack heldStackOffHand = entityIn.m_21120_(InteractionHand.OFF_HAND);
        entityIn.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        entityIn.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)entityIn, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        entityIn.m_21008_(InteractionHand.MAIN_HAND, heldStack);
        entityIn.m_21008_(InteractionHand.OFF_HAND, heldStackOffHand);
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entityIn.f_20883_ = entityYBodyRot;
        entityIn.m_146922_(entityYRot);
        entityIn.m_146926_(entityXRot);
        entityIn.f_20886_ = entityHeadYRot0;
        entityIn.f_20885_ = entityHeadYRot;
        poseStackIn.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    public static void blit(PoseStack poseStackIn, int posX, int posY, int ex, int widthIn, int heightIn, TextureAtlasSprite spriteIn) {
        float mappedHeight = CosmosRendererHelper.getMappedTextureHeight(spriteIn, heightIn);
        CosmosUISystem.innerBlit(poseStackIn.m_85850_().m_252922_(), posX, posX + widthIn, posY, posY + heightIn, ex, spriteIn.m_118409_(), spriteIn.m_118410_(), spriteIn.m_118411_() + mappedHeight, spriteIn.m_118412_());
    }

    private static void innerBlit(Matrix4f matrixIn, int minX, int maxX, int minY, int maxY, int zIn, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrixIn, (float)minX, (float)maxY, (float)zIn).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrixIn, (float)maxX, (float)maxY, (float)zIn).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrixIn, (float)maxX, (float)minY, (float)zIn).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrixIn, (float)minX, (float)minY, (float)zIn).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_231175_();
    }

    public static void renderToolTipPowerProducer(Screen screen, GuiGraphics graphics, Font font, int[] screenCoords, int drawX, int drawY, int mouseX, int mouseY, int stored, int generation_rate, boolean producing) {
        if (IS_HOVERING.isHoveringPower(mouseX, mouseY, screenCoords[0] + drawX, screenCoords[1] + drawY)) {
            if (producing) {
                graphics.m_280666_(font, TEXT_LIST.generationText(stored, generation_rate), mouseX - screenCoords[0], mouseY - screenCoords[1]);
            } else {
                graphics.m_280666_(font, TEXT_LIST.storedTextNo(stored), mouseX - screenCoords[0], mouseY - screenCoords[1]);
            }
        }
    }

    public static void renderToolTipFluidLarge(Screen screen, GuiGraphics graphics, Font font, int[] screenCoords, int drawX, int drawY, int mouseX, int mouseY, IFluidTank tank) {
        if (IS_HOVERING.isHoveringFluidLarge(mouseX, mouseY, screenCoords[0] + drawX, screenCoords[1] + drawY)) {
            if (tank.getFluidAmount() > 0) {
                graphics.m_280666_(font, TEXT_LIST.fluidText(tank.getFluid().getDisplayName().toString(), tank.getFluidAmount(), tank.getCapacity()), mouseX - screenCoords[0], mouseY - screenCoords[1]);
            } else {
                graphics.m_280666_(font, TEXT_LIST.fluidTextEmpty(), mouseX - screenCoords[0], mouseY - screenCoords[1]);
            }
        }
    }

    public static void renderToolTipEmptyFluidButton(Screen screen, GuiGraphics graphics, Font font, int[] screenCoords, int drawX, int drawY, int mouseX, int mouseY, boolean has_fluid) {
        if (IS_HOVERING.isHoveringButtonStandard(mouseX, mouseY, screenCoords[0] + drawX, screenCoords[1] + drawY) && has_fluid) {
            if (ComponentHelper.isShiftKeyDown(screen.getMinecraft())) {
                graphics.m_280666_(font, TEXT_LIST.emptyFluidTankDo(), mouseX - screenCoords[0], mouseY - screenCoords[1]);
            } else {
                graphics.m_280666_(font, TEXT_LIST.emptyFluidTank(), mouseX - screenCoords[0], mouseY - screenCoords[1]);
            }
        }
    }

    public static void renderScaledElementUpNestled(Screen screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, int scaledIn) {
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY + height - scaledIn, textureInX, textureInY + height - scaledIn, width, scaledIn);
    }

    public static void renderScaledElementDownNestled(Screen screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int scaledIn) {
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, scaledIn);
    }

    public static void renderScaledElementRightNestled(Screen screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int height, int scaledIn) {
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, scaledIn + 1, height);
    }

    public static void renderScaledElementUpExternal(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, int scaledIn, ResourceLocation textureIn) {
        CosmosUISystem.setTexture(graphics.m_280168_(), textureIn);
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY + height - scaledIn, textureInX, textureInY + height - scaledIn, width, scaledIn);
    }

    public static void renderScaledElementDownExternal(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int scaledIn, ResourceLocation textureIn) {
        CosmosUISystem.setTexture(graphics.m_280168_(), textureIn);
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY + scaledIn, width, scaledIn);
    }

    public static void renderStaticElementWithUIMode(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, IBlockEntityUIMode entity, ResourceLocation[] locations) {
        if (entity.getUIMode().equals((Object)EnumUIMode.DARK)) {
            CosmosUISystem.setTexture(graphics.m_280168_(), locations[1]);
            graphics.m_280218_(locations[1], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), locations[0]);
            graphics.m_280218_(locations[0], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        }
    }

    public static void renderStaticElementWithUIMode(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, EnumUIMode uiMode, ResourceLocation[] locations) {
        if (uiMode.equals((Object)EnumUIMode.DARK)) {
            CosmosUISystem.setTexture(graphics.m_280168_(), locations[1]);
            graphics.m_280218_(locations[1], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        } else {
            CosmosUISystem.setTexture(graphics.m_280168_(), locations[0]);
            graphics.m_280218_(locations[0], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        }
    }

    public static void renderStaticElementWithUIMode(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, float[] colourIn, IBlockEntityUIMode entity, ResourceLocation[] locations) {
        if (entity.getUIMode().equals((Object)EnumUIMode.DARK)) {
            CosmosUISystem.setTextureWithColour(graphics.m_280168_(), locations[1], colourIn);
            graphics.m_280218_(locations[1], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        } else {
            CosmosUISystem.setTextureWithColour(graphics.m_280168_(), locations[0], colourIn);
            graphics.m_280218_(locations[0], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        }
    }

    public static void renderStaticElementWithUIMode(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, float[] colourIn, EnumUIMode uiMode, ResourceLocation[] locations) {
        if (uiMode.equals((Object)EnumUIMode.DARK)) {
            CosmosUISystem.setTextureWithColour(graphics.m_280168_(), locations[1], colourIn);
            graphics.m_280218_(locations[1], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        } else {
            CosmosUISystem.setTextureWithColour(graphics.m_280168_(), locations[0], colourIn);
            graphics.m_280218_(locations[0], screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        }
    }

    public static void renderStaticElement(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, ResourceLocation location) {
        CosmosUISystem.setTexture(graphics.m_280168_(), location);
        graphics.m_280218_(location, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
    }

    public static void renderStaticElement(Screen screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, float[] colourIn, ResourceLocation location) {
        CosmosUISystem.setTextureWithColour(graphics.m_280168_(), location, colourIn);
        graphics.m_280218_(location, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
    }

    public static void renderStaticElement(Screen screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height) {
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
    }

    public static void renderStaticElement(Gui screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, ResourceLocation location) {
        CosmosUISystem.setTexture(graphics.m_280168_(), location);
        graphics.m_280218_(location, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
    }

    public static void renderStaticElement(Gui screen, GuiGraphics graphics, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, float[] colourIn, ResourceLocation location) {
        CosmosUISystem.setTextureWithColour(graphics.m_280168_(), location, colourIn);
        graphics.m_280218_(location, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
    }

    public static void renderStaticElement(Gui screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height) {
        graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
    }

    public static void renderStaticElementToggled(Screen screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, boolean enabled) {
        if (enabled) {
            graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        }
    }

    public static void renderStaticElementToggled(Gui screen, GuiGraphics graphics, ResourceLocation textureIn, int[] screenCoords, int drawX, int drawY, int textureInX, int textureInY, int width, int height, boolean enabled) {
        if (enabled) {
            graphics.m_280218_(textureIn, screenCoords[0] + drawX, screenCoords[1] + drawY, textureInX, textureInY, width, height);
        }
    }

    public static class IS_HOVERING {
        public static boolean isHoveringPower(int mouseX, int mouseY, int x, int y) {
            return mouseX >= x && mouseX <= x + 17 && mouseY >= y && mouseY <= y + 62;
        }

        public static boolean isHoveringPowerSmall(int mouseX, int mouseY, int x, int y) {
            return mouseX >= x && mouseX <= x + 17 && mouseY >= y && mouseY <= y + 40;
        }

        public static boolean isHovering(int mouseX, int mouseY, int minX, int maxX, int minY, int maxY) {
            return mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY;
        }

        public static boolean isHoveringFluid(int mouseX, int mouseY, int x, int y) {
            return mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 38;
        }

        public static boolean isHoveringFluidLarge(int mouseX, int mouseY, int x, int y) {
            return mouseX >= x - 1 && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 57;
        }

        public static boolean isHoveringButtonStandard(int mouseX, int mouseY, int x, int y) {
            return mouseX >= x && mouseX <= x + 18 && mouseY >= y && mouseY <= y + 18;
        }

        public static boolean isHoveringButton(int mouseX, int mouseY, int x, int y, int xSize, int ySize) {
            return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
        }
    }

    @Deprecated(since="1.18.1", forRemoval=true)
    public static class TEXT_LIST {
        public static List<Component> storedTextRF(int stored, int speed) {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)("\u00a75Stored: \u00a76" + stored)), Component.m_237113_((String)("\u00a72Using: \u00a73" + speed + "\u00a72 FE/t."))};
            return Arrays.asList(description);
        }

        public static List<Component> storedTextNo(int stored) {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)("\u00a75Stored: \u00a76" + stored))};
            return Arrays.asList(description);
        }

        public static List<Component> fluidText(String name, int amount, int capacity) {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)("\u00a73Fluid: " + name)), Component.m_237113_((String)("\u00a76Amount: " + amount + " / " + capacity + " mB"))};
            return Arrays.asList(description);
        }

        public static List<Component> fluidTextEmpty() {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)"\u00a73Empty:"), Component.m_237113_((String)"\u00a76Amount: 0 mB")};
            return Arrays.asList(description);
        }

        public static List<Component> emptyFluidTankDo() {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)"\u00a72Empty tank."), Component.m_237113_((String)"\u00a74Warning: \u00a76Cannot be undone!")};
            return Arrays.asList(description);
        }

        public static List<Component> emptyFluidTank() {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)"\u00a72Shift click \u00a77to empty tank.")};
            return Arrays.asList(description);
        }

        public static List<Component> modeChange(String colourIn, String mode) {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)"\u00a72Click to change mode."), Component.m_237113_((String)("\u00a77Current mode: " + colourIn + mode + "\u00a77."))};
            return Arrays.asList(description);
        }

        public static List<Component> generationText(int storedIn, int generationRateIn) {
            MutableComponent[] description = new MutableComponent[]{Component.m_237113_((String)("\u00a75Stored: \u00a76" + storedIn)), Component.m_237113_((String)("\u00a74Producing: \u00a73" + generationRateIn + "\u00a74 FE/t."))};
            return Arrays.asList(description);
        }
    }

    public static class FONT {
        public static void drawString(GuiGraphics graphics, Font font, int[] screenCoords, int x, int y, boolean drawFrom, Component comp) {
            graphics.m_280614_(font, comp, !drawFrom ? x : screenCoords[0] + x, !drawFrom ? y : screenCoords[1] + y, comp.m_7383_().m_131135_().m_131265_(), false);
        }

        public static void drawStringShadow(GuiGraphics graphics, Font font, int[] screenCoords, int x, int y, boolean drawFrom, Component comp) {
            graphics.m_280614_(font, comp, !drawFrom ? x : screenCoords[0] + x, !drawFrom ? y : screenCoords[1] + y, comp.m_7383_().m_131135_().m_131265_(), true);
        }

        public static void drawCenteredString(GuiGraphics graphics, Font font, int[] screenCoords, int xOffset, int yOffset, Component comp) {
            int x = screenCoords[0] * 2 / 2;
            int y = screenCoords[1] * 2 / 2 + 33;
            graphics.m_280430_(font, comp, x - font.m_92852_((FormattedText)comp) / 2 + xOffset, y + yOffset, comp.m_7383_().m_131135_().m_131265_());
        }

        public static void drawWrappedStringBR(GuiGraphics graphics, Font font, int[] screenCoords, int xOffset, int yOffset, int length, Component comp) {
            int prevLines = 0;
            for (String str : comp.getString().split("<br>")) {
                int x = screenCoords[0] * 2 / 2;
                int y = screenCoords[1] * 2 / 2 + 33;
                int n = x - font.m_92895_(str) / 2 + xOffset;
                Objects.requireNonNull(font);
                graphics.m_280488_(font, str, n, y + yOffset + 9 * prevLines, comp.m_7383_().m_131135_().m_131265_());
                prevLines += (int)Math.ceil((float)(str.length() * 7) / 204.0f);
            }
        }

        public static void drawCenteredComponent(GuiGraphics graphics, Font font, int[] screenCoords, int xOffset, int yOffset, Component string, boolean shadow) {
            int x = screenCoords[0] * 2 / 2;
            int y = screenCoords[1] * 2 / 2 + 33;
            graphics.drawString(font, string.toString(), (float)(x - font.m_92852_((FormattedText)string) / 2) + (float)xOffset, (float)(y + yOffset), string.m_7383_().m_131135_().m_131265_(), shadow);
        }

        public static void drawCenteredString(GuiGraphics graphics, Font font, int[] screenCoords, int xOffset, int yOffset, int colourIn, String string, boolean shadow) {
            int x = screenCoords[0] * 2 / 2;
            int y = screenCoords[1] * 2 / 2 + 33;
            graphics.drawString(font, string, (float)(x - font.m_92895_(string) / 2) + (float)xOffset, (float)(y + yOffset), colourIn, shadow);
        }

        public static void drawWrappedStringBR(GuiGraphics graphics, Font font, int[] screenCoords, int xOffset, int yOffset, int length, int colourIn, String string) {
            int prevLines = 0;
            for (String str : string.split("<br>")) {
                int x = screenCoords[0] * 2 / 2;
                int y = screenCoords[1] * 2 / 2 + 33;
                int n = x - font.m_92895_(str) / 2 + xOffset;
                Objects.requireNonNull(font);
                graphics.m_280056_(font, str, n, y + yOffset + 9 * prevLines, colourIn, false);
                prevLines += (int)Math.ceil((float)(str.length() * 7) / 204.0f);
            }
        }

        public static void drawInventoryString(GuiGraphics graphics, Font font, int[] screenCoords, int drawX, int drawY, boolean drawFrom) {
            if (drawFrom) {
                graphics.m_280488_(font, I18n.m_118938_((String)"screen.inventory", (Object[])new Object[0]), screenCoords[0] + drawX, screenCoords[1] + drawY, 0x404040);
            } else {
                graphics.m_280488_(font, I18n.m_118938_((String)"screen.inventory", (Object[])new Object[0]), drawX, drawY, 0x404040);
            }
        }

        public static void drawInventoryString(GuiGraphics graphics, Font font, int[] screenCoords, int drawX, int drawY, int colourIn) {
            graphics.m_280488_(font, I18n.m_118938_((String)"screen.inventory", (Object[])new Object[0]), screenCoords[0] + drawX, screenCoords[1] + drawY, colourIn);
        }
    }

    public static class Widget {
        public static CosmosButtonWithType addBucketButton(int indexIn, int[] screenCoords, int drawX, int drawY, int sizeIn, boolean enabled) {
            CosmosButtonWithType button = enabled ? new CosmosButtonWithType(CosmosButtonWithType.TYPE.FLUID, screenCoords[0] + drawX, screenCoords[1] + drawY, sizeIn, true, false, 1, (Component)ComponentHelper.empty(), (buttonObj, isLeftClick) -> {}) : new CosmosButtonWithType(CosmosButtonWithType.TYPE.FLUID, screenCoords[0] + drawX, screenCoords[1] + drawY, sizeIn, true, true, 4, (Component)ComponentHelper.empty(), (buttonObj, isLeftClick) -> {});
            return button;
        }
    }
}

