/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.lib.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonBase;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonUIHelp;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonUILock;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonUIMode;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosUIHelpElement;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBlockEntityUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.runtime.NetworkManagerCosmos;
import com.tcn.cosmoslibrary.runtime.network.PacketUIHelp;
import com.tcn.cosmoslibrary.runtime.network.PacketUILock;
import com.tcn.cosmoslibrary.runtime.network.PacketUIMode;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CosmosScreenUIModeBE<J extends CosmosContainerMenuBlockEntity>
extends AbstractContainerScreen<J> {
    protected ResourceLocation TEXTURE_LIGHT;
    protected ResourceLocation TEXTURE_DARK;
    protected ResourceLocation DUAL_TEXTURE_LIGHT;
    protected ResourceLocation DUAL_TEXTURE_DARK;
    protected CosmosButtonUIMode uiModeButton;
    private int[] uiModeButtonIndex;
    protected CosmosButtonUIHelp uiHelpButton;
    private int[] uiHelpButtonIndex;
    protected CosmosButtonUILock uiLockButton;
    private int[] uiLockButtonIndex;
    protected List<CosmosUIHelpElement> uiHelpElements = Lists.newArrayList();
    private int[] screenCoords;
    private boolean hasDualScreen = false;
    private int[] dualScreenIndex;
    private boolean renderTitleLabel = true;
    private boolean renderInventoryLabel = true;
    private boolean hasUIHelp = false;
    private boolean hasUIHelpElementDeadzone = false;
    private int[] uiHelpElementDeadzone;
    private int uiHelpTitleYOffset = 0;
    private boolean hasUILock = false;
    private boolean hasEditBox = false;

    public CosmosScreenUIModeBE(J containerIn, Inventory playerInventoryIn, Component titleIn) {
        super(containerIn, playerInventoryIn, titleIn);
    }

    protected void m_7856_() {
        this.setScreenCoords(CosmosUISystem.getScreenCoords(this, this.f_97726_, this.f_97727_));
        super.m_7856_();
        this.initEditBox();
        this.addButtons();
        this.addUIHelpElements();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderComponents(graphics, mouseX, mouseY, partialTicks);
        this.renderComponentHoverEffect(graphics, Style.f_131099_, mouseX, mouseY);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public void renderComponents(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.addButtons();
        this.addUIHelpElements();
        this.renderUIHelpElements(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(GuiGraphics graphics, float mouseX, int mouseY, int partialTicks) {
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof IBlockEntityUIMode) {
            IBlockEntityUIMode entityMode = (IBlockEntityUIMode)entity;
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            if (entityMode.getUIHelp().equals((Object)EnumUIHelp.SHOWN)) {
                colour = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
            }
            CosmosUISystem.renderStaticElementWithUIMode((Screen)this, graphics, this.screenCoords, 0, 0, 0, 0, Mth.m_14045_((int)this.f_97726_, (int)0, (int)256), this.f_97727_, colour, entityMode.getUIMode(), new ResourceLocation[]{this.TEXTURE_LIGHT, this.TEXTURE_DARK});
            if (this.hasDualScreen && this.dualScreenIndex != null && this.DUAL_TEXTURE_LIGHT != null && this.DUAL_TEXTURE_LIGHT != null) {
                CosmosUISystem.renderStaticElementWithUIMode((Screen)this, graphics, this.screenCoords, this.dualScreenIndex[0], this.dualScreenIndex[1], 0, 0, Mth.m_14045_((int)(256 + this.dualScreenIndex[2]), (int)0, (int)256), this.dualScreenIndex[3], colour, entityMode.getUIMode(), new ResourceLocation[]{this.DUAL_TEXTURE_LIGHT, this.DUAL_TEXTURE_DARK});
            }
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof IBlockEntityUIMode) {
            IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
            if (this.renderTitleLabel) {
                graphics.m_280430_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, blockEntity.getUIMode().equals((Object)EnumUIMode.DARK) ? 0xFFFFFF : ComponentColour.SCREEN_LIGHT.dec());
            }
            if (this.renderInventoryLabel) {
                graphics.m_280430_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, blockEntity.getUIMode().equals((Object)EnumUIMode.DARK) ? 0xFFFFFF : ComponentColour.SCREEN_LIGHT.dec());
            }
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.getHasUIHelpShow()) {
            if (this.hasUIHelpElementDeadzone) {
                if (mouseX <= this.getScreenCoords()[0] + this.uiHelpElementDeadzone[0] || mouseX >= this.getScreenCoords()[0] + this.uiHelpElementDeadzone[2] || mouseY <= this.getScreenCoords()[1] + this.uiHelpElementDeadzone[1] || mouseY >= this.getScreenCoords()[1] + this.uiHelpElementDeadzone[3]) {
                    super.m_280072_(graphics, mouseX, mouseY);
                }
            } else {
                super.m_280072_(graphics, mouseX, mouseY);
            }
        } else {
            super.m_280072_(graphics, mouseX, mouseY);
        }
    }

    public void renderComponentHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof IBlockEntityUIMode) {
            Component[] comp;
            IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
            if (blockEntity.getUIHelp().equals((Object)EnumUIHelp.HIDDEN)) {
                this.renderStandardHoverEffect(graphics, style, mouseX, mouseY);
            } else {
                this.renderHelpElementHoverEffect(graphics, mouseX, mouseY);
            }
            if (this.uiModeButton.m_5953_(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.gui.ui_mode.info"), ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.gui.ui_mode.value").m_7220_((Component)blockEntity.getUIMode().getColouredComp())};
                graphics.m_280666_(this.f_96547_, Arrays.asList(comp), mouseX, mouseY);
            }
            if (this.getHasUIHelp() && this.uiHelpButton.m_5953_(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.gui.ui_help.info"), ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.gui.ui_help.value").m_7220_((Component)blockEntity.getUIHelp().getColouredComp())};
                graphics.m_280666_(this.f_96547_, Arrays.asList(comp), mouseX, mouseY);
            }
            if (this.getHasUILock() && this.uiLockButton.m_5953_(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.gui.ui_lock.info"), ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.gui.ui_lock.value").m_7220_((Component)blockEntity.getUILock().getColouredComp())};
                graphics.m_280666_(this.f_96547_, Arrays.asList(comp), mouseX, mouseY);
            }
        }
    }

    protected void renderStandardHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
    }

    protected void renderHelpElementHoverEffect(GuiGraphics graphics, int mouseX, int mouseY) {
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof IBlockEntityUIMode) {
            IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
            if (this.getHasUIHelpShow() && blockEntity.getUIHelp().equals((Object)EnumUIHelp.SHOWN)) {
                for (CosmosUIHelpElement element : this.uiHelpElements) {
                    if (!element.m_5953_(mouseX, mouseY)) continue;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    graphics.m_280666_(this.f_96547_, element.getHoverElement(), mouseX, mouseY);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MutableComponent title = ComponentHelper.style(ComponentColour.GREEN, "cosmoslibrary.gui_help_title");
                graphics.m_280666_(this.f_96547_, Arrays.asList(title), this.getScreenCoords()[0] * 2 / 2 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2 - 13, this.getScreenCoords()[1] - 2 + this.uiHelpTitleYOffset);
            }
        }
    }

    protected void renderUIHelpElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getHasUIHelpShow()) {
            for (CosmosUIHelpElement element : this.uiHelpElements) {
                element.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
            for (Renderable widget : this.f_169369_) {
                if (widget instanceof CosmosUIHelpElement || widget instanceof CosmosButtonUIHelp || widget instanceof CosmosButtonUIMode || !(widget instanceof Button)) continue;
                Button button = (Button)widget;
                button.f_93623_ = false;
            }
        }
    }

    protected void addButtons() {
        this.m_169413_();
        int[] screen_coords = CosmosUISystem.getScreenCoords(this, this.f_97726_, this.f_97727_);
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof IBlockEntityUIMode) {
            IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
            this.addUIModeButton(blockEntity, screen_coords, this.uiModeButtonIndex, button -> this.clickButton(this.uiModeButton, true));
            if (this.getHasUIHelp()) {
                this.addUIHelpButton(blockEntity, screen_coords, this.uiHelpButtonIndex, button -> this.clickButton(this.uiHelpButton, true));
            }
            if (this.getHasUILock()) {
                this.addUILockButton(blockEntity, screen_coords, this.uiLockButtonIndex, button -> this.clickButton(this.uiLockButton, true));
            }
        }
    }

    protected void clickButton(Button buttonIn, boolean isLeftClick) {
        BlockEntity entity = this.getBlockEntity();
        if (isLeftClick && entity instanceof IBlockEntityUIMode) {
            IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
            if (buttonIn.equals((Object)this.uiModeButton)) {
                NetworkManagerCosmos.sendToServer(new PacketUIMode((CosmosContainerMenuBlockEntity)this.f_97732_));
                blockEntity.cycleUIMode();
            } else if (buttonIn.equals((Object)this.uiHelpButton)) {
                NetworkManagerCosmos.sendToServer(new PacketUIHelp((CosmosContainerMenuBlockEntity)this.f_97732_));
                blockEntity.cycleUIHelp();
            } else if (buttonIn.equals((Object)this.uiLockButton)) {
                NetworkManagerCosmos.sendToServer(new PacketUILock((CosmosContainerMenuBlockEntity)this.f_97732_));
                if (blockEntity.checkIfOwner(((CosmosContainerMenuBlockEntity)this.f_97732_).getPlayer())) {
                    blockEntity.cycleUILock();
                }
            }
        }
    }

    protected void initEditBox() {
    }

    protected void addUIModeButton(IBlockEntityUIMode entityIn, int[] screen_coords, int[] indexIn, Button.OnPress pressAction) {
        this.uiModeButton = (CosmosButtonUIMode)this.m_142416_((GuiEventListener)new CosmosButtonUIMode(entityIn.getUIMode(), screen_coords[0] + indexIn[0], screen_coords[1] + indexIn[1], true, true, (Component)ComponentHelper.empty(), pressAction));
    }

    protected void addUIHelpButton(IBlockEntityUIMode entityIn, int[] screen_coords, int[] indexIn, Button.OnPress pressAction) {
        this.uiHelpButton = (CosmosButtonUIHelp)this.m_142416_((GuiEventListener)new CosmosButtonUIHelp(entityIn.getUIHelp(), screen_coords[0] + indexIn[0], screen_coords[1] + indexIn[1], true, true, (Component)ComponentHelper.empty(), pressAction));
    }

    protected void addUILockButton(IBlockEntityUIMode entityIn, int[] screen_coords, int[] indexIn, Button.OnPress pressAction) {
        this.uiLockButton = (CosmosButtonUILock)this.m_142416_((GuiEventListener)new CosmosButtonUILock(entityIn.getUILock(), screen_coords[0] + indexIn[0], screen_coords[1] + indexIn[1], true, true, (Component)ComponentHelper.empty(), pressAction));
    }

    protected void addUIHelpElements() {
        this.clearUIHelpElementList();
    }

    protected void addRenderableUIHelpElement(int[] screenCoords, int xIn, int yIn, int widthIn, int heightIn, Component ... descIn) {
        this.addRenderableUIHelpElement(screenCoords, xIn, yIn, widthIn, heightIn, true, descIn);
    }

    protected void addRenderableUIHelpElement(int[] screenCoords, int xIn, int yIn, int widthIn, int heightIn, ComponentColour colourIn, Component ... descIn) {
        this.addRenderableUIHelpElement(screenCoords, xIn, yIn, widthIn, heightIn, true, colourIn, descIn);
    }

    protected void addRenderableUIHelpElement(int[] screenCoords, int xIn, int yIn, int widthIn, int heightIn, boolean isVisible, Component ... descIn) {
        this.addUIHelpElement(new CosmosUIHelpElement(screenCoords[0] + xIn, screenCoords[1] + yIn, widthIn, heightIn, descIn).setVisible(isVisible));
    }

    protected void addRenderableUIHelpElement(int[] screenCoords, int xIn, int yIn, int widthIn, int heightIn, boolean isVisible, ComponentColour colourIn, Component ... descIn) {
        this.addUIHelpElement(new CosmosUIHelpElement(screenCoords[0] + xIn, screenCoords[1] + yIn, widthIn, heightIn, colourIn, descIn).setVisible(isVisible));
    }

    private CosmosUIHelpElement addUIHelpElement(CosmosUIHelpElement elementIn) {
        this.uiHelpElements.add(elementIn);
        return elementIn;
    }

    protected void clearUIHelpElementList() {
        this.uiHelpElements.clear();
    }

    protected boolean getHasUIHelp() {
        return this.hasUIHelp;
    }

    protected boolean getHasUILock() {
        return this.hasUILock;
    }

    protected void setHasUIHelp() {
        this.hasUIHelp = true;
    }

    protected boolean getHasUIHelpShow() {
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof IBlockEntityUIMode) {
            IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
            return this.hasUIHelp && blockEntity.getUIHelp().equals((Object)EnumUIHelp.SHOWN);
        }
        return false;
    }

    protected void setImageDims(int widthIn, int heightIn) {
        this.f_97726_ = widthIn;
        this.f_97727_ = heightIn;
    }

    protected void setLight(ResourceLocation textureIn) {
        this.TEXTURE_LIGHT = textureIn;
    }

    protected void setDark(ResourceLocation textureIn) {
        this.TEXTURE_DARK = textureIn;
    }

    protected void setDualScreen() {
        this.hasDualScreen = true;
    }

    protected void setDualScreenIndex(int posX, int posY, int width, int height) {
        this.setDualScreen();
        this.dualScreenIndex = new int[]{posX, posY, width, height};
    }

    protected void setDualDark(ResourceLocation textureIn) {
        this.setDualScreen();
        this.DUAL_TEXTURE_DARK = textureIn;
    }

    protected void setDualLight(ResourceLocation textureIn) {
        this.setDualScreen();
        this.DUAL_TEXTURE_LIGHT = textureIn;
    }

    protected void setUIModeButtonIndex(int posX, int posY) {
        this.uiModeButtonIndex = new int[]{posX, posY};
    }

    protected void setUIHelpButtonIndex(int posX, int posY) {
        this.setHasUIHelp();
        this.uiHelpButtonIndex = new int[]{posX, posY};
    }

    protected void setHasUILock() {
        this.hasUILock = true;
    }

    protected void setUILockButtonIndex(int posX, int posY) {
        this.setHasUILock();
        this.uiLockButtonIndex = new int[]{posX, posY};
    }

    protected void setUIHelpTitleOffset(int yOffset) {
        this.uiHelpTitleYOffset = yOffset;
    }

    protected void setHasUIElementDeadzone() {
        this.hasUIHelpElementDeadzone = true;
    }

    protected void setUIHelpElementDeadzone(int minX, int minY, int maxX, int maxY) {
        this.setHasUIElementDeadzone();
        this.uiHelpElementDeadzone = new int[]{minX, minY, maxX, maxY};
    }

    protected void setNoTitleLabel() {
        this.renderTitleLabel = false;
    }

    protected void setTitleLabelDims(int posX, int posY) {
        this.f_97728_ = posX;
        this.f_97729_ = posY;
    }

    protected void setNoInventoryLabel() {
        this.renderInventoryLabel = false;
    }

    protected void setInventoryLabelDims(int posX, int posY) {
        this.f_97730_ = posX;
        this.f_97731_ = posY;
    }

    protected void setHasEditBox() {
        this.hasEditBox = true;
    }

    public boolean getHasEditBox() {
        return this.hasEditBox;
    }

    protected void setScreenCoords(int[] coordsIn) {
        this.screenCoords = coordsIn;
    }

    protected int[] getScreenCoords() {
        return this.screenCoords;
    }

    public BlockEntity getBlockEntity() {
        CosmosContainerMenuBlockEntity container = (CosmosContainerMenuBlockEntity)this.f_97732_;
        Level level = container.getLevel();
        BlockPos pos = container.getBlockPos();
        return level.m_7702_(pos);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (GuiEventListener list : this.m_6702_()) {
            CosmosButtonBase button;
            if (!(list instanceof CosmosButtonBase) || !(button = (CosmosButtonBase)list).m_5953_(mouseX, mouseY) || !button.m_142518_() || !button.visible) continue;
            if (mouseButton == 1) {
                button.onClick(false);
                continue;
            }
            if (mouseButton != 0) continue;
            button.onClick(true);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }
}

