/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen;

import com.tcn.cosmoslibrary.CosmosReference;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.lib.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.CosmosScreenUIModeBE;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosListWidget;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBlockEntityUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CosmosScreenUIModeListBE<J extends CosmosContainerMenuBlockEntity>
extends CosmosScreenUIModeBE<J> {
    protected ResourceLocation WIDGET_TEXTURE;
    protected ArrayList<CosmosListWidget> widgetList = new ArrayList();
    protected ArrayList<String> fromList = new ArrayList();
    private boolean scrollEnabled = false;
    private int currentScroll;
    private int topIndex = 0;
    protected int selectedIndex = -1;
    private int[] listIndex;
    private int[] scrollElementIndex;

    public CosmosScreenUIModeListBE(J containerIn, Inventory playerInventoryIn, Component titleIn) {
        super(containerIn, playerInventoryIn, titleIn);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float mouseX, int mouseY, int partialTicks) {
        super.m_7286_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void updateWidgetList() {
        this.updateFromStringList();
    }

    @Override
    public void renderComponents(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScrollElement(graphics);
        this.updateWidgetList();
        this.renderWidgetList(graphics, mouseX, mouseY, partialTicks);
        super.renderComponents(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            CosmosListWidget widget = this.getListWidget(i);
            if (widget.isMouseOver() && i != 0) {
                widget.mousePressed(this.f_96541_, mouseX, mouseY);
                this.selectWidget(i);
                this.selectedIndex = i;
                continue;
            }
            if (!(mouseX < (double)this.listIndex[0] || mouseX > (double)(this.listIndex[0] + this.listIndex[2]) || mouseY < (double)this.listIndex[1]) && !(mouseY > (double)(this.listIndex[1] + this.listIndex[3]))) continue;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double direction) {
        if (this.scrollEnabled()) {
            int maxScroll = this.widgetList.size() - this.widgetCount();
            this.currentScroll = (int)((double)this.currentScroll + -direction);
            if (this.currentScroll >= 0) {
                if (this.currentScroll <= maxScroll) {
                    if (direction == -1.0) {
                        if (this.topIndex < this.fromList.size()) {
                            ++this.topIndex;
                        }
                    } else if (this.topIndex > 0) {
                        --this.topIndex;
                    }
                    return true;
                }
                this.currentScroll = maxScroll;
                return false;
            }
            this.currentScroll = 0;
            return false;
        }
        return false;
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        this.clearWidgetList();
        super.m_6574_(mc, width, height);
    }

    protected void setListDims(int x, int y, int width, int height, int widgetHeightIn, int widgetSpacingIn) {
        this.listIndex = new int[]{x, y, width, height, widgetHeightIn, widgetSpacingIn};
    }

    protected void setScrollElementDims(int x, int y) {
        this.scrollEnabled = true;
        this.scrollElementIndex = new int[]{x, y};
    }

    protected void setWidgetTexture(ResourceLocation textureIn) {
        this.WIDGET_TEXTURE = textureIn;
    }

    protected void updateFromList(ArrayList<String> fromListIn) {
        this.fromList = fromListIn;
    }

    protected CosmosListWidget addListWidget(CosmosListWidget widget) {
        this.widgetList.add(widget);
        return widget;
    }

    protected CosmosListWidget getListWidget(int index) {
        return this.widgetList.get(index);
    }

    protected ArrayList<CosmosListWidget> getWidgetList() {
        return this.widgetList;
    }

    protected void removeElement() {
        if (this.topIndex > 0) {
            --this.topIndex;
        }
        this.selectedIndex = -1;
    }

    protected void selectWidget(int index) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            this.widgetList.get(i).deselect();
        }
        this.widgetList.get(index).setSelectedState(true);
    }

    protected void deselectWidget(int index) {
        this.widgetList.get(index).setSelectedState(false);
    }

    public int getSelectedWidgetIndex() {
        if (this.selectedIndex > 0) {
            return this.selectedIndex;
        }
        return 0;
    }

    public int widgetCount() {
        return (int)Math.floor(this.listIndex[3] / (this.listIndex[4] + this.listIndex[5]));
    }

    public boolean scrollEnabled() {
        return this.widgetList.size() > this.widgetCount();
    }

    protected void clearWidgetList() {
        this.widgetList.clear();
    }

    private void renderWidgetList(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            CosmosListWidget widget = this.getListWidget(i);
            if (i < this.topIndex || i > this.topIndex + this.widgetCount() || i >= this.widgetList.size()) continue;
            widget.renderWidget(graphics, this.f_96547_, this.getScreenCoords(), this.listIndex[0], this.listIndex[1] + (this.listIndex[4] + this.listIndex[5]) * (i - this.topIndex), mouseX, mouseY, i, this.listIndex[1] + this.listIndex[3]);
        }
    }

    protected void updateFromStringList() {
        this.clearWidgetList();
        int spacing_y = this.listIndex[4] + this.listIndex[5];
        for (int i = 0; i < this.fromList.size(); ++i) {
            CosmosListWidget widget = new CosmosListWidget(this.listIndex[0], this.listIndex[1] + spacing_y * i, this.listIndex[2], this.listIndex[4], this.WIDGET_TEXTURE, this.fromList.get(i), ComponentColour.WHITE);
            this.widgetList.add(widget);
            if (i != this.selectedIndex) continue;
            this.getListWidget(i).setSelectedState(true);
        }
    }

    protected void renderScrollElement(GuiGraphics graphics) {
        int[] scrollType = new int[]{15, 0, 15};
        CosmosUISystem.setTextureWithColour(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.GUI_ELEMENT_MISC_LOC, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        if (this.widgetList.size() > 0) {
            int div = this.widgetList.size() == this.widgetCount() ? 1 : this.widgetList.size() - this.widgetCount();
            int increment = this.listIndex[3] / div;
            int posX = this.scrollElementIndex[0];
            int posY = this.scrollElementIndex[1];
            int posYUpdated = Mth.m_14045_((int)(posY + this.currentScroll * increment), (int)posY, (int)(this.listIndex[1] + this.listIndex[3] - 1 - this.listIndex[4]));
            BlockEntity entity = this.getBlockEntity();
            if (entity instanceof IBlockEntityUIMode) {
                int type = ((IBlockEntityUIMode)entity).getUIMode().equals((Object)EnumUIMode.DARK) ? 0 : 1;
                CosmosUISystem.renderStaticElementToggled((Screen)this, graphics, CosmosReference.RESOURCE.BASE.GUI_ELEMENT_MISC_LOC, this.getScreenCoords(), posX, this.scrollEnabled ? posYUpdated : posY, scrollType[0], scrollType[type + 1], 13, 15, true);
            }
        }
    }
}

