/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen.option;

import com.google.common.collect.ImmutableList;
import com.tcn.cosmoslibrary.client.ui.screen.option.CosmosOptionInstance;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CosmosCycleButton<T>
extends AbstractButton {
    static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::m_96639_;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<CosmosCycleButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final CosmosOptionInstance.TooltipSupplier<T> tooltipSupplier;
    private final boolean displayOnlyValue;

    CosmosCycleButton(int p_232484_, int p_232485_, int p_232486_, int p_232487_, Component p_232488_, Component p_232489_, int p_232490_, T p_232491_, ValueListSupplier<T> p_232492_, Function<T, Component> p_232493_, Function<CosmosCycleButton<T>, MutableComponent> p_232494_, OnValueChange<T> p_232495_, CosmosOptionInstance.TooltipSupplier<T> p_232496_, boolean p_232497_) {
        super(p_232484_, p_232485_, p_232486_, p_232487_, p_232488_);
        this.name = p_232489_;
        this.index = p_232490_;
        this.value = p_232491_;
        this.values = p_232492_;
        this.valueStringifier = p_232493_;
        this.narrationProvider = p_232494_;
        this.onValueChange = p_232495_;
        this.tooltipSupplier = p_232496_;
        this.displayOnlyValue = p_232497_;
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int p_168909_) {
        List<T> list = this.values.getSelectedList();
        this.index = Mth.m_14100_((int)(this.index + p_168909_), (int)list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int p_168915_) {
        List<T> list = this.values.getSelectedList();
        return list.get(Mth.m_14100_((int)(this.index + p_168915_), (int)list.size()));
    }

    public boolean m_6050_(double p_168885_, double p_168886_, double p_168887_) {
        if (p_168887_ > 0.0) {
            this.cycleValue(-1);
        } else if (p_168887_ < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T p_168893_) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(p_168893_);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(p_168893_);
    }

    private void updateValue(T p_168906_) {
        Component component = this.createLabelForValue(p_168906_);
        this.m_93666_(component);
        this.value = p_168906_;
    }

    private Component createLabelForValue(T p_168911_) {
        return this.displayOnlyValue ? this.valueStringifier.apply(p_168911_) : this.createFullName(p_168911_);
    }

    private MutableComponent createFullName(T p_168913_) {
        return CommonComponents.m_178393_((Component)this.name, (Component)this.valueStringifier.apply(p_168913_));
    }

    public T getValue() {
        return this.value;
    }

    protected MutableComponent m_5646_() {
        return this.narrationProvider.apply(this);
    }

    public void m_168797_(NarrationElementOutput p_168889_) {
        p_168889_.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            T t = this.getCycledValue(1);
            Component component = this.createLabelForValue(t);
            if (this.m_93696_()) {
                p_168889_.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                p_168889_.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return CosmosCycleButton.m_168799_((Component)(this.displayOnlyValue ? this.createFullName(this.value) : this.m_6035_()));
    }

    public static <T> Builder<T> builder(Function<T, Component> p_168895_) {
        return new Builder<T>(p_168895_);
    }

    public static Builder<Boolean> booleanBuilder(Component p_168897_, Component p_168898_) {
        return new Builder<Boolean>(p_168902_ -> p_168902_ != false ? p_168897_ : p_168898_).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(p_168891_ -> p_168891_ != false ? CommonComponents.f_130653_ : CommonComponents.f_130654_).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean p_168917_) {
        return CosmosCycleButton.onOffBuilder().withInitialValue(p_168917_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(Collection<T> p_232505_) {
            ImmutableList list = ImmutableList.copyOf(p_232505_);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier p_168971_, List<T> p_168972_, List<T> p_168973_) {
            ImmutableList list = ImmutableList.copyOf(p_168972_);
            ImmutableList list1 = ImmutableList.copyOf(p_168973_);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list1;
                final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return p_168971_.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnValueChange<T> {
        public void onValueChange(CosmosCycleButton<T> var1, T var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private CosmosOptionInstance.TooltipSupplier<T> tooltipSupplier = p_168964_ -> ImmutableList.of();
        private Function<CosmosCycleButton<T>, MutableComponent> narrationProvider = CosmosCycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, Component> p_168928_) {
            this.valueStringifier = p_168928_;
        }

        public Builder<T> withValues(Collection<T> p_232503_) {
            return this.withValues(ValueListSupplier.create(p_232503_));
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... p_168962_) {
            return this.withValues((Collection<T>)ImmutableList.copyOf((Object[])p_168962_));
        }

        public Builder<T> withValues(List<T> p_168953_, List<T> p_168954_) {
            return this.withValues(ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, p_168953_, p_168954_));
        }

        public Builder<T> withValues(BooleanSupplier p_168956_, List<T> p_168957_, List<T> p_168958_) {
            return this.withValues(ValueListSupplier.create(p_168956_, p_168957_, p_168958_));
        }

        public Builder<T> withValues(ValueListSupplier<T> p_232501_) {
            this.values = p_232501_;
            return this;
        }

        public Builder<T> withTooltip(CosmosOptionInstance.TooltipSupplier<T> p_232499_) {
            this.tooltipSupplier = p_232499_;
            return this;
        }

        public Builder<T> withInitialValue(T p_168949_) {
            this.initialValue = p_168949_;
            int i = this.values.getDefaultList().indexOf(p_168949_);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<CosmosCycleButton<T>, MutableComponent> p_168960_) {
            this.narrationProvider = p_168960_;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CosmosCycleButton<T> create(int p_168931_, int p_168932_, int p_168933_, int p_168934_, MutableComponent p_168935_, String splitterIn) {
            return this.create(p_168931_, p_168932_, p_168933_, p_168934_, p_168935_, splitterIn, (p_168946_, p_168947_) -> {});
        }

        public CosmosCycleButton<T> create(int p_168937_, int p_168938_, int p_168939_, int p_168940_, MutableComponent captionIn, String splitterIn, OnValueChange<T> p_168942_) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            Component component = this.valueStringifier.apply(t);
            Component component1 = this.displayOnlyValue ? component : captionIn.m_130946_(splitterIn).m_7220_(component);
            return new CosmosCycleButton<T>(p_168937_, p_168938_, p_168939_, p_168940_, component1, (Component)captionIn, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, p_168942_, this.tooltipSupplier, this.displayOnlyValue);
        }
    }
}

