/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen.option;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.tcn.cosmoslibrary.client.ui.screen.option.CosmosCycleButton;
import com.tcn.cosmoslibrary.client.ui.screen.option.CosmosOptions;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractOptionSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.OptionEnum;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CosmosOptionInstance<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Enum<Boolean> BOOLEAN_VALUES = new Enum(ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE), Codec.BOOL);
    private static final int TOOLTIP_WIDTH = 200;
    private final TooltipSupplierFactory<T> tooltip;
    final Function<T, Component> toString;
    public final ValueSet<T> values;
    private final Codec<T> codec;
    private final T initialValue;
    private final T defaultValue;
    private final Consumer<T> onValueUpdate;
    final MutableComponent caption;
    T value;
    private Component message;
    private boolean resetButton;
    private String splitter;

    public static CosmosOptionInstance<Boolean> createScreenSwitchOption(MutableComponent captionIn, Consumer<Boolean> consumerFunctionIn, String splitterIn) {
        return CosmosOptionInstance.createScreenSwitchOption(captionIn, CosmosOptionInstance.noTooltip(), consumerFunctionIn, splitterIn);
    }

    public static CosmosOptionInstance<Boolean> createScreenSwitchOption(MutableComponent captionIn, TooltipSupplierFactory<Boolean> tooltipIn, Consumer<Boolean> consumerFunctionIn, String splitterIn) {
        return new CosmosOptionInstance<Boolean>(captionIn, tooltipIn, (comp, value) -> ComponentHelper.empty(), BOOLEAN_VALUES, false, false, consumerFunctionIn, false, splitterIn);
    }

    public static CosmosOptionInstance<Boolean> createBoolean(MutableComponent captionIn, boolean initialValueIn, Consumer<Boolean> consumerFunctionIn) {
        return CosmosOptionInstance.createBoolean(captionIn, CosmosOptionInstance.noTooltip(), initialValueIn, consumerFunctionIn, ":");
    }

    public static CosmosOptionInstance<Boolean> createBoolean(MutableComponent captionIn, boolean initialValueIn) {
        return CosmosOptionInstance.createBoolean(captionIn, CosmosOptionInstance.noTooltip(), initialValueIn, value -> {}, ":");
    }

    public static CosmosOptionInstance<Boolean> createBoolean(MutableComponent captionIn, TooltipSupplierFactory<Boolean> tooltipIn, boolean initialValueIn) {
        return CosmosOptionInstance.createBoolean(captionIn, tooltipIn, initialValueIn, value -> {}, ":");
    }

    public static CosmosOptionInstance<Boolean> createBoolean(MutableComponent captionIn, TooltipSupplierFactory<Boolean> tooltipIn, boolean initialValueIn, Consumer<Boolean> consumerFunctionIn, String splitterIn) {
        return new CosmosOptionInstance<Boolean>(captionIn, tooltipIn, (comp, value) -> value != false ? CommonComponents.f_130653_ : CommonComponents.f_130654_, BOOLEAN_VALUES, initialValueIn, false, consumerFunctionIn, false, splitterIn);
    }

    public static CosmosOptionInstance<Integer> createIntSlider(MutableComponent captionIn, TooltipSupplierFactory<Integer> tooltipIn, Integer initialValue, Integer minValue, Integer maxValue, Integer normalValue, Consumer<Integer> consumerFunctionIn) {
        return CosmosOptionInstance.createIntSlider(captionIn, tooltipIn, initialValue, minValue, maxValue, normalValue, ComponentColour.WHITE, ComponentHelper.empty(), ComponentHelper.empty(), ComponentHelper.empty(), consumerFunctionIn);
    }

    public static CosmosOptionInstance<Integer> createIntSlider(MutableComponent captionIn, TooltipSupplierFactory<Integer> tooltipIn, Integer initialValue, Integer minValue, Integer maxValue, Integer normalValue, ComponentColour valueColour, MutableComponent minSuffix, MutableComponent normalSuffix, MutableComponent maxSuffix, Consumer<Integer> consumerFunctionIn) {
        return new CosmosOptionInstance<Integer>(captionIn, tooltipIn, (comp, value) -> value == maxValue ? CosmosOptionInstance.genericValueLabel(comp, (Component)maxSuffix) : (value == minValue ? CosmosOptionInstance.genericValueLabel(comp, (Component)minSuffix) : CosmosOptionInstance.genericValueLabel(comp, (Component)ComponentHelper.style(valueColour, value + " ").m_7220_((Component)normalSuffix))), new IntRange(minValue, maxValue).xmap(valueTwo -> valueTwo, valueThree -> valueThree), Codec.intRange((int)minValue, (int)maxValue), initialValue, normalValue, consumerFunctionIn, true, ":");
    }

    public CosmosOptionInstance(MutableComponent captionIn, TooltipSupplierFactory<T> tooltipIn, CaptionBasedToString<T> toStringIn, ValueSet<T> valueSetIn, T initialValueIn, T normalValueIn, Consumer<T> consumerFunctionIn, boolean resetButton, String splitterIn) {
        this(captionIn, tooltipIn, toStringIn, valueSetIn, valueSetIn.codec(), initialValueIn, normalValueIn, consumerFunctionIn, resetButton, splitterIn);
    }

    public CosmosOptionInstance(MutableComponent captionIn, TooltipSupplierFactory<T> tooltipIn, CaptionBasedToString<T> toStringIn, ValueSet<T> valueSetIn, Codec<T> codecIn, T initialValueIn, T defaultValueIn, Consumer<T> consumerFunctionIn, boolean resetButton, String splitter) {
        this.caption = captionIn;
        this.tooltip = tooltipIn;
        this.toString = t -> toStringIn.toString((Component)this.caption, t);
        this.values = valueSetIn;
        this.codec = codecIn;
        this.initialValue = initialValueIn;
        this.defaultValue = defaultValueIn;
        this.onValueUpdate = consumerFunctionIn;
        this.value = this.initialValue;
        this.resetButton = resetButton;
        this.splitter = splitter;
    }

    public static <T> TooltipSupplierFactory<T> noTooltip() {
        return p_231500_ -> p_231553_ -> ImmutableList.of();
    }

    public static <T> TooltipSupplierFactory<T> cachedConstantTooltip(int widthIn, Component tooltipIn) {
        return minecraft -> {
            List<FormattedCharSequence> list = CosmosOptionInstance.splitTooltip(minecraft, tooltipIn, widthIn);
            return tObject -> list;
        };
    }

    public static <T> TooltipSupplierFactory<T> getTooltipSplitComponent(MutableComponent ... tooltipIn) {
        return CosmosOptionInstance.getTooltipSplitComponent(200, tooltipIn);
    }

    public static <T> TooltipSupplierFactory<T> getTooltipSplitComponent(int widthIn, MutableComponent ... tooltipIn) {
        return minecraft -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            for (int i = 0; i < tooltipIn.length; ++i) {
                list.addAll(CosmosOptionInstance.splitTooltip(minecraft, (Component)tooltipIn[i], widthIn));
            }
            return tObject -> list;
        };
    }

    public static <T extends OptionEnum> CaptionBasedToString<T> forOptionEnum() {
        return (p_231538_, p_231539_) -> p_231539_.m_216301_();
    }

    protected static List<FormattedCharSequence> splitTooltip(Minecraft minecraftIn, Component captionIn, int widthIn) {
        return minecraftIn.f_91062_.m_92923_((FormattedText)captionIn, widthIn);
    }

    public AbstractWidget createButton(CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn) {
        TooltipSupplier tooltipsupplier = (TooltipSupplier)this.tooltip.apply(Minecraft.m_91087_());
        return this.values.createButton(tooltipsupplier, optionsIn, xPosIn, yPosIn, this.resetButton ? widthIn - heightIn - heightIn / 2 : widthIn, heightIn, this.getMessage(optionsIn), this.getSplitter()).apply(this);
    }

    public AbstractWidget createResetButton(CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn) {
        TooltipSupplier tooltipsupplier = (TooltipSupplier)this.tooltip.apply(Minecraft.m_91087_());
        return this.values.createResetButton(tooltipsupplier, optionsIn, xPosIn + widthIn - heightIn, yPosIn, heightIn, heightIn, ComponentHelper.style(ComponentColour.TURQUOISE, "R")).apply(this);
    }

    public MutableComponent getMessage(Options options) {
        return this.caption;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public T get() {
        return this.value;
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public String toString() {
        return this.caption.getString();
    }

    public boolean hasResetButton() {
        return this.resetButton;
    }

    public void set(T valueIn) {
        Object t = this.values.validateValue(valueIn).orElseGet(() -> {
            LOGGER.error("Illegal option value " + valueIn + " for " + this.caption);
            return this.initialValue;
        });
        if (!Minecraft.m_91087_().m_91396_()) {
            this.value = t;
        } else if (!Objects.equals(this.value, t)) {
            this.value = t;
            this.onValueUpdate.accept(this.value);
        }
    }

    public ValueSet<T> values() {
        return this.values;
    }

    public static Component genericValueLabel(Component p_231922_, Component p_231923_) {
        return Component.m_237110_((String)"options.generic_value", (Object[])new Object[]{p_231922_, p_231923_});
    }

    public static Component genericValueLabel(Component p_231901_, int p_231902_) {
        return CosmosOptionInstance.genericValueLabel(p_231901_, (Component)Component.m_237113_((String)Integer.toString(p_231902_)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface TooltipSupplierFactory<T>
    extends Function<Minecraft, TooltipSupplier<T>> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CaptionBasedToString<T> {
        public Component toString(Component var1, T var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Enum<T>(List<T> values, Codec<T> codec) implements CycleableValueSet<T>
    {
        @Override
        public Optional<T> validateValue(T p_231632_) {
            return this.values.contains(p_231632_) ? Optional.of(p_231632_) : Optional.empty();
        }

        @Override
        public CosmosCycleButton.ValueListSupplier<T> valueListSupplier() {
            return CosmosCycleButton.ValueListSupplier.create(this.values);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface ValueSet<T> {
        public Function<CosmosOptionInstance<T>, AbstractWidget> createButton(TooltipSupplier<T> var1, CosmosOptions var2, int var3, int var4, int var5, int var6, MutableComponent var7, String var8);

        public Function<CosmosOptionInstance<T>, AbstractWidget> createResetButton(TooltipSupplier<T> var1, CosmosOptions var2, int var3, int var4, int var5, int var6, MutableComponent var7);

        public Optional<T> validateValue(T var1);

        public Codec<T> codec();
    }

    @OnlyIn(value=Dist.CLIENT)
    public record IntRange(int minInclusive, int maxInclusive) implements IntRangeBase
    {
        @Override
        public Optional<Integer> validateValue(Integer p_231645_) {
            return p_231645_.compareTo(this.minInclusive()) >= 0 && p_231645_.compareTo(this.maxInclusive()) <= 0 ? Optional.of(p_231645_) : Optional.empty();
        }

        @Override
        public Codec<Integer> codec() {
            return Codec.intRange((int)this.minInclusive, (int)(this.maxInclusive + 1));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface SliderableValueSet<T>
    extends ValueSet<T> {
        public double toSliderValue(T var1);

        public T fromSliderValue(double var1);

        @Override
        default public Function<CosmosOptionInstance<T>, AbstractWidget> createButton(TooltipSupplier<T> tooltipIn, CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn, MutableComponent messageIn, String splitterIn) {
            return instance -> new OptionInstanceSliderButton(optionsIn, xPosIn, yPosIn, widthIn, heightIn, instance, this, tooltipIn);
        }

        @Override
        default public Function<CosmosOptionInstance<T>, AbstractWidget> createResetButton(TooltipSupplier<T> tooltipIn, CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn, MutableComponent messageIn) {
            return instance -> {
                Button.Builder builder = new Button.Builder((Component)messageIn, button -> {
                    instance.set(instance.defaultValue);
                    optionsIn.m_92169_();
                });
                builder.m_252794_(xPosIn, yPosIn);
                builder.m_253046_(widthIn, heightIn);
                return builder.m_253136_();
            };
        }
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface TooltipSupplier<T>
    extends Function<T, List<FormattedCharSequence>> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum UnitDouble implements SliderableValueSet<Double>
    {
        INSTANCE;


        @Override
        public Optional<Double> validateValue(Double p_231747_) {
            return p_231747_ >= 0.0 && p_231747_ <= 1.0 ? Optional.of(p_231747_) : Optional.empty();
        }

        @Override
        public double toSliderValue(Double p_231756_) {
            return p_231756_;
        }

        @Override
        public Double fromSliderValue(double p_231741_) {
            return p_231741_;
        }

        public <R> SliderableValueSet<R> xmap(final DoubleFunction<? extends R> p_231751_, final ToDoubleFunction<? super R> p_231752_) {
            return new SliderableValueSet<R>(){

                @Override
                public Optional<R> validateValue(R p_231773_) {
                    return this.validateValue(p_231752_.applyAsDouble(p_231773_)).map(p_231751_::apply);
                }

                @Override
                public double toSliderValue(R p_231777_) {
                    return this.toSliderValue(p_231752_.applyAsDouble(p_231777_));
                }

                @Override
                public R fromSliderValue(double p_231775_) {
                    return p_231751_.apply(this.fromSliderValue(p_231775_));
                }

                @Override
                public Codec<R> codec() {
                    return this.codec().xmap(p_231751_::apply, p_231752_::applyAsDouble);
                }
            };
        }

        @Override
        public Codec<Double> codec() {
            return Codec.either((Codec)Codec.doubleRange((double)0.0, (double)1.0), (Codec)Codec.BOOL).xmap(p_231743_ -> (Double)p_231743_.map(p_231760_ -> p_231760_, p_231745_ -> p_231745_ != false ? 1.0 : 0.0), Either::left);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface SliderableOrCyclableValueSet<T>
    extends CycleableValueSet<T>,
    SliderableValueSet<T> {
        public boolean createCosmosCycleButton();

        @Override
        default public Function<CosmosOptionInstance<T>, AbstractWidget> createButton(TooltipSupplier<T> tooltipIn, CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn, MutableComponent messageIn, String splitterIn) {
            return this.createCosmosCycleButton() ? CycleableValueSet.super.createButton(tooltipIn, optionsIn, xPosIn, yPosIn, widthIn, heightIn, messageIn, splitterIn) : SliderableValueSet.super.createButton(tooltipIn, optionsIn, xPosIn, yPosIn, widthIn, heightIn, messageIn, splitterIn);
        }

        @Override
        default public Function<CosmosOptionInstance<T>, AbstractWidget> createResetButton(TooltipSupplier<T> tooltipIn, CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn, MutableComponent messageIn) {
            return this.createCosmosCycleButton() ? CycleableValueSet.super.createResetButton(tooltipIn, optionsIn, xPosIn, yPosIn, widthIn, heightIn, messageIn) : SliderableValueSet.super.createResetButton(tooltipIn, optionsIn, xPosIn, yPosIn, widthIn, heightIn, messageIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class OptionInstanceSliderButton<N>
    extends AbstractOptionSliderButton {
        private final CosmosOptionInstance<N> instance;
        private final SliderableValueSet<N> values;
        private final TooltipSupplier<N> tooltip;

        OptionInstanceSliderButton(CosmosOptions optionsIn, int xPos, int yPos, int widthIn, int heightIn, CosmosOptionInstance<N> instanceIn, SliderableValueSet<N> valueSetIn, TooltipSupplier<N> tooltipIn) {
            super((Options)optionsIn, xPos, yPos, widthIn, heightIn, valueSetIn.toSliderValue(instanceIn.get()));
            this.instance = instanceIn;
            this.values = valueSetIn;
            this.tooltip = tooltipIn;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_(this.instance.toString.apply(this.instance.get()));
        }

        protected void m_5697_() {
            this.instance.set(this.values.fromSliderValue(this.f_93577_));
            this.f_93377_.m_92169_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record LazyEnum<T>(Supplier<List<T>> values, Function<T, Optional<T>> validateValue, Codec<T> codec) implements CycleableValueSet<T>
    {
        @Override
        public Optional<T> validateValue(T p_231689_) {
            return this.validateValue.apply(p_231689_);
        }

        @Override
        public CosmosCycleButton.ValueListSupplier<T> valueListSupplier() {
            return CosmosCycleButton.ValueListSupplier.create((Collection)this.values.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface IntRangeBase
    extends SliderableValueSet<Integer> {
        public int minInclusive();

        public int maxInclusive();

        @Override
        default public double toSliderValue(Integer p_231663_) {
            return Mth.m_184637_((float)p_231663_.intValue(), (float)this.minInclusive(), (float)this.maxInclusive(), (float)0.0f, (float)1.0f);
        }

        @Override
        default public Integer fromSliderValue(double p_231656_) {
            return Mth.m_14107_((double)Mth.m_144914_((double)p_231656_, (double)0.0, (double)1.0, (double)this.minInclusive(), (double)this.maxInclusive()));
        }

        default public <R> SliderableValueSet<R> xmap(final IntFunction<? extends R> p_231658_, final ToIntFunction<? super R> p_231659_) {
            return new SliderableValueSet<R>(){

                @Override
                public Optional<R> validateValue(R p_231674_) {
                    return this.validateValue(p_231659_.applyAsInt(p_231674_)).map(p_231658_::apply);
                }

                @Override
                public double toSliderValue(R p_231678_) {
                    return this.toSliderValue(p_231659_.applyAsInt(p_231678_));
                }

                @Override
                public R fromSliderValue(double p_231676_) {
                    return p_231658_.apply(this.fromSliderValue(p_231676_));
                }

                @Override
                public Codec<R> codec() {
                    return this.codec().xmap(p_231658_::apply, p_231659_::applyAsInt);
                }
            };
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface CycleableValueSet<T>
    extends ValueSet<T> {
        public CosmosCycleButton.ValueListSupplier<T> valueListSupplier();

        default public ValueSetter<T> valueSetter() {
            return CosmosOptionInstance::set;
        }

        @Override
        default public Function<CosmosOptionInstance<T>, AbstractWidget> createButton(TooltipSupplier<T> toolTipIn, CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn, MutableComponent messageIn, String splitterIn) {
            return instance -> CosmosCycleButton.builder(instance.toString).withValues(this.valueListSupplier()).withTooltip(toolTipIn).withInitialValue(instance.value).create(xPosIn, yPosIn, widthIn, heightIn, instance.caption, splitterIn, (button, tObject) -> {
                this.valueSetter().set((CosmosOptionInstance<Object>)instance, tObject);
                optionsIn.m_92169_();
            });
        }

        @Override
        default public Function<CosmosOptionInstance<T>, AbstractWidget> createResetButton(TooltipSupplier<T> toolTipIn, CosmosOptions optionsIn, int xPosIn, int yPosIn, int widthIn, int heightIn, MutableComponent messageIn) {
            return instance -> {
                Button.Builder builder = new Button.Builder((Component)messageIn, button -> {
                    instance.set(instance.defaultValue);
                    optionsIn.m_92169_();
                });
                builder.m_252794_(xPosIn, yPosIn);
                builder.m_253046_(widthIn, heightIn);
                return builder.m_253136_();
            };
        }

        @OnlyIn(value=Dist.CLIENT)
        public static interface ValueSetter<T> {
            public void set(CosmosOptionInstance<T> var1, T var2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ClampingLazyMaxIntRange(int minInclusive, IntSupplier maxSupplier) implements IntRangeBase,
    SliderableOrCyclableValueSet<Integer>
    {
        @Override
        public Optional<Integer> validateValue(Integer p_231590_) {
            return Optional.of(Mth.m_14045_((int)p_231590_, (int)this.minInclusive(), (int)this.maxInclusive()));
        }

        @Override
        public int maxInclusive() {
            return this.maxSupplier.getAsInt();
        }

        @Override
        public Codec<Integer> codec() {
            Function<Integer, DataResult> function = p_231596_ -> {
                int i = this.maxSupplier.getAsInt() + 1;
                return p_231596_.compareTo(this.minInclusive) >= 0 && p_231596_.compareTo(i) <= 0 ? DataResult.success((Object)p_231596_) : DataResult.error(() -> "Value " + p_231596_ + " outside of range [" + this.minInclusive + ":" + i + "]", (Object)p_231596_);
            };
            return Codec.INT.flatXmap(function, function);
        }

        @Override
        public boolean createCosmosCycleButton() {
            return true;
        }

        @Override
        public CosmosCycleButton.ValueListSupplier<Integer> valueListSupplier() {
            return CosmosCycleButton.ValueListSupplier.create(IntStream.range(this.minInclusive, this.maxInclusive() + 1).boxed().toList());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record AltEnum<T>(List<T> values, List<T> altValues, BooleanSupplier altCondition, CycleableValueSet.ValueSetter<T> valueSetter, Codec<T> codec) implements CycleableValueSet<T>
    {
        @Override
        public CosmosCycleButton.ValueListSupplier<T> valueListSupplier() {
            return CosmosCycleButton.ValueListSupplier.create(this.altCondition, this.values, this.altValues);
        }

        @Override
        public Optional<T> validateValue(T p_231570_) {
            return (this.altCondition.getAsBoolean() ? this.altValues : this.values).contains(p_231570_) ? Optional.of(p_231570_) : Optional.empty();
        }
    }
}

