/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen.option;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.tcn.cosmoslibrary.client.ui.screen.option.CosmosOptionInstance;
import com.tcn.cosmoslibrary.client.ui.screen.option.CosmosOptions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CosmosOptionsList
extends ContainerObjectSelectionList<Entry> {
    private int smallWidth;
    private int bigWidth;
    private int buttonHeight;
    public CosmosOptions options;

    public CosmosOptionsList(Minecraft minecraftIn, int widthIn, int heightIn, int yZeroIn, int yOneIn, int itemHeight, int buttonHeightIn, CosmosOptions options) {
        this(minecraftIn, widthIn, heightIn, yZeroIn, yOneIn, itemHeight, buttonHeightIn, 310, options);
    }

    public CosmosOptionsList(Minecraft minecraftIn, int widthIn, int heightIn, int yZeroIn, int yOneIn, int itemHeight, int buttonHeightIn, int bigWidthIn, CosmosOptions options) {
        super(minecraftIn, widthIn, heightIn, yZeroIn, yOneIn, itemHeight);
        this.f_93394_ = false;
        this.options = options;
        this.smallWidth = (bigWidthIn - 10) / 2;
        this.bigWidth = bigWidthIn;
        this.buttonHeight = buttonHeightIn;
    }

    public int addBig(CosmosOptionInstance<?> optionIn) {
        return this.m_7085_((AbstractSelectionList.Entry)Entry.big(this.options, this.f_93388_, optionIn, this.bigWidth, this.buttonHeight));
    }

    public void addSmall(CosmosOptionInstance<?> optionIn, @Nullable CosmosOptionInstance<?> secondOptionIn) {
        this.m_7085_((AbstractSelectionList.Entry)Entry.small(this.options, this.f_93388_, optionIn, secondOptionIn, this.smallWidth, this.bigWidth, this.buttonHeight));
    }

    public void addSmall(CosmosOptionInstance<?>[] optionsIn) {
        for (int i = 0; i < optionsIn.length; i += 2) {
            this.addSmall(optionsIn[i], i < optionsIn.length - 1 ? optionsIn[i + 1] : null);
        }
    }

    public int m_5759_() {
        return 400;
    }

    protected int m_5756_() {
        return super.m_5756_() + 32;
    }

    @Nullable
    public AbstractWidget findOption(CosmosOptionInstance<?> optionIn) {
        for (Entry optionslist$entry : this.m_6702_()) {
            AbstractWidget abstractwidget = optionslist$entry.options.get(optionIn);
            if (abstractwidget == null) continue;
            return abstractwidget;
        }
        return null;
    }

    public Optional<AbstractWidget> getMouseOver(double mouseX, double mouseY) {
        for (Entry optionslist$entry : this.m_6702_()) {
            for (AbstractWidget abstractwidget : optionslist$entry.children) {
                if (!abstractwidget.m_5953_(mouseX, mouseY)) continue;
                return Optional.of(abstractwidget);
            }
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        final Map<CosmosOptionInstance<?>, AbstractWidget> options;
        final List<AbstractWidget> children;

        private Entry(Map<CosmosOptionInstance<?>, AbstractWidget> optionMap) {
            this.options = optionMap;
            this.children = ImmutableList.copyOf(optionMap.values());
        }

        private Entry(Map<CosmosOptionInstance<?>, AbstractWidget> optionMap, AbstractWidget addedChild) {
            this.options = optionMap;
            this.children = Lists.newCopyOnWriteArrayList(optionMap.values());
            this.children.add(addedChild);
        }

        public static Entry big(CosmosOptions optionsIn, int screenWidthIn, CosmosOptionInstance<?> optionIn, int widthIn, int heightIn) {
            AbstractWidget abstractWidget = optionIn.createButton(optionsIn, screenWidthIn / 2 - widthIn / 2, 0, widthIn, heightIn);
            return !optionIn.hasResetButton() ? new Entry((Map<CosmosOptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionIn, (Object)abstractWidget)) : new Entry((Map<CosmosOptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionIn, (Object)abstractWidget), optionIn.createResetButton(optionsIn, screenWidthIn / 2 - widthIn / 2, 45, widthIn, heightIn));
        }

        public static Entry small(CosmosOptions optionsIn, int screenWidthIn, CosmosOptionInstance<?> optionOneIn, @Nullable CosmosOptionInstance<?> optionTwoIn, int widthIn, int bigWidthIn, int heightIn) {
            AbstractWidget abstractwidget = optionOneIn.createButton(optionsIn, screenWidthIn / 2 - bigWidthIn / 2, 0, widthIn, heightIn);
            return optionTwoIn == null ? new Entry((Map<CosmosOptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionOneIn, (Object)abstractwidget)) : new Entry((Map<CosmosOptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionOneIn, (Object)abstractwidget, optionTwoIn, (Object)optionTwoIn.createButton(optionsIn, screenWidthIn / 2 - bigWidthIn / 2 + (widthIn + 10), 0, widthIn, heightIn)));
        }

        public void m_6311_(GuiGraphics graphics, int xPosIn, int yPosIn, int p_94499_, int p_94500_, int p_94501_, int mouseX, int mouseY, boolean p_94504_, float partialTicks) {
            this.children.forEach(widget -> this.renderWidget((AbstractWidget)widget, graphics, xPosIn, yPosIn, mouseX, mouseY, partialTicks));
        }

        public void renderWidget(AbstractWidget widgetIn, GuiGraphics graphics, int xPosIn, int yPosIn, int mouseX, int mouseY, float partialTicks) {
            if (!(widgetIn instanceof EditBox)) {
                widgetIn.m_253211_(yPosIn);
                widgetIn.m_88315_(graphics, mouseX, mouseY, partialTicks);
            } else if (widgetIn instanceof EditBox) {
                widgetIn.m_253211_(yPosIn + 2);
                widgetIn.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }
}

