/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen.widget;

import com.tcn.cosmoslibrary.CosmosReference;
import com.tcn.cosmoslibrary.client.ui.lib.CosmosUISystem;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CosmosButtonUIHelp
extends Button {
    private int[] index = new int[]{0, 12, 24, 36};
    private final ResourceLocation TEXTURE = CosmosReference.RESOURCE.BASE.BUTTON_UI;
    private EnumUIHelp mode;
    protected int width;
    protected int height;
    public int x;
    public int y;
    protected boolean isHovered;
    public boolean active = true;
    public boolean visible = true;

    public CosmosButtonUIHelp(EnumUIHelp modeIn, int x, int y, boolean enabled, boolean visible, Component title, Button.OnPress pressedAction) {
        this(modeIn, x, y, 12, 17, enabled, visible, title, pressedAction, new Button.CreateNarration(){

            public MutableComponent m_253229_(Supplier<MutableComponent> p_253695_) {
                return ComponentHelper.empty();
            }
        });
    }

    public CosmosButtonUIHelp(EnumUIHelp modeIn, int x, int y, int width, int height, boolean enabled, boolean visible, Component title, Button.OnPress pressedAction, Button.CreateNarration narration) {
        super(x, y, width, height, title, pressedAction, narration);
        this.mode = modeIn;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.active = enabled;
        this.visible = visible;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.m_87963_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (!this.active) {
            return false;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    public void m_5691_() {
        if (this.active) {
            this.f_93717_.m_93750_((Button)this);
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.mode != null) {
            CosmosUISystem.setTextureWithColourAlpha(graphics.m_280168_(), this.TEXTURE, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int i = this.getHoverState(this.isHovered);
            if (this.mode.equals((Object)EnumUIHelp.HIDDEN)) {
                graphics.m_280218_(this.TEXTURE, this.x, this.y, this.index[i], 20, this.width, this.height);
            } else {
                graphics.m_280218_(this.TEXTURE, this.x, this.y, this.index[i + 2], 20, this.width, this.height);
            }
        }
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 0;
        if (!this.active) {
            i = 2;
        } else if (mouseOver) {
            i = 1;
        }
        return i;
    }
}

