/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tcn.cosmoslibrary.CosmosReference;
import com.tcn.cosmoslibrary.client.ui.lib.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonBase;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CosmosButtonWithType
extends CosmosButtonBase {
    private TYPE buttonType;
    protected int width;
    protected int height;
    public int x;
    public int y;
    protected boolean isHovered;
    public boolean active = true;
    public boolean visible = true;
    private int identifier;

    public CosmosButtonWithType(TYPE typeIn, int x, int y, int size, boolean enabled, boolean visible, int identifier, Component title, CosmosButtonBase.OnClick clickedAction) {
        super(x, y, size, size, enabled, visible, title, clickedAction, new Button.CreateNarration(){

            public MutableComponent m_253229_(Supplier<MutableComponent> p_253695_) {
                return ComponentHelper.empty();
            }
        });
        this.buttonType = typeIn;
        this.x = x;
        this.y = y;
        this.width = size;
        this.height = size;
        this.identifier = identifier;
    }

    public CosmosButtonWithType(TYPE typeIn, int x, int y, boolean enabled, boolean visible, int identifier, Component title, CosmosButtonBase.OnClick clickedAction) {
        this(typeIn, x, y, 20, enabled, visible, identifier, title, clickedAction);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.m_87963_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return this.active ? super.m_5953_(mouseX, mouseY) : false;
    }

    @Override
    public void m_5691_() {
        if (!this.visible || this.active) {
            // empty if block
        }
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonType != null) {
            CosmosUISystem.setTextureWithColourAlpha(graphics.m_280168_(), this.buttonType.getButtonTexture(false), new float[]{1.0f, 1.0f, 1.0f, 1.0f});
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int i = this.getHoverState(this.isHovered);
            if (this.identifier >= 0 && this.identifier <= 23) {
                if (this.identifier >= 0 && this.identifier <= 5) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i], this.width, this.height);
                    }
                } else if (this.identifier > 5 && this.identifier <= 11) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 6], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i + 3], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 6], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i + 3], this.width, this.height);
                    }
                } else if (this.identifier > 11 && this.identifier <= 17) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 12], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i + 6], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 12], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i + 6], this.width, this.height);
                    }
                } else if (this.identifier > 17 && this.identifier <= 23) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 18], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i + 9], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(false), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 18], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i + 9], this.width, this.height);
                    }
                }
            } else if (this.identifier > 23 && this.identifier <= 47) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.buttonType.getButtonTexture(true));
                if (this.identifier > 23 && this.identifier <= 29) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 24], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 24], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i], this.width, this.height);
                    }
                } else if (this.identifier > 29 && this.identifier <= 35) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 30], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i + 3], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 30], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i + 3], this.width, this.height);
                    }
                } else if (this.identifier > 35 && this.identifier <= 41) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 36], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i + 6], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 36], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i + 6], this.width, this.height);
                    }
                } else if (this.identifier > 41 && this.identifier <= 47) {
                    if (this.width == 20 && this.height == 20) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[this.identifier - 42], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i + 9], this.width, this.height);
                    } else if (this.width == 18 && this.height == 18) {
                        graphics.m_280218_(this.buttonType.getButtonTexture(true), this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[this.identifier - 42], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i + 9], this.width, this.height);
                    }
                }
            }
        }
    }

    @Override
    protected int getHoverState(boolean mouseOver) {
        int i = 0;
        if (!this.active) {
            i = 2;
        } else if (mouseOver) {
            i = 1;
        }
        return i;
    }

    public static enum TYPE {
        ICON(0, "icon", CosmosReference.RESOURCE.BASE.BUTTON_ICON_PATH, CosmosReference.RESOURCE.BASE.BUTTON_ICON_PATH_ALT),
        GENERAL(1, "general", CosmosReference.RESOURCE.BASE.BUTTON_GENERAL_PATH, CosmosReference.RESOURCE.BASE.BUTTON_GENERAL_PATH_ALT),
        ENERGY(0, "energy", CosmosReference.RESOURCE.BASE.BUTTON_ENERGY_PATH, CosmosReference.RESOURCE.BASE.BUTTON_ENERGY_PATH_ALT),
        FLUID(0, "fluid", CosmosReference.RESOURCE.BASE.BUTTON_FLUID_PATH, CosmosReference.RESOURCE.BASE.BUTTON_FLUID_PATH_ALT),
        ITEM(0, "item", CosmosReference.RESOURCE.BASE.BUTTON_ITEM_PATH, CosmosReference.RESOURCE.BASE.BUTTON_ITEM_PATH_ALT),
        STORAGE(0, "storage", CosmosReference.RESOURCE.BASE.BUTTON_STORAGE_PATH, CosmosReference.RESOURCE.BASE.BUTTON_STORAGE_PATH_ALT);

        private int index;
        private String name;
        private final ResourceLocation textureNormal;
        private final ResourceLocation textureAlt;

        private TYPE(int index, String name, ResourceLocation textureNormalIn, ResourceLocation textureAltIn) {
            this.index = index;
            this.name = name;
            this.textureNormal = textureNormalIn;
            this.textureAlt = textureAltIn;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getButtonTexture(boolean alt) {
            if (!alt) {
                return this.textureNormal;
            }
            return this.textureAlt;
        }
    }
}

