/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.client.ui.screen.widget;

import com.tcn.cosmoslibrary.CosmosReference;
import com.tcn.cosmoslibrary.client.ui.lib.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonBase;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CosmosColourButton
extends CosmosButtonBase {
    private ComponentColour colour = ComponentColour.EMPTY;
    protected int width;
    protected int height;
    public int x;
    public int y;
    protected boolean isHovered;

    public CosmosColourButton(ComponentColour startingColourIn, int x, int y, int sizeX, int sizeY, boolean enabled, boolean visible, Component title, CosmosButtonBase.OnClick clickedAction) {
        super(x, y, sizeX, sizeY, enabled, visible, title, clickedAction, new Button.CreateNarration(){

            public MutableComponent m_253229_(Supplier<MutableComponent> p_253695_) {
                return ComponentHelper.empty();
            }
        });
        this.colour = startingColourIn;
        this.x = x;
        this.y = y;
        this.width = sizeX;
        this.height = sizeY;
        this.active = enabled;
        this.visible = visible;
    }

    public CosmosColourButton(ComponentColour startingColourIn, int x, int y, int size, boolean enabled, boolean visible, Component title, CosmosButtonBase.OnClick clickedAction) {
        this(startingColourIn, x, y, size, size, enabled, visible, title, clickedAction);
    }

    public CosmosColourButton(ComponentColour startingColourIn, int x, int y, boolean enabled, boolean visible, Component title, CosmosButtonBase.OnClick clickedAction) {
        this(startingColourIn, x, y, 20, enabled, visible, title, clickedAction);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.m_87963_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        if (!this.active) {
            return false;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    @Override
    public void m_5691_() {
        if (this.visible && this.active) {
            this.f_93717_.m_93750_((Button)this);
        }
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        CosmosUISystem.setTextureWithColourAlpha(graphics.m_280168_(), CosmosReference.RESOURCE.BASE.BUTTON_COLOUR, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        int i = this.getHoverState(this.isHovered);
        if (this.width == 20 && this.height == 20) {
            graphics.m_280218_(CosmosReference.RESOURCE.BASE.BUTTON_COLOUR, this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[0], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i], this.width, this.height);
        } else if (this.width == 18 && this.height == 18) {
            graphics.m_280218_(CosmosReference.RESOURCE.BASE.BUTTON_COLOUR, this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[0], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i], this.width, this.height);
        }
        if (!this.colour.equals((Object)ComponentColour.EMPTY)) {
            CosmosUISystem.setTextureColour(this.colour);
            if (this.width == 20 && this.height == 20) {
                graphics.m_280218_(CosmosReference.RESOURCE.BASE.BUTTON_COLOUR, this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X[1], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y[i], this.width, this.height);
            } else if (this.width == 18 && this.height == 18) {
                graphics.m_280218_(CosmosReference.RESOURCE.BASE.BUTTON_COLOUR, this.x, this.y, CosmosReference.RESOURCE.INFO.BUTTON_STATE_X_SMALL[1], CosmosReference.RESOURCE.INFO.BUTTON_STATE_Y_SMALL[i], this.width, this.height);
            }
        }
        CosmosUISystem.setTextureColour(ComponentColour.WHITE);
    }

    @Override
    protected int getHoverState(boolean mouseOver) {
        int i = 0;
        if (!this.active) {
            i = 2;
        } else if (mouseOver) {
            i = 1;
        }
        return i;
    }

    public ComponentColour getColour() {
        return this.colour;
    }
}

