/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CosmosBlockDoor
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final BlockSetType type;

    public CosmosBlockDoor(BlockBehaviour.Properties propertiesIn, BlockSetType typeIn) {
        super(propertiesIn);
        this.type = typeIn;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockSetType type() {
        return this.type;
    }

    public VoxelShape m_5940_(BlockState stateIn, BlockGetter levelIn, BlockPos posIn, CollisionContext contextIn) {
        Direction direction = (Direction)stateIn.m_61143_((Property)FACING);
        boolean flag = (Boolean)stateIn.m_61143_((Property)OPEN) == false;
        boolean flag1 = stateIn.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockState m_7417_(BlockState stateIn, Direction directionIn, BlockState newStateIn, LevelAccessor levelIn, BlockPos posIn, BlockPos secPosIn) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (directionIn.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (directionIn == Direction.UP)) {
            return newStateIn.m_60713_((Block)this) && newStateIn.m_61143_(HALF) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)newStateIn.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)newStateIn.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)newStateIn.m_61143_(HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)newStateIn.m_61143_((Property)POWERED))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && directionIn == Direction.DOWN && !stateIn.m_60710_((LevelReader)levelIn, posIn) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, directionIn, newStateIn, levelIn, posIn, secPosIn);
    }

    public void m_5707_(Level levelIn, BlockPos posIn, BlockState stateIn, Player playerIn) {
        if (levelIn.f_46443_ || playerIn.m_7500_()) {
            // empty if block
        }
        super.m_5707_(levelIn, posIn, stateIn, playerIn);
    }

    public boolean m_7357_(BlockState stateIn, BlockGetter levelIn, BlockPos posIn, PathComputationType pathCompIn) {
        switch (pathCompIn) {
            case LAND: {
                return (Boolean)stateIn.m_61143_((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)stateIn.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext contextIn) {
        BlockPos blockpos = contextIn.m_8083_();
        Level level = contextIn.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(contextIn)) {
            boolean flag = level.m_276867_(blockpos) || level.m_276867_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)contextIn.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(contextIn))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level levelIn, BlockPos posIn, BlockState stateIn, LivingEntity entityIn, ItemStack stackIn) {
        levelIn.m_7731_(posIn.m_7494_(), (BlockState)stateIn.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext contextIn) {
        boolean flag1;
        Level blockgetter = contextIn.m_43725_();
        BlockPos blockpos = contextIn.m_8083_();
        Direction direction = contextIn.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = blockgetter.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_121945_(direction1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_121945_(direction2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.m_60713_((Block)this) && blockstate2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = contextIn.m_43720_();
                double d0 = vec3.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState stateIn, Level levelIn, BlockPos posIn, Player playerIn, InteractionHand handIn, BlockHitResult resultIn) {
        if (!this.type.f_278463_()) {
            return InteractionResult.PASS;
        }
        stateIn = (BlockState)stateIn.m_61122_((Property)OPEN);
        levelIn.m_7731_(posIn, stateIn, 10);
        this.playSound((Entity)playerIn, levelIn, posIn, (Boolean)stateIn.m_61143_((Property)OPEN));
        levelIn.m_142346_((Entity)playerIn, this.isOpen(stateIn) ? GameEvent.f_157796_ : GameEvent.f_157793_, posIn);
        return InteractionResult.m_19078_((boolean)levelIn.f_46443_);
    }

    public boolean isOpen(BlockState stateIn) {
        return (Boolean)stateIn.m_61143_((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entityIn, Level levelIn, BlockState stateIn, BlockPos posIn, boolean valueIn) {
        if (stateIn.m_60713_((Block)this) && (Boolean)stateIn.m_61143_((Property)OPEN) != valueIn) {
            levelIn.m_7731_(posIn, (BlockState)stateIn.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(valueIn)), 10);
            this.playSound(entityIn, levelIn, posIn, valueIn);
            levelIn.m_142346_(entityIn, valueIn ? GameEvent.f_157796_ : GameEvent.f_157793_, posIn);
        }
    }

    public void m_6861_(BlockState stateIn, Level levelIn, BlockPos posIn, Block blockIn, BlockPos otherPosIn, boolean valueIn) {
        boolean flag;
        boolean bl = levelIn.m_276867_(posIn) || levelIn.m_276867_(posIn.m_121945_(stateIn.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (!this.m_49966_().m_60713_(blockIn) && flag != (Boolean)stateIn.m_61143_((Property)POWERED)) {
            if (flag != (Boolean)stateIn.m_61143_((Property)OPEN)) {
                this.playSound(null, levelIn, posIn, flag);
                levelIn.m_142346_((Entity)null, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, posIn);
            }
            levelIn.m_7731_(posIn, (BlockState)((BlockState)stateIn.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean m_7898_(BlockState stateIn, LevelReader levelIn, BlockPos posIn) {
        BlockPos blockpos = posIn.m_7495_();
        BlockState blockstate = levelIn.m_8055_(blockpos);
        return stateIn.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)levelIn, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    private void playSound(@Nullable Entity entityIn, Level levelIn, BlockPos posIn, boolean open) {
        levelIn.m_245803_(entityIn, posIn, open ? this.type.f_271141_() : this.type.f_271502_(), SoundSource.BLOCKS, 1.0f, levelIn.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public PushReaction getPistonPushReaction(BlockState stateIn) {
        return PushReaction.IGNORE;
    }

    public BlockState m_6843_(BlockState stateIn, Rotation rotationIn) {
        return (BlockState)stateIn.m_61124_((Property)FACING, (Comparable)rotationIn.m_55954_((Direction)stateIn.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState stateIn, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? stateIn : (BlockState)stateIn.m_60717_(mirrorIn.m_54846_((Direction)stateIn.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public long m_7799_(BlockState stateIn, BlockPos posIn) {
        return Mth.m_14130_((int)posIn.m_123341_(), (int)posIn.m_6625_(stateIn.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)posIn.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilderIn) {
        stateBuilderIn.m_61104_(new Property[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public static boolean isWoodenDoor(Level p_52746_, BlockPos p_52747_) {
        return CosmosBlockDoor.isWoodenDoor(p_52746_.m_8055_(p_52747_));
    }

    public static boolean isWoodenDoor(BlockState p_52818_) {
        DoorBlock doorblock;
        Block block = p_52818_.m_60734_();
        return block instanceof DoorBlock && (doorblock = (DoorBlock)block).m_278711_().f_278463_();
    }
}

