/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.enums;

import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import net.minecraft.network.chat.MutableComponent;

public enum EnumChannelSideState {
    AIR(0, "air", "cosmoslibrary.channel_state.air.name", ComponentColour.RED),
    CABLE_NO_CONN(1, "no_conn", "cosmoslibrary.channel_state.no_conn.name", ComponentColour.LIGHT_GRAY),
    CABLE(2, "cable", "cosmoslibrary.channel_state.cable.name", ComponentColour.LIGHT_GRAY),
    CABLE_OTHER(3, "cable", "cosmoslibrary.channel_state.cable_other.name", ComponentColour.LIGHT_GRAY),
    INTERFACE_NO_CONN(4, "interface_no_conn", "cosmoslibrary.channel_state.interface_no_conn.name", ComponentColour.WHITE),
    INTERFACE_INPUT(5, "interface_input", "cosmoslibrary.channel_state.interface_input.name", ComponentColour.BLUE),
    INTERFACE_OUTPUT(6, "interface_output", "cosmoslibrary.channel_state.interface_output.name", ComponentColour.GREEN),
    DISABLED(7, "disabled", "cosmoslibrary.channel_state.disabled.name", ComponentColour.GRAY);

    public final int index;
    public final String basic_name;
    public final String localizedName;
    public final ComponentColour colour;

    private EnumChannelSideState(int indexIn, String basic_nameIn, String localizedNameIn, ComponentColour colourIn) {
        this.index = indexIn;
        this.basic_name = basic_nameIn;
        this.localizedName = localizedNameIn;
        this.colour = colourIn;
    }

    public String getName() {
        return this.basic_name;
    }

    public MutableComponent getColouredComp() {
        return ComponentHelper.style(this.colour, "bold", this.localizedName);
    }

    public String getlocalizedName() {
        return this.localizedName;
    }

    public String toString() {
        return this.basic_name;
    }

    public int getIndex() {
        return this.index;
    }

    public static EnumChannelSideState[] getStandardArray() {
        return new EnumChannelSideState[]{AIR, AIR, AIR, AIR, AIR, AIR};
    }

    public EnumChannelSideState getNextState() {
        switch (this) {
            case AIR: {
                return CABLE_NO_CONN;
            }
            case CABLE_NO_CONN: {
                return CABLE;
            }
            case CABLE: {
                return CABLE_OTHER;
            }
            case CABLE_OTHER: {
                return INTERFACE_NO_CONN;
            }
            case INTERFACE_NO_CONN: {
                return INTERFACE_INPUT;
            }
            case INTERFACE_INPUT: {
                return INTERFACE_OUTPUT;
            }
            case INTERFACE_OUTPUT: {
                return DISABLED;
            }
            case DISABLED: {
                return AIR;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + this + "]");
    }

    public EnumChannelSideState getNextStateUser() {
        switch (this) {
            case AIR: {
                return INTERFACE_INPUT;
            }
            case INTERFACE_NO_CONN: {
                return INTERFACE_INPUT;
            }
            case INTERFACE_INPUT: {
                return INTERFACE_OUTPUT;
            }
            case INTERFACE_OUTPUT: {
                return DISABLED;
            }
            case DISABLED: {
                return AIR;
            }
        }
        return AIR;
    }

    public static EnumChannelSideState getStateFromIndex(int index_in) {
        switch (index_in) {
            case 0: {
                return AIR;
            }
            case 1: {
                return CABLE_NO_CONN;
            }
            case 2: {
                return CABLE;
            }
            case 3: {
                return CABLE_OTHER;
            }
            case 4: {
                return INTERFACE_NO_CONN;
            }
            case 5: {
                return INTERFACE_INPUT;
            }
            case 6: {
                return INTERFACE_OUTPUT;
            }
            case 7: {
                return DISABLED;
            }
        }
        throw new IllegalStateException("No Enum exists with that index: [ " + index_in + " ]");
    }

    public boolean isInterface() {
        return this.equals((Object)INTERFACE_NO_CONN) || this.equals((Object)INTERFACE_INPUT) || this.equals((Object)INTERFACE_OUTPUT);
    }
}

