/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.enums;

import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import net.minecraft.network.chat.MutableComponent;

public enum EnumConnectionType {
    SCREEN(0, "screen", "cosmoslibrary.enum.connection_type.screen", ComponentColour.CYAN),
    ENERGY(1, "energy", "cosmoslibrary.enum.connection_type.energy", ComponentColour.RED),
    FLUID(2, "fluid", "cosmoslibrary.enum.connection_type.fluid", ComponentColour.TURQUOISE),
    ITEM(3, "item", "cosmoslibrary.enum.connection_type.item", ComponentColour.YELLOW);

    private final int index;
    private final String name;
    private final String localized_name;
    private final ComponentColour colour;
    public static final EnumConnectionType[] VALUES;

    private EnumConnectionType(int indexIn, String nameIn, String localizedNameIn, ComponentColour colourIn) {
        this.index = indexIn;
        this.name = nameIn;
        this.localized_name = localizedNameIn;
        this.colour = colourIn;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.name();
    }

    public String getName() {
        return this.name;
    }

    public MutableComponent getColouredComp() {
        return ComponentHelper.style(this.colour, "bold", this.localized_name);
    }

    public String getUnlocalizedName() {
        return this.localized_name;
    }

    public ComponentColour getColour() {
        return this.colour;
    }

    public static EnumConnectionType getStandardValue() {
        return SCREEN;
    }

    public EnumConnectionType getNextState() {
        switch (this) {
            case SCREEN: {
                return ENERGY;
            }
            case ENERGY: {
                return FLUID;
            }
            case FLUID: {
                return ITEM;
            }
            case ITEM: {
                return SCREEN;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + this + "]");
    }

    public static EnumConnectionType getNextStateFromState(EnumConnectionType previous) {
        switch (previous) {
            case SCREEN: {
                return ENERGY;
            }
            case ENERGY: {
                return FLUID;
            }
            case FLUID: {
                return ITEM;
            }
            case ITEM: {
                return SCREEN;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + previous + "]");
    }

    public static EnumConnectionType getStateFromIndex(int index) {
        switch (index) {
            case 0: {
                return SCREEN;
            }
            case 1: {
                return ENERGY;
            }
            case 2: {
                return FLUID;
            }
            case 3: {
                return ITEM;
            }
        }
        throw new IllegalStateException("No EnumConnectionType exists with index: [" + index + "]");
    }

    public static EnumConnectionType getStateFromName(String name) {
        switch (name) {
            case "screen": {
                return SCREEN;
            }
            case "energy": {
                return ENERGY;
            }
            case "fluid": {
                return FLUID;
            }
            case "item": {
                return ITEM;
            }
        }
        throw new IllegalStateException("No EnumConnectionType exists with name: [" + name + "]");
    }

    static {
        VALUES = new EnumConnectionType[4];
    }
}

