/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.enums;

import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import net.minecraft.network.chat.MutableComponent;

public enum EnumSideState {
    INTERFACE_NORMAL(0, "interface_normal", "cosmoslibrary.enum.side_state.interface_normal", ComponentColour.LIGHT_GRAY),
    INTERFACE_OUTPUT(1, "interface_output", "cosmoslibrary.enum.side_state.interface_output", ComponentColour.GREEN),
    INTERFACE_INPUT(2, "interface_input", "cosmoslibrary.enum.side_state.interface_input", ComponentColour.LIGHT_BLUE),
    DISABLED(3, "disabled", "cosmoslibrary.enum.side_state.disabled", ComponentColour.GRAY);

    private final int index;
    private final String name;
    private final String localized_name;
    private final ComponentColour colour;
    public static EnumSideState[] VALUES;
    private static EnumSideState[] INTERNAL;
    public static EnumSideState[] STANDARD;

    private EnumSideState(int indexIn, String nameIn, String localizedNameIn, ComponentColour colourIn) {
        this.index = indexIn;
        this.name = nameIn;
        this.localized_name = localizedNameIn;
        this.colour = colourIn;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public MutableComponent getColouredComp() {
        return ComponentHelper.style(this.colour, "bold", this.localized_name);
    }

    public String getUnlocalizedName() {
        return this.localized_name;
    }

    public ComponentColour getTextColour() {
        return this.colour;
    }

    public static EnumSideState[] getStandardArray() {
        return new EnumSideState[]{INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL};
    }

    public EnumSideState getNextState() {
        switch (this) {
            case INTERFACE_NORMAL: {
                return INTERFACE_OUTPUT;
            }
            case INTERFACE_OUTPUT: {
                return INTERFACE_INPUT;
            }
            case INTERFACE_INPUT: {
                return DISABLED;
            }
            case DISABLED: {
                return INTERFACE_NORMAL;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + this + "]");
    }

    public static EnumSideState getNextStateFromState(EnumSideState previous) {
        switch (previous) {
            case INTERFACE_NORMAL: {
                return INTERFACE_OUTPUT;
            }
            case INTERFACE_OUTPUT: {
                return INTERFACE_INPUT;
            }
            case INTERFACE_INPUT: {
                return DISABLED;
            }
            case DISABLED: {
                return INTERFACE_NORMAL;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + previous + "]");
    }

    public static EnumSideState getStateFromIndex(int index) {
        switch (index) {
            case 0: {
                return INTERFACE_NORMAL;
            }
            case 1: {
                return INTERFACE_OUTPUT;
            }
            case 2: {
                return INTERFACE_INPUT;
            }
            case 3: {
                return DISABLED;
            }
        }
        throw new IllegalStateException("No EnumSideState exists with index: [" + index + "]");
    }

    static {
        VALUES = new EnumSideState[4];
        INTERNAL = new EnumSideState[]{INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL, INTERFACE_NORMAL};
        STANDARD = (EnumSideState[])INTERNAL.clone();
    }
}

