/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.enums;

import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import net.minecraft.network.chat.MutableComponent;

public enum EnumUIMode {
    DARK(0, "dark", "cosmoslibrary.enum.ui_mode.dark", false, ComponentColour.LIGHT_GRAY),
    LIGHT(1, "light", "cosmoslibrary.enum.ui_mode.light", true, ComponentColour.YELLOW);

    private int index;
    private String name;
    private String localized_name;
    private boolean value;
    private ComponentColour colour;

    private EnumUIMode(int indexIn, String nameIn, String localizedNameIn, boolean valueIn, ComponentColour colourIn) {
        this.index = indexIn;
        this.name = nameIn;
        this.localized_name = localizedNameIn;
        this.value = valueIn;
        this.colour = colourIn;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return this.localized_name;
    }

    public MutableComponent getColouredComp() {
        return ComponentHelper.style(this.colour, "bold", this.localized_name);
    }

    public boolean getValue() {
        return this.value;
    }

    public ComponentColour getColour() {
        return this.colour;
    }

    public static EnumUIMode getOpposite(EnumUIMode state) {
        if (state.equals((Object)DARK)) {
            return LIGHT;
        }
        return DARK;
    }

    public static EnumUIMode getStateFromIndex(int index) {
        switch (index) {
            case 0: {
                return DARK;
            }
            case 1: {
                return LIGHT;
            }
        }
        return DARK;
    }

    public static EnumUIMode getStateFromValue(boolean value) {
        if (value) {
            return LIGHT;
        }
        return DARK;
    }

    public EnumUIMode getNextState() {
        switch (this) {
            case DARK: {
                return LIGHT;
            }
            case LIGHT: {
                return DARK;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + this + "]");
    }

    public static EnumUIMode getNextStateFromState(EnumUIMode previous) {
        switch (previous) {
            case DARK: {
                return LIGHT;
            }
            case LIGHT: {
                return DARK;
            }
        }
        throw new IllegalStateException("Unable to obtain next state of [" + previous + "]");
    }
}

