/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.lib;

import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.network.chat.MutableComponent;

public enum ComponentColour {
    WHITE(0, "White", 0xFFFFFF, "\u00a7f", 255, 255, 255, false),
    ORANGE(1, "Orange", 0xFFAA00, "\u00a76", 255, 170, 0, false),
    MAGENTA(2, "Magenta", 0xFF55FF, "\u00a7d", 255, 85, 255, false),
    LIGHT_BLUE(3, "Light Blue", 0x5555FF, "\u00a79", 85, 85, 255, false),
    YELLOW(4, "Yellow", 0xFFFF55, "\u00a7e", 255, 255, 85, false),
    LIME(5, "Lime", 0x55FF55, "\u00a7a", 85, 255, 85, false),
    PINK(6, "Pink", 15961002, "", 243, 139, 170, false),
    GRAY(7, "Gray", 0x555555, "\u00a78", 85, 85, 85, true),
    LIGHT_GRAY(8, "Light Gray", 0xAAAAAA, "\u00a77", 170, 170, 170, false),
    CYAN(9, "Cyan", 43690, "\u00a73", 0, 170, 170, false),
    PURPLE(10, "Purple", 0xAA00AA, "\u00a75", 170, 0, 170, true),
    BLUE(11, "Blue", 170, "\u00a71", 0, 0, 170, true),
    BROWN(12, "Brown", 8606770, "", 131, 84, 50, true),
    GREEN(13, "Green", 43520, "\u00a72", 0, 170, 0, false),
    RED(14, "Red", 0xAA0000, "\u00a74", 170, 0, 0, true),
    BLACK(15, "Black", 0x181818, "\u00a70", 24, 24, 24, true),
    POCKET_PURPLE(16, "Pocket Purple", 4134239, "\u00a75", 35, 12, 53, true),
    POCKET_PURPLE_LIGHT(17, "Pocket Purple Light", 6627993, "\u00a75", 101, 34, 154, true),
    POCKET_PURPLE_GUI(18, "Pocket Purple GUI", 10748079, "\u00a75", 164, 0, 175, false),
    LIGHT_RED(19, "Light Red", 0xFF5555, "\u00a7c", 255, 85, 85, false),
    SCREEN_DARK(20, "Gui Background", 0x404040, "\u00a78", 85, 85, 85, true),
    SCREEN_LIGHT(21, "Gui Font List", 0xFFFFFF, "\u00a77", 170, 170, 170, false),
    DARK_GREEN(22, "Dark Green", 25600, "\u00a72", 0, 100, 0, true),
    DARK_RED(23, "Dark Red", 0x640000, "\u00a74", 100, 0, 0, true),
    DARK_YELLOW(24, "Dark Yellow", 0x7F7F00, "\u00a7e", 127, 127, 0, true),
    TURQUOISE(25, "Turquoise", 50115, "\u00a73", 0, 225, 225, false),
    DARK_CYAN(26, "Dark Cyan", 26214, "\u00a73", 0, 102, 102, true),
    BLURPLE(27, "Blurple", 7506394, "\u00a73", 114, 137, 218, true),
    BLURPLE_LIGHT(28, "Blurple Light", 3692707, "\u00a73", 56, 88, 163, false),
    EMPTY(29, "Default", 0, "\u00a77", 0, 0, 0, true);

    private final int index;
    private final String name;
    private final int decimal;
    private final String chat_colour;
    private final int[] RGB;
    private final float[] RGBF;
    private final boolean dark;
    private static final ComponentColour[] VALUES;

    private ComponentColour(int indexIn, String nameIn, int decimalIn, String chatColourIn, int rIn, int gIn, int bIn, boolean isDarkIn) {
        this.index = indexIn;
        this.name = nameIn;
        this.decimal = decimalIn;
        this.chat_colour = chatColourIn;
        this.RGB = new int[]{rIn, gIn, bIn};
        this.RGBF = new float[]{(float)rIn / 255.0f, (float)gIn / 255.0f, (float)bIn / 255.0f};
        this.dark = isDarkIn;
    }

    public String toString() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int dec() {
        return this.decimal;
    }

    public String getChatColour() {
        if (this.chat_colour != null) {
            return this.chat_colour;
        }
        return "";
    }

    public MutableComponent getColouredName() {
        return ComponentHelper.style(this == EMPTY ? LIGHT_GRAY : this, "bold", this.name);
    }

    public static ComponentColour fromIndex(int colorId) {
        if (colorId < 0 || colorId >= VALUES.length) {
            colorId = 0;
        }
        return VALUES[colorId];
    }

    public int[] getRGB() {
        return this.RGB;
    }

    public float[] getFloatRGB() {
        return this.RGBF;
    }

    public boolean isDark() {
        return this.dark;
    }

    public static ComponentColour col(int decimal) {
        for (ComponentColour colour : ComponentColour.values()) {
            if (colour.dec() != decimal) continue;
            return colour;
        }
        return WHITE;
    }

    public static int[] rgbIntArray(ComponentColour colour) {
        return ComponentColour.rgbIntArray(colour.decimal);
    }

    public static int[] rgbIntArray(int decimal) {
        for (ComponentColour colour : ComponentColour.values()) {
            if (colour.dec() != decimal) continue;
            return colour.getRGB();
        }
        return new int[]{255, 255, 255};
    }

    public static float[] rgbFloatArray(ComponentColour colour) {
        return ComponentColour.rgbFloatArray(colour.decimal);
    }

    public static float[] rgbFloatArray(int decimal) {
        for (ComponentColour colour : ComponentColour.values()) {
            if (colour.dec() != decimal) continue;
            int[] RGB_ = colour.getRGB();
            return new float[]{(float)RGB_[0] / 255.0f, (float)RGB_[1] / 255.0f, (float)RGB_[2] / 255.0f};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static int decFromCol(ComponentColour colour) {
        return colour.decimal;
    }

    public static ComponentColour getCompColourForScreen(ComponentColour colour) {
        return !colour.isDark() ? SCREEN_DARK : SCREEN_LIGHT;
    }

    public ComponentColour getNextVanillaColour(boolean includeNoColour) {
        switch (this) {
            case EMPTY: {
                return WHITE;
            }
            case WHITE: {
                return ORANGE;
            }
            case ORANGE: {
                return MAGENTA;
            }
            case MAGENTA: {
                return LIGHT_BLUE;
            }
            case LIGHT_BLUE: {
                return YELLOW;
            }
            case YELLOW: {
                return LIME;
            }
            case LIME: {
                return PINK;
            }
            case PINK: {
                return GRAY;
            }
            case GRAY: {
                return LIGHT_GRAY;
            }
            case LIGHT_GRAY: {
                return CYAN;
            }
            case CYAN: {
                return PURPLE;
            }
            case PURPLE: {
                return BLUE;
            }
            case BLUE: {
                return BROWN;
            }
            case BROWN: {
                return GREEN;
            }
            case GREEN: {
                return RED;
            }
            case RED: {
                return BLACK;
            }
            case BLACK: {
                return includeNoColour ? EMPTY : WHITE;
            }
        }
        return WHITE;
    }

    public ComponentColour getNextVanillaColourReverse(boolean includeNoColour) {
        switch (this) {
            case EMPTY: {
                return BLACK;
            }
            case BLACK: {
                return RED;
            }
            case RED: {
                return GREEN;
            }
            case GREEN: {
                return BROWN;
            }
            case BROWN: {
                return BLUE;
            }
            case BLUE: {
                return PURPLE;
            }
            case PURPLE: {
                return CYAN;
            }
            case CYAN: {
                return LIGHT_GRAY;
            }
            case LIGHT_GRAY: {
                return GRAY;
            }
            case GRAY: {
                return PINK;
            }
            case PINK: {
                return LIME;
            }
            case LIME: {
                return YELLOW;
            }
            case YELLOW: {
                return LIGHT_BLUE;
            }
            case LIGHT_BLUE: {
                return MAGENTA;
            }
            case MAGENTA: {
                return ORANGE;
            }
            case ORANGE: {
                return WHITE;
            }
            case WHITE: {
                return includeNoColour ? EMPTY : BLACK;
            }
        }
        return BLACK;
    }

    public static ComponentColour getNextVanillaColour(boolean includeNoColour, ComponentColour colourIn) {
        switch (colourIn) {
            case EMPTY: {
                return WHITE;
            }
            case WHITE: {
                return ORANGE;
            }
            case ORANGE: {
                return MAGENTA;
            }
            case MAGENTA: {
                return LIGHT_BLUE;
            }
            case LIGHT_BLUE: {
                return YELLOW;
            }
            case YELLOW: {
                return LIME;
            }
            case LIME: {
                return PINK;
            }
            case PINK: {
                return GRAY;
            }
            case GRAY: {
                return LIGHT_GRAY;
            }
            case LIGHT_GRAY: {
                return CYAN;
            }
            case CYAN: {
                return PURPLE;
            }
            case PURPLE: {
                return BLUE;
            }
            case BLUE: {
                return BROWN;
            }
            case BROWN: {
                return GREEN;
            }
            case GREEN: {
                return RED;
            }
            case RED: {
                return BLACK;
            }
            case BLACK: {
                return includeNoColour ? EMPTY : WHITE;
            }
        }
        return WHITE;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    static {
        VALUES = (ComponentColour[])Arrays.stream(ComponentColour.values()).sorted(Comparator.comparingInt(ComponentColour::getIndex)).toArray(ComponentColour[]::new);
    }
}

