/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.lib;

import com.mojang.blaze3d.platform.InputConstants;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public final class ComponentHelper {
    public static boolean displayShiftForDetail = true;
    public static boolean displayCtrlForDetail = true;
    public static boolean displayAltForDetail = true;

    public static boolean isAltKeyDown(Minecraft mc) {
        return InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)342) || InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)346);
    }

    public static boolean isControlKeyDown(Minecraft mc) {
        return InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)341) || InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)345);
    }

    public static boolean isShiftKeyDown(Minecraft mc) {
        return InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)344);
    }

    public static int getSplitStringHeight(Font fontRenderer, FormattedText input, int width) {
        List stringRows = fontRenderer.m_92923_(input, width);
        int n = stringRows.size();
        Objects.requireNonNull(fontRenderer);
        return n * 9;
    }

    public static String camelCase(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String locString(String key) {
        return I18n.m_118938_((String)key, (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String locString(String colour, String key) {
        return colour + I18n.m_118938_((String)key, (Object[])new Object[0]) + "\u00a7r";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String locString(String pre, String key, String suff) {
        return pre + I18n.m_118938_((String)key, (Object[])new Object[0]) + suff + "\u00a7r";
    }

    public static MutableComponent empty() {
        return Component.m_237115_((String)"");
    }

    public static MutableComponent title(String key) {
        return Component.m_237115_((String)key);
    }

    public static MutableComponent comp(String key) {
        return Component.m_237115_((String)key);
    }

    public static MutableComponent style(int colourIn, String flags, String keyIn) {
        MutableComponent comp = Component.m_237115_((String)keyIn);
        comp.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(flags.contains("bold"))).m_131162_(Boolean.valueOf(flags.contains("underline"))).m_131155_(Boolean.valueOf(flags.contains("italic"))).m_178522_(Boolean.valueOf(flags.contains("strikethrough"))).m_178524_(Boolean.valueOf(flags.contains("obfuscated"))).m_131148_(TextColor.m_131266_((int)colourIn)));
        return comp;
    }

    public static MutableComponent style(int colourIn, String keyIn) {
        return ComponentHelper.style(colourIn, "", keyIn);
    }

    public static MutableComponent style(ComponentColour colourIn, String keyIn) {
        return ComponentHelper.style(colourIn.dec(), "", keyIn);
    }

    public static MutableComponent style(ComponentColour colourIn, String flags, String keyIn) {
        return ComponentHelper.style(colourIn.dec(), flags, keyIn);
    }

    public static MutableComponent style3(int colourIn, String flags, String keyInA, String keyInB, String keyInC) {
        return ComponentHelper.style(colourIn, flags, keyInA).m_7220_((Component)ComponentHelper.style(colourIn, flags, keyInB)).m_7220_((Component)ComponentHelper.style(colourIn, flags, keyInC));
    }

    public static MutableComponent style3(int colourIn, String keyInA, String keyInB, String keyInC) {
        return ComponentHelper.style(colourIn, "", keyInA).m_7220_((Component)ComponentHelper.style(colourIn, "", keyInB)).m_7220_((Component)ComponentHelper.style(colourIn, "", keyInC));
    }

    public static MutableComponent style3(ComponentColour colourIn, String keyInA, String keyInB, String keyInC) {
        return ComponentHelper.style(colourIn, "", keyInA).m_7220_((Component)ComponentHelper.style(colourIn, "", keyInB)).m_7220_((Component)ComponentHelper.style(colourIn, "", keyInC));
    }

    public static MutableComponent style3(ComponentColour colourIn, String flags, String keyInA, String keyInB, String keyInC) {
        return ComponentHelper.style(colourIn, flags, keyInA).m_7220_((Component)ComponentHelper.style(colourIn, flags, keyInB)).m_7220_((Component)ComponentHelper.style(colourIn, flags, keyInC));
    }

    public static MutableComponent style2(ComponentColour colourIn, String flags, String keyInA, String keyInB) {
        return ComponentHelper.style(colourIn, flags, keyInA).m_7220_((Component)ComponentHelper.style(colourIn, flags, keyInB));
    }

    public static MutableComponent style2(ComponentColour colourIn, String ... keys) {
        return ComponentHelper.style(colourIn, "", keys[0]).m_7220_((Component)ComponentHelper.style(colourIn, "", keys[1]));
    }

    public static String getFluidName(FluidStack fluid) {
        return ComponentHelper.getFluidName(fluid.getFluid());
    }

    public static String getFluidName(Fluid fluid) {
        Object fluidName = "";
        fluidName = fluid.getFluidType().getTemperature() > 1000 ? (String)fluidName + "\u00a74" : (String)fluidName + "\u00a71";
        fluidName = (String)fluidName + ComponentHelper.locString(fluid.getFluidType().getDescription().toString()) + "\u00a7r";
        return fluidName;
    }

    public static String getScaledNumber(int number) {
        return ComponentHelper.getScaledNumber(number, 2);
    }

    public static String getScaledNumber(int number, int minDigits) {
        Object numString = "";
        int numMod = 10 * minDigits;
        numString = number > 100000 * numMod ? (String)numString + number / 1000000 + "M" : (number > 100 * numMod ? (String)numString + number / 1000 + "k" : (String)numString + number);
        return numString;
    }

    public static MutableComponent shiftForMoreDetails() {
        return ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.hold.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.ORANGE, "bold", "cosmoslibrary.info.shift.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.fordetails.name")));
    }

    public static MutableComponent shiftForLessDetails() {
        return ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.release.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.ORANGE, "bold", "cosmoslibrary.info.shift.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.less.name")));
    }

    public static MutableComponent ctrlForMoreDetails() {
        return ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.hold.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.LIGHT_GRAY, "bold", "cosmoslibrary.info.ctrl.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.nbt.name")));
    }

    public static MutableComponent ctrlForLessDetails() {
        return ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.release.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.LIGHT_GRAY, "bold", "cosmoslibrary.info.ctrl.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.nbt.less.name")));
    }

    public static MutableComponent altForMoreDetails(ComponentColour colourIn) {
        return ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.hold.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(colourIn, "bold", "cosmoslibrary.info.alt.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.energy.name")));
    }

    public static MutableComponent altForLessDetails(ComponentColour colourIn) {
        return ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.release.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(colourIn, "bold", "cosmoslibrary.info.alt.name").m_7220_((Component)ComponentHelper.style(ComponentColour.BLACK, " ")).m_7220_((Component)ComponentHelper.style(ComponentColour.WHITE, "cosmoslibrary.info.energy.less.name")));
    }

    public static MutableComponent getTooltipInfo(String key) {
        return ComponentHelper.style(ComponentColour.LIGHT_GRAY, key);
    }

    public static MutableComponent getTooltipOne(String key) {
        return ComponentHelper.style(ComponentColour.CYAN, key);
    }

    public static MutableComponent getTooltipTwo(String key) {
        return ComponentHelper.style(ComponentColour.GREEN, key);
    }

    public static MutableComponent getTooltipThree(String key) {
        return ComponentHelper.style(ComponentColour.LIGHT_BLUE, key);
    }

    public static MutableComponent getTooltipFour(String key) {
        return ComponentHelper.style(ComponentColour.LIME, key);
    }

    public static MutableComponent getTooltipLimit(String key) {
        return ComponentHelper.style(ComponentColour.LIGHT_RED, key);
    }

    public static MutableComponent getErrorText(String key) {
        return ComponentHelper.style(ComponentColour.RED, key);
    }

    public final class Value {
        public static final String BLACK = "\u00a70";
        public static final String BLUE = "\u00a71";
        public static final String GREEN = "\u00a72";
        public static final String CYAN = "\u00a73";
        public static final String RED = "\u00a74";
        public static final String PURPLE = "\u00a75";
        public static final String ORANGE = "\u00a76";
        public static final String LIGHT_GRAY = "\u00a77";
        public static final String GRAY = "\u00a78";
        public static final String LIGHT_BLUE = "\u00a79";
        public static final String BRIGHT_GREEN = "\u00a7a";
        public static final String BRIGHT_BLUE = "\u00a7b";
        public static final String LIGHT_RED = "\u00a7c";
        public static final String MAGENTA = "\u00a7d";
        public static final String YELLOW = "\u00a7e";
        public static final String WHITE = "\u00a7f";
        public static final String OBFUSCATED = "\u00a7k";
        public static final String BOLD = "\u00a7l";
        public static final String STRIKETHROUGH = "\u00a7m";
        public static final String UNDERLINE = "\u00a7n";
        public static final String ITALIC = "\u00a7o";
        public static final String END = "\u00a7r";
    }
}

