/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.lib;

import com.google.common.collect.AbstractIterator;
import com.tcn.cosmoslibrary.common.lib.CosmosVec2;
import java.util.Random;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;

@Immutable
public class CosmosChunkPos
extends CosmosVec2 {
    public static final CosmosChunkPos ZERO = new CosmosChunkPos(0, 0);

    public CosmosChunkPos(int x, int y) {
        super(x, y);
    }

    public CosmosChunkPos(double x, double y) {
        super(x, y);
    }

    public CosmosChunkPos(long longIn) {
        super((int)longIn, (int)(longIn >> 32));
    }

    public static CosmosChunkPos convertTo(BlockPos posIn) {
        if (posIn != null) {
            return new CosmosChunkPos(posIn.m_123341_(), posIn.m_123343_());
        }
        return ZERO;
    }

    public static BlockPos convertFrom(CosmosChunkPos posIn) {
        if (posIn != null) {
            return new BlockPos(posIn.getX(), 0, posIn.getZ());
        }
        return BlockPos.f_121853_;
    }

    public static CosmosChunkPos scaleToChunkPos(BlockPos posIn) {
        if (posIn != null) {
            return new CosmosChunkPos(posIn.m_123341_() >> 4, posIn.m_123343_() >> 4);
        }
        return ZERO;
    }

    public static BlockPos scaleFromChunkPos(CosmosChunkPos posIn) {
        if (posIn != null) {
            return new BlockPos(posIn.getX() * 16, 0, posIn.getZ() * 16);
        }
        return BlockPos.f_121853_;
    }

    public CosmosChunkPos(Position position) {
        this(position.m_7096_(), position.m_7094_());
    }

    public CosmosChunkPos(CosmosVec2 source) {
        this(source.getX(), source.getZ());
    }

    public long toLong() {
        return CosmosChunkPos.asLong(this.x, this.z);
    }

    public static long asLong(int p_45590_, int p_45591_) {
        return (long)p_45590_ & 0xFFFFFFFFL | ((long)p_45591_ & 0xFFFFFFFFL) << 32;
    }

    public static long asLong(BlockPos p_151389_) {
        return CosmosChunkPos.asLong(SectionPos.m_123171_((int)p_151389_.m_123341_()), SectionPos.m_123171_((int)p_151389_.m_123343_()));
    }

    public static long atSectionBottomY(long packedPos) {
        return packedPos & 0xFFFFFFFFFFFFFFF0L;
    }

    public CosmosChunkPos add(double x, double z) {
        return x == 0.0 && z == 0.0 ? this : new CosmosChunkPos((double)this.getX() + x, (double)this.getZ() + z);
    }

    public CosmosChunkPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new CosmosChunkPos(this.getX() + x, this.getZ() + z);
    }

    public CosmosChunkPos add(CosmosVec2 vec) {
        return this.add(vec.getX(), vec.getZ());
    }

    public CosmosChunkPos subtract(CosmosVec2 vec) {
        return this.add(-vec.getX(), -vec.getZ());
    }

    @Override
    public CosmosChunkPos up() {
        return this.offset(Direction.UP);
    }

    @Override
    public CosmosChunkPos up(int n) {
        return this.offset(Direction.UP, n);
    }

    @Override
    public CosmosChunkPos down() {
        return this.offset(Direction.DOWN);
    }

    @Override
    public CosmosChunkPos down(int n) {
        return this.offset(Direction.DOWN, n);
    }

    public CosmosChunkPos north() {
        return this.offset(Direction.NORTH);
    }

    public CosmosChunkPos north(int n) {
        return this.offset(Direction.NORTH, n);
    }

    public CosmosChunkPos south() {
        return this.offset(Direction.SOUTH);
    }

    public CosmosChunkPos south(int n) {
        return this.offset(Direction.SOUTH, n);
    }

    public CosmosChunkPos west() {
        return this.offset(Direction.WEST);
    }

    public CosmosChunkPos west(int n) {
        return this.offset(Direction.WEST, n);
    }

    public CosmosChunkPos east() {
        return this.offset(Direction.EAST);
    }

    public CosmosChunkPos east(int n) {
        return this.offset(Direction.EAST, n);
    }

    public CosmosChunkPos offset(Direction facing) {
        return new CosmosChunkPos(this.getX() + facing.m_122429_(), this.getZ() + facing.m_122431_());
    }

    @Override
    public CosmosChunkPos offset(Direction facing, int n) {
        return n == 0 ? this : new CosmosChunkPos(this.getX() + facing.m_122429_() * n, this.getZ() + facing.m_122431_() * n);
    }

    public CosmosChunkPos rotate(Rotation rotationIn) {
        switch (rotationIn) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new CosmosChunkPos(-this.getZ(), this.getX());
            }
            case CLOCKWISE_180: {
                return new CosmosChunkPos(-this.getX(), -this.getZ());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new CosmosChunkPos(this.getZ(), -this.getX());
    }

    public CosmosChunkPos toImmutable() {
        return this;
    }

    public Mutable toMutable() {
        return new Mutable(this.getX(), this.getZ());
    }

    public static Iterable<CosmosChunkPos> getRandomPositions(final Random rand, final int amount, final int minX, final int minZ, int maxX, int maxZ) {
        final int i = maxX - minX + 1;
        final int k = maxZ - minZ + 1;
        return () -> new AbstractIterator<CosmosChunkPos>(){
            final Mutable pos = new Mutable();
            int remainingAmount = amount;

            protected CosmosChunkPos computeNext() {
                if (this.remainingAmount <= 0) {
                    return (CosmosChunkPos)this.endOfData();
                }
                Mutable blockpos = this.pos.setPos(minX + rand.nextInt(i), minZ + rand.nextInt(k));
                --this.remainingAmount;
                return blockpos;
            }
        };
    }

    public void saveRaw(CompoundTag tag) {
        tag.m_128405_("x", this.getX());
        tag.m_128405_("z", this.getZ());
    }

    public static CosmosChunkPos loadRaw(CompoundTag tag) {
        int x = tag.m_128451_("x");
        int z = tag.m_128451_("z");
        return new CosmosChunkPos(x, z);
    }

    public void save(CompoundTag tag) {
        CompoundTag info = new CompoundTag();
        info.m_128405_("x", this.getX());
        info.m_128405_("z", this.getZ());
        tag.m_128365_("chunk_pos", (Tag)info);
    }

    public static CosmosChunkPos load(CompoundTag tag) {
        if (tag.m_128441_("chunk_pos")) {
            CompoundTag loaded = tag.m_128469_("chunk_pos");
            int x = loaded.m_128451_("x");
            int z = loaded.m_128451_("z");
            return new CosmosChunkPos(x, z);
        }
        return null;
    }

    public CosmosChunkPos copy() {
        return new CosmosChunkPos(this.getX(), this.getZ());
    }

    public static class Mutable
    extends CosmosChunkPos {
        public Mutable() {
            this(0, 0);
        }

        public Mutable(int x_, int z_) {
            super(x_, z_);
        }

        public Mutable(double x, double z) {
            this(Mth.m_14107_((double)x), Mth.m_14107_((double)z));
        }

        @Override
        public CosmosChunkPos add(double x, double z) {
            return super.add(x, z).toImmutable();
        }

        public CosmosChunkPos add(int x, int z) {
            return super.add(x, z).toImmutable();
        }

        @Override
        public CosmosChunkPos offset(Direction facing, int n) {
            return super.offset(facing, n).toImmutable();
        }

        @Override
        public CosmosChunkPos rotate(Rotation rotationIn) {
            return super.rotate(rotationIn).toImmutable();
        }

        public Mutable setPos(int xIn, int zIn) {
            this.setX(xIn);
            this.setZ(zIn);
            return this;
        }

        public Mutable setPos(double xIn, double zIn) {
            return this.setPos(Mth.m_14107_((double)xIn), Mth.m_14107_((double)zIn));
        }

        public Mutable setPos(CosmosVec2 vec) {
            return this.setPos(vec.getX(), vec.getZ());
        }

        public Mutable setAndMove(CosmosVec2 pos, Direction direction) {
            return this.setPos(pos.getX() + direction.m_122429_(), pos.getZ() + direction.m_122431_());
        }

        public Mutable setAndOffset(CosmosVec2 pos, int offsetX, int offsetY, int offsetZ) {
            return this.setPos(pos.getX() + offsetX, pos.getZ() + offsetZ);
        }

        public Mutable move(Direction facing) {
            return this.move(facing, 1);
        }

        public Mutable move(Direction facing, int n) {
            return this.setPos(this.getX() + facing.m_122429_() * n, this.getZ() + facing.m_122431_() * n);
        }

        public Mutable move(int xIn, int yIn, int zIn) {
            return this.setPos(this.getX() + xIn, this.getZ() + zIn);
        }

        public Mutable func_243531_h(CosmosVec2 p_243531_1_) {
            return this.setPos(this.getX() + p_243531_1_.getX(), this.getZ() + p_243531_1_.getZ());
        }

        public Mutable clampAxisCoordinate(Direction.Axis axis, int min, int max) {
            switch (axis) {
                case X: {
                    return this.setPos(Mth.m_14045_((int)this.getX(), (int)min, (int)max), this.getZ());
                }
                case Z: {
                    return this.setPos(this.getX(), Mth.m_14045_((int)this.getZ(), (int)min, (int)max));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + axis);
        }

        @Override
        public void setX(int xIn) {
            super.setX(xIn);
        }

        @Override
        public void setZ(int zIn) {
            super.setZ(zIn);
        }

        @Override
        public CosmosChunkPos toImmutable() {
            return new CosmosChunkPos(this);
        }
    }
}

