/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.lib;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Immutable
public class CosmosVec2
implements Comparable<CosmosVec2> {
    public static final Codec<CosmosVec2> CODEC = Codec.INT_STREAM.comapFlatMap(stream -> Util.m_137539_((IntStream)stream, (int)3).map(componentArraz -> new CosmosVec2(componentArraz[0], componentArraz[1])), vector -> IntStream.of(vector.getX(), vector.getZ()));
    public static final CosmosVec2 NULL_VECTOR = new CosmosVec2(0, 0);
    protected int x;
    protected int z;

    public CosmosVec2(int xIn, int zIn) {
        this.x = xIn;
        this.z = zIn;
    }

    public CosmosVec2(double xIn, double zIn) {
        this(Mth.m_14107_((double)xIn), Mth.m_14107_((double)zIn));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof CosmosVec2)) {
            return false;
        }
        CosmosVec2 vector3i = (CosmosVec2)p_equals_1_;
        if (this.getX() != vector3i.getX()) {
            return false;
        }
        if (this.getZ() != vector3i.getZ()) {
            return false;
        }
        if (this.getX() == vector3i.getX()) {
            return true;
        }
        return this.getZ() == vector3i.getZ();
    }

    public int hashCode() {
        return this.getZ() * 31 * 31 + this.getX();
    }

    @Override
    public int compareTo(CosmosVec2 p_compareTo_1_) {
        if (this.getZ() == p_compareTo_1_.getZ()) {
            return this.getZ() == p_compareTo_1_.getZ() ? this.getX() - p_compareTo_1_.getX() : this.getZ() - p_compareTo_1_.getZ();
        }
        return this.getZ() - p_compareTo_1_.getZ();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    protected void setX(int xIn) {
        this.x = xIn;
    }

    protected void setZ(int zIn) {
        this.z = zIn;
    }

    public CosmosVec2 up() {
        return this.up(1);
    }

    public CosmosVec2 up(int n) {
        return this.offset(Direction.UP, n);
    }

    public CosmosVec2 down() {
        return this.down(1);
    }

    public CosmosVec2 down(int n) {
        return this.offset(Direction.DOWN, n);
    }

    public CosmosVec2 offset(Direction facing, int n) {
        return n == 0 ? this : new CosmosVec2(this.getX() + facing.m_122429_() * n, this.getZ() + facing.m_122431_() * n);
    }

    public CosmosVec2 crossProduct(CosmosVec2 vec) {
        return null;
    }

    public boolean withinDistance(CosmosVec2 vector, double distance) {
        return this.distanceSq(vector.getX(), vector.getZ(), false) < distance * distance;
    }

    public boolean withinDistance(Position position, double distance) {
        return this.distanceSq(position.m_7096_(), position.m_7094_(), true) < distance * distance;
    }

    public double distanceSq(CosmosVec2 to) {
        return this.distanceSq(to.getX(), to.getZ(), true);
    }

    public double distanceSq(Position position, boolean useCenter) {
        return this.distanceSq(position.m_7096_(), position.m_7094_(), useCenter);
    }

    public double distanceSq(double x, double z, boolean useCenter) {
        double d0 = useCenter ? 0.5 : 0.0;
        double d1 = (double)this.getX() + d0 - x;
        double d2 = (double)this.getZ() + d0 - z;
        return d1 * d1 + d2 * d2;
    }

    public int manhattanDistance(CosmosVec2 vector) {
        float f = Math.abs(vector.getX() - this.getX());
        float f1 = Math.abs(vector.getZ() - this.getZ());
        return (int)(f + f1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.getX()).add("z", this.getZ()).toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getCoordinatesAsString() {
        return this.getX() + ", " + this.getZ();
    }
}

