/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.nbt;

import com.tcn.cosmoslibrary.common.enums.EnumSideState;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CosmosBlockItemNBT
extends BlockItem {
    public String info;
    public String shift_desc_one;
    public String shift_desc_two;
    public String shift_desc_three;
    public String limitation;

    public CosmosBlockItemNBT(Block block, Item.Properties builder, String info, String shift_desc_one) {
        super(block, builder);
        this.info = info;
        this.shift_desc_one = shift_desc_one;
    }

    public CosmosBlockItemNBT(Block block, Item.Properties builder, String info, String shift_desc_one, String shift_desc_two) {
        super(block, builder);
        this.info = info;
        this.shift_desc_one = shift_desc_one;
        this.shift_desc_two = shift_desc_two;
    }

    public CosmosBlockItemNBT(Block block, Item.Properties builder, String info, String shift_desc_one, String shift_desc_two, String limitation) {
        super(block, builder);
        this.info = info;
        this.shift_desc_one = shift_desc_one;
        this.shift_desc_two = shift_desc_two;
        this.limitation = limitation;
    }

    public CosmosBlockItemNBT(Block block, Item.Properties builder, String info, String shift_desc_one, String shift_desc_two, String shift_desc_three, String limitation) {
        super(block, builder);
        this.info = info;
        this.shift_desc_one = shift_desc_one;
        this.shift_desc_two = shift_desc_two;
        this.shift_desc_three = shift_desc_three;
        this.limitation = limitation;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!ComponentHelper.isShiftKeyDown(Minecraft.m_91087_())) {
            tooltip.add((Component)ComponentHelper.getTooltipInfo(this.info));
            if (ComponentHelper.displayShiftForDetail) {
                tooltip.add((Component)ComponentHelper.shiftForMoreDetails());
            }
        } else {
            tooltip.add((Component)ComponentHelper.getTooltipOne(this.shift_desc_one));
            if (this.shift_desc_two != null) {
                tooltip.add((Component)ComponentHelper.getTooltipTwo(this.shift_desc_two));
            }
            if (this.shift_desc_three != null) {
                tooltip.add((Component)ComponentHelper.getTooltipThree(this.shift_desc_three));
            }
            if (this.limitation != null) {
                tooltip.add((Component)ComponentHelper.getTooltipLimit(this.limitation));
            }
            tooltip.add((Component)ComponentHelper.shiftForLessDetails());
        }
        if (stack.m_41782_()) {
            if (!ComponentHelper.isControlKeyDown(Minecraft.m_91087_())) {
                tooltip.add((Component)ComponentHelper.ctrlForMoreDetails());
            } else if (stack.m_41782_()) {
                CompoundTag tag = stack.m_41783_();
                if (tag.m_128441_("nbt_data")) {
                    CompoundTag compound_tag = tag.m_128469_("nbt_data");
                    int energy = compound_tag.m_128451_("energy");
                    tooltip.add((Component)Component.m_237113_((String)("\u00a78Energy Stored: \u00a77[" + energy + "] \u00a75RF")));
                    if (compound_tag.m_128441_("Items")) {
                        int size = compound_tag.m_128451_("size");
                        NonNullList list_ = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
                        ContainerHelper.m_18980_((CompoundTag)tag.m_128469_("nbt_data"), (NonNullList)list_);
                        tooltip.add((Component)Component.m_237113_((String)"\u00a78   > [ Items: { Items } ]: "));
                        if (list_.size() > 6) {
                            for (j = 0; j < 6; ++j) {
                                if (list_.get(j) == null || ((ItemStack)list_.get(j)).m_41720_() == Item.m_41439_((Block)Blocks.f_50016_)) continue;
                                tooltip.add((Component)Component.m_237113_((String)("\u00a78     - ( Slot " + j + ": " + ((ItemStack)list_.get(j)).m_41613_() + "x " + I18n.m_118938_((String)((ItemStack)list_.get(j)).m_41720_().m_7626_((ItemStack)list_.get(j)).toString(), (Object[])new Object[0]) + " )")));
                            }
                            tooltip.add((Component)Component.m_237113_((String)("\u00a78     - ( & " + (list_.size() - 5) + " stack(s) more... )")));
                        } else {
                            for (j = 0; j < list_.size(); ++j) {
                                if (list_.get(j) == null || ((ItemStack)list_.get(j)).m_41720_() == Item.m_41439_((Block)Blocks.f_50016_)) continue;
                                tooltip.add((Component)Component.m_237113_((String)("\u00a78     - ( Slot " + j + ": " + ((ItemStack)list_.get(j)).m_41613_() + "x " + I18n.m_118938_((String)((ItemStack)list_.get(j)).m_41720_().m_7626_((ItemStack)list_.get(j)).toString(), (Object[])new Object[0]) + " )")));
                            }
                        }
                    }
                    if (compound_tag.m_128441_("sides")) {
                        CompoundTag compound_tag_sides = compound_tag.m_128469_("sides");
                        String[] strings = new String[]{"", "", "", "", "", ""};
                        int[] text_colours = new int[]{0, 0, 0, 0, 0, 0};
                        for (Direction c : Direction.values()) {
                            int index = compound_tag_sides.m_128451_("index_" + c.m_122411_());
                            strings[c.m_122411_()] = EnumSideState.getStateFromIndex(index).getName();
                            text_colours[c.m_122411_()] = EnumSideState.getStateFromIndex(index).getTextColour().dec();
                        }
                        tooltip.add((Component)Component.m_237113_((String)"\u00a79   > \u00a77[ \u00a73ISidedTile \u00a78(sides)\u00a77 ]"));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a74     - \u00a77[U] \u00a78= " + text_colours[1] + strings[1])));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a74     - \u00a77[D] \u00a78= " + text_colours[0] + strings[0])));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a74     - \u00a77[N] \u00a78= " + text_colours[2] + strings[2])));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a74     - \u00a77[S] \u00a78= " + text_colours[3] + strings[3])));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a74     - \u00a77[E] \u00a78= " + text_colours[5] + strings[5])));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a74     - \u00a77[W] \u00a78= " + text_colours[4] + strings[4])));
                    }
                }
                tooltip.add((Component)ComponentHelper.ctrlForLessDetails());
            }
        }
    }
}

