/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.nbt;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;

public class CosmosNBTIOHandler {
    public static void write(CompoundTag p_128956_, File p_128957_) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(p_128957_);
             DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);){
            CosmosNBTIOHandler.write(p_128956_, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundTag read(File p_128954_) throws IOException {
        CompoundTag compoundtag;
        if (!p_128954_.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(p_128954_);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            compoundtag = CosmosNBTIOHandler.read(datainputstream, NbtAccounter.f_128917_);
        }
        return compoundtag;
    }

    public static CompoundTag read(DataInput p_128929_) throws IOException {
        return CosmosNBTIOHandler.read(p_128929_, NbtAccounter.f_128917_);
    }

    public static CompoundTag read(DataInput p_128935_, NbtAccounter p_128936_) throws IOException {
        Tag tag = CosmosNBTIOHandler.readUnnamedTag(p_128935_, 0, p_128936_);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(CompoundTag p_128942_, DataOutput p_128943_) throws IOException {
        CosmosNBTIOHandler.writeUnnamedTag((Tag)p_128942_, p_128943_);
    }

    public static void parse(DataInput p_197510_, StreamTagVisitor p_197511_) throws IOException {
        TagType tagtype = TagTypes.m_129397_((int)p_197510_.readByte());
        if (tagtype == EndTag.f_128533_) {
            if (p_197511_.m_196213_(EndTag.f_128533_) == StreamTagVisitor.ValueResult.CONTINUE) {
                p_197511_.m_196525_();
            }
        } else {
            switch (p_197511_.m_196213_(tagtype)) {
                default: {
                    break;
                }
                case BREAK: {
                    StringTag.m_197563_((DataInput)p_197510_);
                    tagtype.m_196159_(p_197510_);
                    break;
                }
                case CONTINUE: {
                    StringTag.m_197563_((DataInput)p_197510_);
                    tagtype.m_196511_(p_197510_, p_197511_);
                }
            }
        }
    }

    public static void writeUnnamedTag(Tag p_128951_, DataOutput p_128952_) throws IOException {
        p_128952_.writeByte(p_128951_.m_7060_());
        if (p_128951_.m_7060_() != 0) {
            p_128952_.writeUTF("");
            p_128951_.m_6434_(p_128952_);
        }
    }

    private static Tag readUnnamedTag(DataInput p_128931_, int p_128932_, NbtAccounter p_128933_) throws IOException {
        byte b0 = p_128931_.readByte();
        p_128933_.m_128926_(8L);
        if (b0 == 0) {
            return EndTag.f_128534_;
        }
        p_128933_.readUTF(p_128931_.readUTF());
        p_128933_.m_128926_(32L);
        try {
            return TagTypes.m_129397_((int)b0).m_7300_(p_128931_, p_128932_, p_128933_);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)ioexception, (String)"Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("NBT Tag");
            crashreportcategory.m_128159_("Tag type", (Object)b0);
            throw new ReportedException(crashreport);
        }
    }
}

