/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.common.util;

import com.ibm.icu.text.DecimalFormat;
import com.tcn.cosmoslibrary.common.interfaces.item.ICosmosTool;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemColourable;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemElytra;
import com.tcn.cosmoslibrary.common.item.CosmosItemTool;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CosmosUtil {
    public static final void syncBlockAndRerender(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        world.markAndNotifyBlock(pos, null, state, state, 2, 0);
    }

    public static boolean holdingWrench(Player playerIn) {
        if (playerIn.m_150109_().m_36056_().m_41619_()) {
            return false;
        }
        Item currentItem = playerIn.m_150109_().m_36056_().m_41720_();
        if (currentItem instanceof CosmosItemTool) {
            return ((CosmosItemTool)currentItem).isActive(playerIn.m_150109_().m_36056_());
        }
        return currentItem instanceof ICosmosTool;
    }

    public static void setToAir(Level worldIn, BlockPos pos) {
        worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public static boolean handEmpty(Player playerIn) {
        return playerIn.m_150109_().m_36056_().m_41619_();
    }

    public static boolean handItem(Player playerIn, Item item) {
        if (playerIn.m_150109_().m_36056_().m_41619_()) {
            return false;
        }
        Item currentItem = playerIn.m_150109_().m_36056_().m_41720_();
        return currentItem.equals(item);
    }

    public static ItemStack getStack(Player playerIn) {
        return playerIn.m_150109_().m_36056_();
    }

    public static ItemStack getStack(Player playerIn, InteractionHand hand) {
        return playerIn.m_21120_(hand);
    }

    public static Item getStackItem(Player playerIn) {
        return playerIn.m_150109_().m_36056_().m_41720_();
    }

    public static void addItem(Level worldIn, Player playerIn, Item item, int count) {
        if (!playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)item, count))) {
            BlockPos pos = playerIn.m_20183_();
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)item, count)));
        }
    }

    public static void addStack(Level worldIn, Player playerIn, ItemStack stackIn) {
        if (!playerIn.m_150109_().m_36054_(stackIn)) {
            BlockPos pos = playerIn.m_20183_();
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stackIn));
        }
    }

    public static ItemStack setArmourColourInformation(ItemStack stack, @Nullable ComponentColour mainColour, @Nullable ComponentColour wingColour) {
        Item stackItem = stack.m_41720_();
        if (stack.m_41782_()) {
            CompoundTag stackTag = stack.m_41783_();
            if (stackTag.m_128441_("nbt_data")) {
                int wing_colour;
                int colour;
                CompoundTag nbtData = stackTag.m_128469_("nbt_data");
                if (stackItem instanceof CosmosArmourItemColourable && mainColour != null && (colour = mainColour.dec()) > 0) {
                    nbtData.m_128405_("colour", colour);
                }
                if (stackItem instanceof CosmosArmourItemElytra && wingColour != null && (wing_colour = wingColour.dec()) >= 0) {
                    nbtData.m_128405_("wing_colour", wing_colour);
                }
            } else {
                int wing_colour;
                int colour;
                CompoundTag nbtData = new CompoundTag();
                if (stackItem instanceof CosmosArmourItemColourable && mainColour != null && (colour = mainColour.dec()) > 0) {
                    nbtData.m_128405_("colour", colour);
                }
                if (stackItem instanceof CosmosArmourItemElytra && wingColour != null && (wing_colour = wingColour.dec()) >= 0) {
                    nbtData.m_128405_("wing_colour", wing_colour);
                }
                stackTag.m_128365_("nbt_data", (Tag)nbtData);
                stack.m_41751_(stackTag);
            }
        } else {
            int wing_colour;
            int colour;
            CompoundTag stackTag = new CompoundTag();
            CompoundTag nbtData = new CompoundTag();
            if (stackItem instanceof CosmosArmourItemColourable && mainColour != null && (colour = mainColour.dec()) > 0) {
                nbtData.m_128405_("colour", colour);
            }
            if (stackItem instanceof CosmosArmourItemElytra && wingColour != null && (wing_colour = wingColour.getIndex()) > 0) {
                nbtData.m_128405_("wing_colour", wing_colour);
            }
            stackTag.m_128365_("nbt_data", (Tag)nbtData);
            stack.m_41751_(stackTag);
        }
        return stack;
    }

    public static ComponentColour getColourFromStack(ItemStack stackIn, @Nullable ComponentColour defaultColour) {
        DyeColor dyeColour = DyeColor.getColor((ItemStack)stackIn);
        if (defaultColour != null) {
            return dyeColour != null ? ComponentColour.fromIndex(dyeColour.m_41060_()) : defaultColour;
        }
        return dyeColour != null ? ComponentColour.fromIndex(dyeColour.m_41060_()) : ComponentColour.WHITE;
    }

    public static String formatIntegerBillion(int toFormat) {
        DecimalFormat formatter = new DecimalFormat("#,###,###,###");
        return formatter.format((long)toFormat);
    }

    public static String formatIntegerMillion(int toFormat) {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        return formatter.format((long)toFormat);
    }

    public static String getTimeHMS() {
        return CosmosUtil.getTimeHMS(":");
    }

    public static String getTimeHMS(String separator) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH" + separator + "mm" + separator + "ss");
        LocalDateTime now = LocalDateTime.now();
        return dtf.format(now).replace("/", "-").replace(" ", " | ");
    }

    public static String getDateYMD(boolean withTime, String separator) {
        DateTimeFormatter date = DateTimeFormatter.ofPattern("yyyy" + separator + "MM" + separator + "dd");
        LocalDateTime now = LocalDateTime.now();
        Object return_ = date.format(now).replace("/", "-").replace(" ", " | ");
        if (withTime) {
            return_ = (String)return_ + "_" + CosmosUtil.getTimeHMS("-");
        }
        return return_;
    }

    public static boolean isInBounds(VoxelShape shape, BlockPos pos, Vec3 hit) {
        AABB aabb = shape.m_83215_().m_82338_(pos);
        return hit.f_82479_ >= aabb.f_82288_ && hit.f_82479_ <= aabb.f_82291_ && hit.f_82480_ >= aabb.f_82289_ && hit.f_82480_ <= aabb.f_82292_ && hit.f_82481_ >= aabb.f_82290_ && hit.f_82481_ <= aabb.f_82293_;
    }

    public static AABB getBounds(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return new AABB((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    public static int getSides(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        int side_connect = 0;
        if (down) {
            side_connect = 1;
        }
        if (up) {
            side_connect = 2;
        }
        if (up && down) {
            side_connect = 3;
        }
        if (north) {
            side_connect = 4;
        }
        if (north && down) {
            side_connect = 5;
        }
        if (north && up) {
            side_connect = 6;
        }
        if (north && up && down) {
            side_connect = 7;
        }
        if (south) {
            side_connect = 8;
        }
        if (south && down) {
            side_connect = 9;
        }
        if (south && up) {
            side_connect = 10;
        }
        if (south && up && down) {
            side_connect = 11;
        }
        if (north && south) {
            side_connect = 12;
        }
        if (north && south && down) {
            side_connect = 13;
        }
        if (north && south && up) {
            side_connect = 14;
        }
        if (north && south && up && down) {
            side_connect = 15;
        }
        if (west) {
            side_connect = 16;
        }
        if (west && down) {
            side_connect = 17;
        }
        if (west && up) {
            side_connect = 18;
        }
        if (west && up && down) {
            side_connect = 19;
        }
        if (north && west) {
            side_connect = 20;
        }
        if (north && west && down) {
            side_connect = 21;
        }
        if (north && west && up) {
            side_connect = 22;
        }
        if (north && west && up && down) {
            side_connect = 23;
        }
        if (south && west) {
            side_connect = 24;
        }
        if (south && west && down) {
            side_connect = 25;
        }
        if (south && west && up) {
            side_connect = 26;
        }
        if (south && west && up && down) {
            side_connect = 27;
        }
        if (north && south && west) {
            side_connect = 28;
        }
        if (north && south && west && down) {
            side_connect = 29;
        }
        if (north && south && west && up) {
            side_connect = 30;
        }
        if (north && south && west && up && down) {
            side_connect = 31;
        }
        if (east) {
            side_connect = 32;
        }
        if (east && down) {
            side_connect = 33;
        }
        if (east && up) {
            side_connect = 34;
        }
        if (east && up && down) {
            side_connect = 35;
        }
        if (north && east) {
            side_connect = 36;
        }
        if (north && east && down) {
            side_connect = 37;
        }
        if (north && east && up) {
            side_connect = 38;
        }
        if (north && east && up && down) {
            side_connect = 39;
        }
        if (south && east) {
            side_connect = 40;
        }
        if (south && east && down) {
            side_connect = 41;
        }
        if (south && east && up) {
            side_connect = 42;
        }
        if (south && east && up && down) {
            side_connect = 43;
        }
        if (north && south && east) {
            side_connect = 44;
        }
        if (north && south && east && down) {
            side_connect = 45;
        }
        if (north && south && east && up) {
            side_connect = 46;
        }
        if (north && south && east && up && down) {
            side_connect = 47;
        }
        if (east && west) {
            side_connect = 48;
        }
        if (east && west && down) {
            side_connect = 49;
        }
        if (east && west && up) {
            side_connect = 50;
        }
        if (east && west && up && down) {
            side_connect = 51;
        }
        if (north && west && east) {
            side_connect = 52;
        }
        if (north && west && east && down) {
            side_connect = 53;
        }
        if (north && west && east && up) {
            side_connect = 54;
        }
        if (north && west && east && up && down) {
            side_connect = 55;
        }
        if (south && west && east) {
            side_connect = 56;
        }
        if (south && west && east && down) {
            side_connect = 57;
        }
        if (south && west && east && up) {
            side_connect = 58;
        }
        if (south && west && east && up && down) {
            side_connect = 59;
        }
        if (north && south && west && east) {
            side_connect = 60;
        }
        if (north && south && west && east && down) {
            side_connect = 61;
        }
        if (north && south && west && east && up) {
            side_connect = 62;
        }
        if (north && south && west && east && up && down) {
            side_connect = 63;
        }
        return side_connect;
    }
}

